#define	CURSES_LIBRARY	1
#define NEEDS_OS2       1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__scb = "$Header: c:/curses/private/RCS/_scb.c%v 2.0 1992/11/15 03:24:16 MH Rel $";
#endif

#ifdef OS2
#  if defined (CURSES__32BIT__) || defined (CSET2)
#     include <signal.h>
#  else
#     define INCL_DOSSIGNALS
#     define INCL_NOCOMMON
#     include <bsedos.h>
#  endif
#endif



/*man-start*********************************************************************

  PDC_set_ctrl_break()	- Enables/Disables the host OS BREAK key check.

  PDCurses Description:
 	This is a private PDCurses routine.

 	Enables/Disables the host OS BREAK key check. This function toggles
 	the BREAK setting. If it was on, it turns itoff; if it was aff it turns
 	it on.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_set_ctrl_break( bool setting );

**man-end**********************************************************************/

int	PDC_set_ctrl_break(bool setting)
{
#ifdef	FLEXOS
	retcode = s_get(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	if (retcode < 0L)
		return( ERR );

	vir.vc_kbmode = ((vir.vc_kbmode & ~0x01) & (setting) ? 0x01 : 0x00);

	retcode = s_set(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	return( (retcode < 0L) ? ERR : OK );
#endif
#ifdef	DOS
	regs.h.ah = 0x33;
	regs.h.al = 0x00;
	regs.h.dl = (unsigned char) (setting ? 1 : 0);
	int86(0x21, &regs, &regs);
	return( OK );
#endif
#ifdef	OS2
#  if defined (CURSES__32BIT__) || defined (CSET2)
	if (setting) {
		signal (SIGINT, SIG_DFL);
		signal (SIGBREAK, SIG_DFL);
	} else {
		signal (SIGINT, SIG_IGN);
		signal (SIGBREAK, SIG_IGN);
        }
	return( OK );
#  else
	PFNSIGHANDLER oldHandler;
	USHORT oldAction, Action;

	/* turn off control C checking */
	if (setting)
		Action = SIGA_KILL;
	else
		Action = SIGA_IGNORE;
	DosSetSigHandler((PFNSIGHANDLER) NULL, &oldHandler, &oldAction,
		Action, SIG_CTRLBREAK);
	DosSetSigHandler((PFNSIGHANDLER) NULL, &oldHandler, &oldAction,
		Action, SIG_CTRLC);
	return( OK );
#  endif	
#endif
}
