#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wgetstr

#ifndef	NDEBUG
char *rcsid_wgetstr = "$Header: c:/curses/portable/RCS/wgetstr.c%v 2.0 1992/11/15 03:29:26 MH Rel $";
#endif




/*man-start*********************************************************************

  wgetstr()	- read string

  X/Open Description:
 	A series of characters are read until a newline or carriage
 	return is received.  The resulting value is placed in the area
 	pointed to by the character pointer str.  The user's erase and
 	kill characters are interpreted.

 	NOTE: getstr(), mvgetstr(), and mvwgetstr() are macros.

  PDCurses Description:
 	The largest string returned will be 255 characters long.
 	This can be altered in the library be changing the MAXLINE #define.

 	WARNING:  This routine does not interpret the user's ERASE and
 		  KILL characters as advertised.

  X/Open Return Value:
 	These functions return OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wgetstr( WINDOW* win, char* str );
 	X/Open Dec '88	int wgetstr( WINDOW* win, char* str );
 	BSD Curses	int wgetstr( WINDOW* win, char* str );
 	SYS V Curses	int wgetstr( WINDOW* win, char* str );

**man-end**********************************************************************/


#define MAXLINE 255

int	wgetstr(WINDOW *win, char *str)
{
	char	tmp[MAXLINE+1];
	char	txt[MAXLINE+1];
	char	new_char[2] = {0};
	int	ch;
	int	chars = strlen(str);
	int	sy = win->_cury;
	int	sx = win->_curx;
	WINDOW*	w;
	bool	oldecho;
	bool	oldcbreak;
	bool	oldnodelay;

	if (win == (WINDOW *)NULL)
		return (ERR);

	w		= win;
	c_strbeg	= txt;			/* save for backspacing */
	oldcbreak	= _cursvar.cbreak;	/* remember states	 */
	oldecho		= _cursvar.echo;
	oldnodelay	= w->_nodelay;
	_cursvar.echo	= FALSE;		/* we do echo ourselves */
	w->_nodelay	= FALSE;		/* don't return -1	 */

	strcpy(txt, str);
	wprintw(w, str);
	wrefresh(w);
	ch = wgetch(w);
	while (ch != '\n')
	{

		new_char[0] = (ch & CHR_MSK);
		strcat(txt, new_char);
		chars++;

		switch (ch)
		{
		case 0x1b:	/* Escape */	/* Terminate String */
		case '\r':	/* CTRL-M */
		case KEY_ENTER:
			chars--;
			ch = '\n';
			continue;

		case 0x04:	/* CTRL-D */	/* Delete character */
		case 0x08:	/* CTRL-H */
			if (chars > 0)
				PDC_backchar(w, txt, &chars);
			break;

		case 0x17:	/* CTRL-W */	/* Delete word */
			chars--;
			while ((txt[chars] == ' ') && (chars > 0))
				PDC_backchar(w, txt, &chars);

			while ((txt[chars] != ' ') && (chars > 0))
				PDC_backchar(w, txt, &chars);
			break;

		case 0x15:	/* CTRL-U */	/* Delete line */
		case 0x18:	/* CTRL-X */
			chars++;
			while (chars > 0)
				PDC_backchar(w, txt, &chars);
			break;

		default:
			waddch(w, ch);
			wrefresh(w);
			break;
		}
		ch = wgetch(w);
	}

	memset(str, '\0', MAXLINE+1);
#ifdef FLEXOS
	_split_plane(w, txt, tmp, sy, sx, w->_cury, w->_curx - 1);
#endif
	if (strlen(txt) > 0);
	strcpy(str, txt);

	_cursvar.echo = oldecho;
	_cursvar.cbreak = oldcbreak;
	win->_nodelay = oldnodelay;
	return (OK);
}
