#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wclrtoeol

#ifndef	NDEBUG
char *rcsid_wclrtoeo = "$Header: c:/curses/portable/RCS/wclrtoeo.c%v 2.0 1992/11/15 03:29:03 MH Rel $";
#endif




/*man-start*********************************************************************

  wclrtoeol()	- erase line to right of cursor in window

  X/Open Description:
 	The current line to the right of the cursor, inclusive, is erased.

 	NOTE: clrtoeol() is a macro.

  PDCurses Description:
 	In addition to the X/Open specification, there also exist
 	mv[w]clrtoeol() versions which first position the cursor
 	then perform the [w]clrtoeol call.

  X/Open Return Value:
 	The wclrtoeol() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wclrtoeol( WINDOW* win );
 	X/Open Dec '88	int wclrtoeol( WINDOW* win );
 	BSD Curses	int wclrtoeol( WINDOW* win );
 	SYS V Curses	int wclrtoeol( WINDOW* win );

**man-end**********************************************************************/

int	wclrtoeol(WINDOW *win)
{
	int	y;
	int	x;
	int	minx;
	chtype	blank;
	chtype*	maxx;
	chtype*	ptr;
	chtype*	end;

	if (win == (WINDOW *)NULL)
		return( ERR );

	y	= win->_cury;
	x	= win->_curx;
	blank	= win->_blank | win->_attrs;
	end	= &win->_y[y][win->_maxx - 1];
	minx	= _NO_CHANGE;
	maxx	= &win->_y[y][x];

	for (ptr = maxx; ptr <= end; ptr++)
	{
		if (*ptr != blank)
		{
			maxx = ptr;
			if (minx == _NO_CHANGE)
			{
				minx = (int) (ptr - win->_y[y]);
			}
			*ptr = blank;
		}
	}

	if (minx != _NO_CHANGE)
	{
		if ((win->_firstch[y] > minx) ||
		    (win->_firstch[y] == _NO_CHANGE))
		{
			win->_firstch[y] = minx;
		}
		if (win->_lastch[y] < maxx - win->_y[y])
		{
			win->_lastch[y] = (int) (maxx - win->_y[y]);
		}
	}
	return( OK );
}
