#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wclrtobot

#ifndef	NDEBUG
char *rcsid_wclrtobo = "$Header: c:/curses/portable/RCS/wclrtobo.c%v 2.0 1992/11/15 03:28:56 MH Rel $";
#endif




/*man-start*********************************************************************

  wclrtobot()	- erase window

  X/Open Description:
 	All lines below the cursor in this window are erased.  The current
 	line to the right of the cursor, inclusive, is also erased.

 	NOTE:  clrtobot() is a macro.

  PDCurses Description:
 	There is no additional PDCurses functionality.

  X/Open Return Value:
 	The wclrtobot() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wclrtobot( WINDOW* win );
 	X/Open Dec '88	int wclrtobot( WINDOW* win );
 	BSD Curses	int wclrtobot( WINDOW* win );
 	SYS V Curses	int wclrtobot( WINDOW* win );

**man-end**********************************************************************/

int	wclrtobot(WINDOW *win)
{
	int	y;
	int	minx;
static	int	startx;
static	chtype	blank;
static	chtype*	ptr;
static	chtype*	end;
static	chtype*	maxx;

	if  (win == (WINDOW *)NULL)
		return( ERR );

	blank	= win->_blank | win->_attrs;
	startx	= win->_curx;

	for (y = win->_cury; y <= win->_bmarg; y++)
	{
		minx	= _NO_CHANGE;
		end	= &win->_y[y][win->_maxx - 1];
		for (ptr = &win->_y[y][startx]; ptr <= end; ptr++)
		{
			if (*ptr != blank)
			{
				maxx = ptr;
				if (minx == _NO_CHANGE)
				{
					minx = (int) (ptr - win->_y[y]);
				}
				*ptr = blank;
			}
		}
		if (minx != _NO_CHANGE)
		{
			if ((win->_firstch[y] > minx) ||
			    (win->_firstch[y] == _NO_CHANGE))
			{
				win->_firstch[y] = minx;
				if (win->_lastch[y] < maxx - win->_y[y])
				{
					win->_lastch[y] = (int) (maxx - win->_y[y]);
				}
			}
		}
		startx = 0;
	}
	return( OK );
}
