#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	scrollok

#ifndef	NDEBUG
char *rcsid_scrollok = "$Header: c:/curses/portable/RCS/scrollok.c%v 2.0 1992/11/15 03:29:31 MH Rel $";
#endif





/*man-start*********************************************************************

  scrollok()	- scrollok window

  X/Open Description:
 	This function controls what happens when the cursor of a window
 	is moved off the edge of the window or scrolling region, either
 	from a newline on the bottom line or by typing the last character
 	of the last line.  If the option is disabled, the cursor is left
 	on the bottom line.  If enabled, the window is scrolled up one
 	line and then refreshed.

  PDCurses Description:
 	This is also implemented as a macro.

  X/Open Return Value:
 	The scrollok() function returns OK on success otherwise ERR
 	is returned.

  PDCurses Errors:
 	It is an error to pass a NULL* window.

  Portability:
 	PDCurses	int scrollok( WINDOW* win, bool bf );
 	X/Open Dec '88	int scrollok( WINDOW* win, bool bf );
 	SysV Curses	int scrollok( WINDOW* win, bool bf );
 	BSD Curses	int scrollok( WINDOW* win, bool bf );

**man-end**********************************************************************/

int	scrollok(WINDOW *win, bool bf)
{
	if  (win == (WINDOW *)NULL)
		return( ERR );

	win->_scroll	= bf;
	return( OK );
}
