#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#define	LOCAL_VAR
#include <curses.h>
#undef	initscr




#ifndef	NDEBUG
char *rcsid_initscr = "$Header: c:/curses/portable/RCS/initscr.c%v 2.0 1992/11/15 03:29:35 MH Rel $";
#else
char*	_curses_notice = "PDCurses 2.0 - Public Domain 1992";
#endif



SCREEN _cursvar;		/* curses variables		*/

WINDOW*	curscr;			/* the current screen image	*/
WINDOW*	stdscr;			/* the default screen window	*/
WINDOW*	tmpwin;			/* the temporary screen image. formally in _cursvar */
int	_default_lines = 25;	/* default terminal height	*/
int	LINES;			/* current terminal height	*/
int	COLS;			/* current terminal width	*/

#if defined	DOS
Regs regs;
#endif

/*
 * Global definitions for charget routines
 */
int	c_pindex = 0;		/* putter index */
int	c_gindex = 1;		/* getter index */
int	c_ungind = 0;		/* wungetch() push index */
chtype	c_ungch[NUNGETCH];	/* array of ungotten chars */
WINDOW*	_getch_win_;

/*
 * Global definitions for setmode routines
 */
struct cttyset c_sh_tty = {0};	/* tty modes for def_shell_mode */
struct cttyset c_pr_tty = {0};	/* tty modes for def_prog_mode  */
struct cttyset c_save_tty = {0};
struct cttyset c_save_trm = {0};

/*
 * Global definitions for printscan routines
 */
char c_printscanbuf[513];	/* buffer used during I/O */

/*
 * Global definitions for strget routines
 */
char *c_strbeg;

#if	EMALLOC
void*	emalloc( size_t );
void*	ecalloc( size_t, size_t );
void	efree( void* );
	
extern	void*	emalloc();	/* user's emalloc(size)		*/
extern	void*	ecalloc();	/* user's ecalloc(num,size)	*/
extern	void	efree();	/* user's efree(ptr)		*/
#endif

extern	void*	malloc();	/* runtime's malloc(size)	*/
extern	void*	calloc();	/* runtime's calloc(num,size)	*/
extern	void	free();		/* runtime's free(ptr)		*/

void*	(*mallc)();		/* ptr to some malloc(size)	*/
void*	(*callc)();		/* ptr to some ecalloc(num,size)*/
void	(*fre)();		/* ptr to some free(ptr)	*/




/*man-start*********************************************************************

  initscr()	- Initialize terminal environment

  X/Open Description:
 	The first routine called should be initscr().  This will
 	deterine the terminal type and initialize all curses data
 	structures.  The initscr() function also arranges that the
 	first call to refresh() will clear the screen.  If errors
 	occur, initscr() will write an appropriate error message to
 	standard error and exit.  If the program wants an indication
 	of error conditions, newterm() should be used instead of
 	initscr().

  PDCurses Description:
 	Due to the fact that newterm() does not yet exist in PDCurses,
 	there is no way to recover from an error in initscr().

  X/Open Return Value:
 	The initscr() function returns stdscr on success and calls
 	exit() on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	WINDOW* initscr( void );
 	X/Open Dec '88	WINDOW* initscr( void );
 	BSD Curses	WINDOW* initscr( void );
 	SYS V Curses	WINDOW* initscr( void );

**man-end**********************************************************************/

WINDOW*	initscr(void)
{
	if  (_cursvar.alive)
		return( ERR );

	if  (_cursvar.emalloc == EMALLOC_MAGIC)
	{
#if	EMALLOC
		memset(&_cursvar, 0, sizeof(SCREEN));
		_cursvar.emalloc = TRUE;
		mallc = emalloc;
		callc = ecalloc;
		fre   = efree;
#endif
	}
	else
	{
		memset(&_cursvar, 0, sizeof(SCREEN));
		mallc = malloc;
		callc = calloc;
		fre   = free;
	}
	PDC_scr_open(&_cursvar, 0);
	_cursvar.orig_cursor = _cursvar.cursor;
/*	_cursvar.orig_font = PDC_get_font();*/
	_cursvar.orig_font = _cursvar.font;
	_cursvar.orgcbr = PDC_get_ctrl_break();
	_cursvar.blank = ' ';
#ifdef	FLEXOS
	_flexos_16bitmode();
#endif
/*	savetty();*/
/*	LINES = PDC_get_rows();*/
/*	COLS = PDC_get_columns(); */
	LINES = _cursvar.lines;
	COLS = _cursvar.cols;

	if ((tmpwin = newwin(LINES, COLS, 0, 0)) == (WINDOW *) ERR)
	{
		fprintf( stderr, "initscr(): Unable to create tmpwin.\n" );
		exit( 3 );
	}
	if ((curscr = newwin(LINES, COLS, 0, 0)) == (WINDOW *) ERR)
	{
		fprintf( stderr, "initscr(): Unable to create curscr.\n" );
		exit( 2 );
	}
	if ((stdscr = newwin(LINES, COLS, 0, 0)) == (WINDOW *) ERR)
	{
		fprintf( stderr, "initscr(): Unable to create stdscr.\n" );
		exit( 1 );
	}
	curscr->_clear = FALSE;
#ifdef	REGISTERWINDOWS
	_cursvar.refreshall = FALSE;
	_inswin(stdscr, (WINDOW *)NULL);
#endif
	_cursvar.alive = TRUE;
	def_shell_mode();
	return( stdscr );
}
