#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	clearok

#ifndef	NDEBUG
char *rcsid_clearok = "$Header: c:/curses/portable/RCS/clearok.c%v 2.0 1992/11/15 03:28:47 MH Rel $";
#endif




/*man-start*********************************************************************

  clearok()	- enable screen clearing

  X/Open Description:
 	If bf is TRUE, the next call to wrefresh() with this window will
 	clear the screen completely and redraw the entire screen.

  X/Open Return Value:
 	The clearok() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int clearok( WINDOW* win, bool flag );
 	X/Open Dec '88	int clearok( WINDOW* win, bool bf );
 	BSD Curses
 	SYS V Curses	int clearok( WINDOW* win, bool bf );

**man-end**********************************************************************/

int	clearok(WINDOW *win, bool flag)
{
	if (win == (WINDOW *)NULL)
		return( ERR );

	if (win == curscr)
		tmpwin->_clear = flag;
	else
		win->_clear = flag;

	return( OK );
}
