#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__gotoxy = "$Header: c:/curses/private/RCS/_gotoxy.c%v 2.0 1992/11/15 03:24:27 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_gotoxy()	- position hardware cursor at (x, y)

  PDCurses Description:
 	This is a private PDCurses routine.

 	Moves the physical cursor to the desired address on the
 	screen. We don't optimize here -- on a PC, it takes more time
 	to optimize than to do things directly.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_gotoxy( int row, int col );

**man-end**********************************************************************/

int	PDC_gotoxy(int row, int col)
{
	if ((_cursvar.cursrow == row) && (_cursvar.curscol == col))
		return( OK );

#ifdef	FLEXOS
	retcode = s_get(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	if (retcode < 0L)
		return( ERR );
	vir.vc_cursor.pos_row = row;
	vir.vc_cursor.pos_col = col;
	retcode = s_set(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	return( (retcode < 0L) ? ERR : OK );
#endif
#ifdef	DOS
	regs.h.ah = 0x02;
	regs.h.bh = _cursvar.video_page;
	regs.h.dh = (unsigned char) row;
	regs.h.dl = (unsigned char) col;
	int86(0x10, &regs, &regs);
	return( OK );
#endif
#ifdef	OS2
	VioSetCurPos (row, col, 0);
#endif
}
