#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__gcurcol = "$Header: c:/curses/private/RCS/_gcurcol.c%v 2.0 1992/11/15 03:24:22 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_get_cur_col()	- get current column position of cursor

  PDCurses Description:
 	This is a private PDCurses function

 	This routine returns the current column position of the cursor on
 	screen.

  PDCurses Return Value:
 	This routine returns the current column position of the cursor. No
 	error is returned.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	int	PDC_get_cur_col( void );

**man-end**********************************************************************/

int	PDC_get_cur_col(void)
{
#ifdef	FLEXOS
	retcode = s_get(T_VIRCON, 1L, (char *) &vir, (long) sizeof(vir));
	return( (retcode < 0L) ? ERR : vir.vc_cursor.pos_col );
#endif
#ifdef	DOS
	regs.x.ax = 0x0003;
	regs.h.bh = _cursvar.video_page;
	int86(0x10, &regs, &regs);
	return((int) regs.h.dl);
#endif
#ifdef	OS2
	USHORT curCol, curRow;
	
	/* find the current cursor position */
	VioGetCurPos ((PUSHORT) &curRow, (PUSHORT) &curCol, 0);
	return (curCol);
#endif
}
