#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__getcrsr = "$Header: c:/curses/private/RCS/_getcrsr.c%v 2.0 1992/11/15 03:24:25 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_get_cursor_mode()	- Get the cursor start and stop scan lines.

  PDCurses Description:
 	Gets the cursor type to begin in scan line startrow and end in
 	scan line endrow.  Both values should be 0-31.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_get_cursor_mode( void );

**man-end**********************************************************************/

int	PDC_get_cursor_mode(void)
{
#ifdef	FLEXOS
	/*
	 * Under FLEXOS, this routine returns 1 if the cursor is on and 0 if
	 * the cursor is off...
	 */
	s_getfield(T_VIRCON, VC_MODE, STDOUT, (far BYTE *) & vir,
		sizeof(vir.vc_mode));

	if (vir.vc_mode & VCWM_CURSOR)
		return (TRUE);
	else
		return (FALSE);
#endif
#ifdef	DOS
	short far*	CURSOR_MODE;
	short		cmode;

	CURSOR_MODE = (short far *) 0x0460L;
	cmode = *CURSOR_MODE;
	return (cmode);
#endif
#ifdef	OS2
	VIOCURSORINFO cursorInfo;
	short		cmode;

	VioGetCurType (&cursorInfo, 0);
/* I am not sure about this JGB */
	cmode = ((cursorInfo.yStart << 8) | (cursorInfo.cEnd));
	return(cmode);
#endif
}
