#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef	REGISTERWINDOWS
#ifndef	NDEBUG
char *rcsid__addtail = "$Header: c:/curses/private/RCS/_addtail.c%v 2.0 1992/11/15 03:24:17 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_addtail()	- add window to the visible window list

  PDCurses Description:
 	This is a private PDCurses function.

 	This routine adds the passed window pointer to the end fo the
 	visible window list.  All windows on this list will automatically
 	be refreshed if _cursvar.refreshall is true.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error to pass a NULL window pointer.

  Portability:
 	PDCurses	int	PDC_addtail( WINDOW* tail );

**man-end**********************************************************************/

int	PDC_addtail(WINDOW *tail)
{
	WINDS  *next = _cursvar.visible;

	if  (tail == (WINDOW *)NULL)
		return( ERR );

	while (next != (WINDS *)NULL)
	{
		if (next->next == NULL)
			break;
		next = next->next;
	}
	if (next == NULL)
		PDC_inswin(tail, (WINDOW *)NULL);
	else
	{
		if (next->w == NULL)
			PDC_inswin(tail, (WINDOW *)NULL);
		else
			PDC_addwin(tail, next->w);
	}
	return( OK );
}
#endif
