 /* TCDEMO1.C Pixshow for C version 2.0 (c) K.Willetts 1992/3
    Written and tested using Borland Turbo C++ 1.01.

 This program loads and displays a single full screen image. It first
 queries the .QPX image file for information, then loads/displays the
 image and finally overprints the image with the information. It is not
 necessary to query an image before displaying it. Written for EGA 640x350
 16 color but can be easily adapted to work in other modes.

 Compiling & Running from the environment:
 Open a Project File called TCDEMO1.PRJ and add the following:

   TCDEMO1.C
   PIXCS20.OBJ

 Set the SMALL memory model. The S in the .OBJ filename indicates
 the target memory model: S = Small, M = Medium, L = Large (Medium
 and Large memory models with Full version only). Don't forget this
 program needs access to the relevent .BGI driver (EGAVGA.BGI for EGA).
 Since this example uses 32k in the far heap, make sure you allow
 enough heap space when running from within the TC environment - In
 Options/Debugger dialog set a heap size of > 96k or farmalloc won't
 be able to find enough far heap space.
 */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <graphics.h>
#include <alloc.h>
#include "pixc20.h"    /* Pixshow v2.0 header file */


int main (void)
{
  struct qpxheader image;          /* See pixc20.h */
  char far *qpxbuf;                /* Far pointer to image parcel buffer */
  unsigned long bufsize = 32768;   /* Max possible size of image parcel */
  char pathtoexe[80];              /* Placeholder for path to image files */
  char qpxfilepath[80];            /* Pathname to .QPX image file */
  int driver = EGA;                /* This demo runs in EGA 640x350x16 */
  int mode = EGAHI;
  int videoerror;

  /*
  * Set EGA video mode and tell Pixshow what it is. Pixshow expects
  * setqpxmode(?) to supply a BIOS video mode number. It's down
  * to you to call setqpxmode with the correct argument. If you
  * mismatch videomodes strange things can happen, although EGA
  * 16 color images can be redisplayed in VGA, and vice-versa.
  */

  initgraph (&driver, &mode, "");
  videoerror = graphresult ();
  if (videoerror == grOk) {
    setqpxmode (0x0010);

  /*
  * Allocate 32k parcel buffer and tell Pixshow where it is. This buffer
  * is placed in the far heap. The parcel buffer is where images are
  * loaded to from disk and decompressed to video ram. You must ensure
  * setqpxbuffer is given a valid far address in offset/segment form.
  * See manual for full info on the parcel buffer.
  */

    if ((qpxbuf = farmalloc(bufsize)) != NULL) {
      setqpxbuffer (FP_OFF(qpxbuf), FP_SEG(qpxbuf));

  /*
  * Function qkgetexepath (below) copies into the string passed
  * to it the path to the .EXE file currently running, and returns
  * the strlen of the path. If you keep your .QPX image files in
  * the same subdirectory as your .EXE program they can always be
  * found. Make sure the string passed to qkgetexepath is long
  * enough to contain the complete pathname. If qkgetexepath does
  * not succeed (most unlikely) it returns a length of zero.
  * The use of qkgetexepath is not mandatory, just convenient...
  */

      if (qkgetexepath (pathtoexe)) {
        strcpy (qpxfilepath, pathtoexe);
      strcat (qpxfilepath, "egademo.qpx");
      } else
        strcpy (qpxfilepath, "egademo.qpx");

  /*
  * Now we have a path to the .QPX file we can query it by calling
  * Pixshow function getqpxinfo. The returned info will be used later
  * to overprint the displayed image...
  */

      getqpxinfo (qpxfilepath, &image);
                                                                                                                                                                                        /* working directory */
  /*
  * Load & display demo image file EGADEMO.QPX. The first argument
  * is the pathname to the .QPX file, including the .QPX extension.
  * Second & third arguments are tlc x & y image positions. If you
  * want the image to redisplay at it's original co-ordinates
  * (where it was when captured) set x to an impossibly large
  * value. The fourth argument when non-zero tells Pixshow to look for
  * a saved palette and use it if it's available (VGA only). The
  * final argument when non-zero attempts to suppress video refresh
  * while redisplaying the image. This results in slightly faster
  * performance but may not work with all non-VGA video systems.
  */

      showqpx (qpxfilepath, getmaxx()+1, 0, 0, 0);

  /*
  * Note: Both getqpxinfo and showqpx can return a success/failiure flag
  * but we didn't bother with them here. Now overprint with image details...
  */

      outtextxy (0, 0, "Pixshow (c) K.Willetts 1992/3");
      gotoxy (1, 18);
      printf ("Image information...\n");
      printf ("Videomode:    %x Hex\n", image.videomode);
      if (image.compression)
        printf ("Compression:  Pixelmap\n");
      else
        printf ("Compression:  Bytemap\n");
      printf ("Image tlc x:  %u\n", image.x);
      printf ("Image tlc y:  %u\n", image.y);
      printf ("Image brc x:  %u\n", image.x1);
      printf ("Image brc y:  %u\n", image.y1);
      printf ("First parcel: %u bytes", image.firstparcel);

  /* Wait for a keypress, then release memory and quit */

      outtextxy (getmaxx()-200,getmaxy()-8,"Press any key to exit...");
      while (!kbhit());
      farfree (qpxbuf);
      closegraph ();

    } else {
      closegraph ();
      printf ("Parcel Buffer allocation failed, program terminated\n");
      }
  } else {
    closegraph ();
    printf ("Unable to set requested videomode, program terminated\n");
    }

  return 0;
}

/* That's all folks */
