/* QCDEMO2.C Pixshow demo program (c) K.Willetts 1992/3
   For Microsoft Quick C, JPI Topspeed C & compatibles.

 This program displays 3 images from a .QPL image library file. It is
 written for EGA 640x350 16 color mode but can be easily adapted to work
 in other video modes.

 Compiling & Running from the environment:
 Microsoft users: Produce a .MAK file QCDEMO3.MAK, set the SMALL memory
 model and add the following to the Program List:

    QCDEMO2.C
    PIXCS20.OBJ

 Topspeed C users: Open a Project File QCDEMO3.PR, set the SMALL
 memory model and add   #pragma link(pixcs20.obj)   to the .PR file.
 */


#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <graph.h>
#include <malloc.h>
#include "pixc20.h"      /* Pixshow header file */


/* Declare local function */

void pixerror (int errornum);


main ()
{
  char far *qpxbuf;              /* Far pointer to image parcel buffer */
  unsigned bufsize = 32768;      /* Max possible size of image parcel */
  char imagepath[80];            /* Path to .QPL image file */


  /* Set videomode & allocate image parcel buffer in far heap */

  if (_setvideomode (_ERESCOLOR) && setqpxmode (_ERESCOLOR)) {
    if ((qpxbuf = (char far*)_fmalloc((size_t) bufsize)) != NULL) {
      setqpxbuffer (FP_OFF(qpxbuf), FP_SEG(qpxbuf));

  /* Get path to where this program resides on disk */

      if (!qkgetexepath (imagepath))
        pixerror (3);

  /*
  * Register the demo .QPL image library file. Remember the last .QPL file
  * registered remains open until closed by closeqpl. A call to
  * registerqpl automatically closes any previously registered library
  * file before the new one is registered.
  */

      strcat (imagepath, "egademo.qpl");
      if (!registerqpl (imagepath))
        pixerror (4);

  /* Show 3 library images. If an error occurs close the library */

      if (!showqpl ("QPL1", 0, 0, 0, 0))
        pixerror (5);

      if (!showqpl ("qpl2", 75, 90, 0, 0))
        pixerror (5);

      if (!showqpl ("Qpl3", 350, 275, 0, 0))
        pixerror (5);

  /* Wait for keypress... */

      while (!kbhit());
      getch ();

  /* Close .QPL library file, release parcel buffer memory and exit */

      closeqpl ();
      _ffree (qpxbuf);
      _setvideomode (_DEFAULTMODE);

    } else
      pixerror (2);   /* could not allocate parcel buffer memory */
  } else
    pixerror (1);     /* could not set requested videomode */

} /* main */


/* Error handler... */

void pixerror (int err)
  {
  _setvideomode (_DEFAULTMODE);
  switch (err) {
    case 1:
      printf ("Unable to set requested videomode, program terminated\n");
      break;
    case 2:
      printf ("Parcel buffer memory allocation failed, program terminated\n");
      break;
    case 3:
      printf ("Could not find path to image files, program terminated\n");
      break;
    case 4:
      printf ("Unable to register .QPL library file, program terminated\n");
      break;
    case 5:
      closeqpl ();
      printf ("Error reading .QPL library file, program terminated\n");
    default:
      break;
    }
  exit (0);
  }

/* That's all folks */
