













                              LE_C Library Functions
                                   Version 1.0


                                 Reference Manual






























                                        By
                      ProBATE Software Publishing Co., Inc.
                          3527 West 12th Street, Suite B
                                Greeley, CO  80634
                                  (303) 352-3445


           Copyright (c) 1990 By ProBATE Software Publishing Co., Inc.
                               All Rights Reserved





                                License Agreement

     The LE_C  Library is  protected by  United States Copyright  Law.   All
     rights are  reserved by  ProBATE Software  Publishing Co.,  Inc.   Non-
     registered users  of LE_C  are licensed only  to use  the program  on a
     trial basis for the sole purpose of determining whether or not it meets
     their requirements.  All other use requires registration.

     Any other use of non-registered copies of LE_C by any person, business,
     corporation,  or  any  other entity  is  strictly  forbidden  and is  a
     violation of this license agreement.

     Registered users are  licensed to use the LE_C  Library on one computer
     only.

     All users are  granted a limited license to copy LE_C Library for trial
     use of others, with the following conditions:

       LE_C Library must be distributed in unmodified, complete
       form, including the manual, and license agreement.

       No fee, other than a disk duplicating fee, not to
       exceed, $6.00, may be charged for LE_C Library.

     ProBATE  Software  Publishing Co.,  Inc.  grants, to  registered owners
     only, a  royalty-free right  to reproduce and  distribute the  run-time
     routines provided they are distributed only  in conjunction with and as
     part of a software product.




                                     Warranty

     Disclaimer of Warranties

     ProBATE Software  Publishing Co., Inc. makes LE_C Library available "as
     is" and  is not  making any warranties  of any  kind including  but not
     limited to implied  warranties of merchantability  or of fitness for  a
     particular purpose.   ProBATE Software  Publishing Co.,  Inc. does  not
     guarantee the accuracy,  adequacy, or  completeness of the  information
     contained  in  the  software  and   documentation.    ProBATE  Software
     Publishing Co., Inc.  does not accept liability for any  loss or damage
     resulting  from the use  of this software  and documentation, including
     direct, indirect, consequential, or special damage.

     Choice of Law
     The rights and obligations of you  and ProBATE Software Publishing Co.,
     Inc. with respect to  the LE_C Library shall be governed by the laws of
     the state of Colorado and, where applicable, of the United States.




                                   Registration

     Registration  entitles  you  to   use  the  LE_C  Library  1.0.     Any
     unregistered use  other than trial use to determine if LE_C meets yours
     needs  is  a  violation  of  the  license  agreement  and  is  strictly
     forbidden.

     Single user registration is available for  $30.00 per copy.  Registered
     users  will receive  the most  current version of  LE_C Library.   This
     includes the complete C source code.  Registration also entitles you to
     discounts on future products.

     The LE_C license authorizes  the use of one copy of LE_C for use on one
     computer only.  If  you have multiple computers, either  standalone, or
     networked, you must register one  copy of LE_C for each  workstation on
     which LE_C will be used. 



                      ProBATE Software Publishing Co., Inc.
                          3527 West 12th Street, Suite B
                                Greeley, CO  80634
                                  (303) 352-3445

                 Quantity      Unit Price    Extended Price

                 ________        $30.00      ______________


          Colorado Residents Add 3% Tax      ______________


                                  Total      ______________

     Name: _____________________________________________________

     Company: __________________________________________________

     Address: __________________________________________________

     City: _____________________________________________________

     Phone: ____________________________________________________

     Check #:  _________________________________________________

     VISA/MC# ________________________________  Exp. ___________
      
     Card Holder's Name: _______________________________________
                                
     Card Holder's Signature:  _________________________________


             CALL 1-800-288-9169 or 1-303-352-3445 to Order by Phone




                                Table of Contents

     Introduction . . . . . . . . . . . . . . . . . . . . . . . .   1
     Miscellaneous  . . . . . . . . . . . . . . . . . . . . . . .   2
        Video Modes . . . . . . . . . . . . . . . . . . . . . . .   2
        Screen Coordinates  . . . . . . . . . . . . . . . . . . .   2
        LE_C Library Object Files . . . . . . . . . . . . . . . .   2
        LE_C Help Facility  . . . . . . . . . . . . . . . . . . .   2
     Constants  . . . . . . . . . . . . . . . . . . . . . . . . .   3
     Structures . . . . . . . . . . . . . . . . . . . . . . . . .   4
        fkey  . . . . . . . . . . . . . . . . . . . . . . . . . .   4
        item_struct . . . . . . . . . . . . . . . . . . . . . . .   4
        BMENU . . . . . . . . . . . . . . . . . . . . . . . . . .   4
        BMENU_ITEMS . . . . . . . . . . . . . . . . . . . . . . .   5
        BOX_MENU  . . . . . . . . . . . . . . . . . . . . . . . .   5
     Globals  . . . . . . . . . . . . . . . . . . . . . . . . . .   6
        _le_help_page . . . . . . . . . . . . . . . . . . . . . .   6
        _le_help_load_sw  . . . . . . . . . . . . . . . . . . . .   6
        _le_help_file . . . . . . . . . . . . . . . . . . . . . .   6
        _le_help_row  . . . . . . . . . . . . . . . . . . . . . .   6
        _le_help_col  . . . . . . . . . . . . . . . . . . . . . .   6
        _le_help_width  . . . . . . . . . . . . . . . . . . . . .   6
        _le_help_move_sw  . . . . . . . . . . . . . . . . . . . .   6
        _le_help_reset_clr  . . . . . . . . . . . . . . . . . . .   7
        _le_help_clr  . . . . . . . . . . . . . . . . . . . . . .   7
        _le_help_explode_sw . . . . . . . . . . . . . . . . . . .   7
        _le_help_box_type . . . . . . . . . . . . . . . . . . . .   7
        _le_clr_in  . . . . . . . . . . . . . . . . . . . . . . .   7
        _le_clr_out . . . . . . . . . . . . . . . . . . . . . . .   7
        _le_toggle_key1 . . . . . . . . . . . . . . . . . . . . .   7
        _le_toggle_key2 . . . . . . . . . . . . . . . . . . . . .   8
        _le_skey[]  . . . . . . . . . . . . . . . . . . . . . . .   8
        _le_bmenu_bar_clr . . . . . . . . . . . . . . . . . . . .   8
        _le_bmenu_clr . . . . . . . . . . . . . . . . . . . . . .   8
        _le_bmenu_act_clr . . . . . . . . . . . . . . . . . . . .   8
        _le_bmenu_norm_act_clr  . . . . . . . . . . . . . . . . .   8
        _le_bmenu_shadow  . . . . . . . . . . . . . . . . . . . .   8
        _le_bmenu_hot_sw  . . . . . . . . . . . . . . . . . . . .   9
        _le_bmenu_width . . . . . . . . . . . . . . . . . . . . .   9
        _le_bmenu_rows  . . . . . . . . . . . . . . . . . . . . .   9
     Functions  . . . . . . . . . . . . . . . . . . . . . . . . .  10
        le_date.c functions . . . . . . . . . . . . . . . . . . .  10
           le_get_date  . . . . . . . . . . . . . . . . . . . . .  10
        le_dbl.c functions  . . . . . . . . . . . . . . . . . . .  12
           le_get_double  . . . . . . . . . . . . . . . . . . . .  12
           le_format_double . . . . . . . . . . . . . . . . . . .  13
           le_round_double  . . . . . . . . . . . . . . . . . . .  14
        le_help.c functions . . . . . . . . . . . . . . . . . . .  15
           le_read_help . . . . . . . . . . . . . . . . . . . . .  15
           le_help  . . . . . . . . . . . . . . . . . . . . . . .  15
        le_init.c functions . . . . . . . . . . . . . . . . . . .  17
           le_init_field  . . . . . . . . . . . . . . . . . . . .  17
        le_inpt.c functions . . . . . . . . . . . . . . . . . . .  18
           le_input . . . . . . . . . . . . . . . . . . . . . . .  18





                                Table of Contents

        le_item.c functions . . . . . . . . . . . . . . . . . . .  21
           le_item_switch . . . . . . . . . . . . . . . . . . . .  21
        le_key.c functions  . . . . . . . . . . . . . . . . . . .  23
           le_get_key . . . . . . . . . . . . . . . . . . . . . .  23
        le_long.c functions . . . . . . . . . . . . . . . . . . .  24
           le_get_long  . . . . . . . . . . . . . . . . . . . . .  24
           le_format_long . . . . . . . . . . . . . . . . . . . .  25
        le_menu.c functions . . . . . . . . . . . . . . . . . . .  26
           le_bmenu . . . . . . . . . . . . . . . . . . . . . . .  26
           le_box_menu  . . . . . . . . . . . . . . . . . . . . .  28
        le_misc.c functions . . . . . . . . . . . . . . . . . . .  30
           le_goto_xy . . . . . . . . . . . . . . . . . . . . . .  30
           le_scroll_up . . . . . . . . . . . . . . . . . . . . .  31
           le_scroll_down . . . . . . . . . . . . . . . . . . . .  31
           le_size_cursor . . . . . . . . . . . . . . . . . . . .  33
        le_save.c functions . . . . . . . . . . . . . . . . . . .  34
           le_build_buffers . . . . . . . . . . . . . . . . . . .  34
           le_save_block  . . . . . . . . . . . . . . . . . . . .  35       
           le_restore_block . . . . . . . . . . . . . . . . . . .  35
           le_save_scrn . . . . . . . . . . . . . . . . . . . . .  37
           le_restore_scrn  . . . . . . . . . . . . . . . . . . .  37
        le_strng.c functions  . . . . . . . . . . . . . . . . . .  39
           le_get_multln  . . . . . . . . . . . . . . . . . . . .  39
           le_get_string  . . . . . . . . . . . . . . . . . . . .  40
        le_util.c functions . . . . . . . . . . . . . . . . . . .  41
           le_display_error . . . . . . . . . . . . . . . . . . .  41
           le_fright_zero . . . . . . . . . . . . . . . . . . . .  42
           le_fudge_factor  . . . . . . . . . . . . . . . . . . .  43
           le_wait  . . . . . . . . . . . . . . . . . . . . . . .  43
           le_init_fkey_struct  . . . . . . . . . . . . . . . . .  44
           le_is_dos_legal  . . . . . . . . . . . . . . . . . . .  45
           le_locate_file . . . . . . . . . . . . . . . . . . . .  46
           le_long_to_date  . . . . . . . . . . . . . . . . . . .  47
           le_severe_error  . . . . . . . . . . . . . . . . . . .  48
           le_system_date . . . . . . . . . . . . . . . . . . . .  49
           le_verify_date . . . . . . . . . . . . . . . . . . . .  50
           le_word_wrap . . . . . . . . . . . . . . . . . . . . .  51
        le_vid.c functions  . . . . . . . . . . . . . . . . . . .  52
           le_set_video_mem . . . . . . . . . . . . . . . . . . .  52
           le_video_mode  . . . . . . . . . . . . . . . . . . . .  53
        le_write.c functions  . . . . . . . . . . . . . . . . . .  54
           le_clear_block . . . . . . . . . . . . . . . . . . . .  54
           le_cls . . . . . . . . . . . . . . . . . . . . . . . .  55
           le_draw_border . . . . . . . . . . . . . . . . . . . .  56
           le_draw_hline  . . . . . . . . . . . . . . . . . . . .  57
           le_draw_vline  . . . . . . . . . . . . . . . . . . . .  58
           le_fill_block  . . . . . . . . . . . . . . . . . . . .  59
           le_rewrite_scrn  . . . . . . . . . . . . . . . . . . .  60
           le_write_char  . . . . . . . . . . . . . . . . . . . .  61
           le_write_string  . . . . . . . . . . . . . . . . . . .  62
           le_write_far_string  . . . . . . . . . . . . . . . . .  63




                                                                Introduction
     -----------------------------------------------------------------------

                                   Introduction

     The LE_C  Library is a comprehensive  set of C run-time  functions that
     allows you to  easily create  programs that implement  many of  today's
     standard user interfaces.  LE_C contains routines for menus, box menus,
     data entry, help facility, border  drawing (including exploding boxes),
     line drawing, and  much, much more.   Most of the LE_C  functions write
     directly to the video memory page -- giving you fast screens.

     What makes LE_C unique is its integrated help facility functions.  LE_C
     allows  you to  create a very  useful help  facility with a  minimum of
     fuss.   All  of the  menu  and input  functions  of LE_C  support  help
     screens.  In addition, you can specify help screens unique to each menu
     selection.   Plus,  LE_C will allow  the user  to move the  help window
     within the screen.

     LE_C also allows  you to specify up  to 40 special function  keys (e.g.
     Ctrl-F1, Ctrl-End, etc.)  for use  with the menu  and input  functions.
     These 40 keys are in addition to the pre-defined commonly used function
     keys.

     Extra Bonus!  All  registered users will  receive the screen painter  &
     code generator.   The  screen painter  & code generator  allows you  to
     create  screens complete with boxes and lines.   This utility will then
     generate LE_C function calls for the desired screen.

     The LE_C library functions were developed  using QuickC Version 2.0 and
     should be compatible with Microsoft C.

     We hope  you enjoy  using these functions  as much  as we  had creating
     them.  If you have any suggestions, please call or write us.

     Thank You.  We look forward to your registration.










     QuickC   and  Microsoft   are   registered   trademarks  of   Microsoft
     Corporation.



     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 1




                                                               Miscellaneous
     -----------------------------------------------------------------------

                                  Miscellaneous

     Since many of  the LE_C functions write directly to  video memory, your
     video must be  in one of the  three text modes (2,  3, or 7).   If LE_C
     detects any  mode other than 2, 3, or 7,  it will display a message and
     immediately terminate the program.

     The screen coordinates  for displaying strings, boxes,  lines, etc. are
     absolute screen values.  That  is, the upper left corner is 0,0 and the
     lower right corner is 24,79.  Other values will  result in unsuccessful
     function calls.

     The LE_C functions are divided into several object modules
     that perform various functions.  These modules are the following:

       Object File      Description
       ------------     -----------------------------------------
       le_date.obj      date input function
       le_dbl.obj       double value input/format functions
       le_glob.obj      global variable declarations 
       le_help.obj      LE_C help facility functions  
       le_init.obj      field initialization function
       le_item.obj      item switch input function
       le_key.obj       key input function
       le_long.obj      long value input/format functions
       le_menu.obj      bar and box menu functions
       le_misc.obj      screen scrolling and cursor functions
       le_save.obj      screen saving/restoring functions
       le_skey.obj      special function key function
       le_strng.obj     string and multi-line input functions
       le_util.obj      miscellaneous utility functions
       le_vid.obj       video mode functions
       le_write.obj     screen functions

     The LE_C library functions  were compiled, linked, and tested  with the
     medium model of the QuickC version 2.0 compiler.

     The le_c.hlp file contains your help screens.  Each reference to a help
     page  in  your programs  via  LE_C  menus and/or  input  functions must
     contain  a  corresponding help  page in  le_c.hlp.   The  help facility
     should be in the following layout:
        >1                   <-  Page #
        This is help page number one.
        This is line two of number one.
        >2
        This is help page number two...
        <                    <-End of help facility

     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 2




                                                                   Constants
     -----------------------------------------------------------------------

                                  LE_C Constants

     The following  is a list of the commonly  used constants defined in the
     le_c.h header file.  Others not listed are self-explanatory.

     Box drawing and line drawing constants:
       SINGLE_LINE 1
       DOUBLE_LINE 2
       SVER_DHOR 3     /* box: single vertical - double horizontal */
       DVER_SHOR 4     /* box: double vertical - single horizontal */
       SINGLE_ENDS 3   /* line: single ver/hor line with ends */
       DOUBLE_ENDS 4   /* line: double ver/hor line with ends */

     Exploding box constants:
       EXPLODE_ON  1
       EXPLODE_OFF 0

     le_input() constants:
       GET_DOUBLE 0
       GET_LONG   1
       GET_DATE   2
       GET_ITEM   3
       GET_MULTLN 4
       GET_STRING 5

     le_restore_block() constants:
       RESTORE_ONLY 1
       FREE_ONLY    2
       RESTORE_FREE 3



















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 3




                                                                  Structures
     -----------------------------------------------------------------------

                                 LE_C Structures

     The following is a  brief explanation of various structures  defined by
     LE_C.  The le_c.h header file contains more detailed information.

     fkey
     This structure defines the function keys that cause one of the input or
     menu functions to  return.  fkey is a bit-field structure with each key
     holding  a  value of  either 0  or 1  (on/off). Supported  keys include
     F1-F12, PgDn, PgUp, Up arrow, and Down arrow.

     Functions  requiring  the use  of the  fkey  structure will  return the
     following values if the function key has been set to on (1).

        F1 - 1, unless there is help available
        F2 - 2
        F3 - 3
        F4 - 4
        F5 - 5
        F6 - 6
        F7 - 7
        F8 - 8
        F9 - 9
        F10 - 10
        F11 - 11
        F12 - 12
        Up arrow - (-1)
        Down arrow - (-2)
        PgUp - (-3)
        PgDn - (-4)

     item_struct
     This  structure defines  the row,  column,  width, number  of items,and
     current position for a call to the le_item_switch() function.

     le_input
     This structure defines  the fields for  use in the le_input()  function
     call.    Please see  the  description  of the  le_input()  function for
     detailed use of this structure.

     BMENU
     This structure contains information about the  bar menu to be displayed
     by  the le_bmenu()  function.   It  contains  a pointer  to the  title,
     row/col,  current  position,  number  items,  box type,  exploding  box
     switch, and a page of the  help facility.  The row/col is the  position
     of the first selection.


     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 4




                                                                  Structures
     -----------------------------------------------------------------------

     BMENU_ITEMS
     This structure defines  the bar menu items for a call to the le_bmenu()
     function.  It contains a pointer to the item, its hot key position, and
     page of the help facility.

     BOX_MENU
     This  structure  contains  information about  a  box  menu  type to  be
     displayed by  the le_box_menu() function.   It contains  three optional
     pointers to messages, current menu  selection position, row/col, number
     of items, exploding box switch, and a  page of the help facility.   The
     row/col is the position of the first selection.





































     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 5




                                                                     Globals
     -----------------------------------------------------------------------

                                   LE_C Globals

     le_help.c globals

     _le_help_page[]
     This  variable is  a table  of long integers  that contains  the offset
     address of each help page.   The number of help pages is set  to 200 by
     LE_HELP_PAGES.  It  is recommended that you do not change the number of
     pages since le_help.c was compiled using 200.

     _le_help_load_sw
     This variable indicates as to whether or not the help facility has been
     read  by  le_read_help().     The  switch   is  automatically  set   by
     le_read_help() after the _le_help_page[] table has been filled.

     _le_help_file[]
     This  is the  file  name of  the help  facility  file.   It  is set  to
     "le_c.hlp".  If you wish to change the name of the  help facility file,
     use the strcpy() function.  It is assumed that the help file is located
     in the current directory. 

     _le_help_row
     This variable indicates the  starting row position of the  help window.
     The default  is absolute row 4.  If the _le_help_move_sw is set and the
     help screen has  been moved by the user, _le_help_row  will contain the
     current setting. 

     _le_help_col
     This  variable  indicates  the starting  column  position  of  the help
     window.  The default is absolute column 19.  If the _le_help_move_sw is
     set and the help  screen has been moved by the  user, _le_help_col will
     contain the current setting.

     _le_help_width
     This variable contains the width of the help screen.  The default width
     is 40.

     _le_help_move_sw
     This switch  indicates as to whether or not the  user may move the help
     window somewhere else on  the screen with the arrow keys.   The default
     is ON (1).







     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 6




                                                                     Globals
     -----------------------------------------------------------------------

     _le_help_reset_clr
     This variable contains the  color to reset the background  screen prior
     to displaying the help  screen.  The default is 0.  If a non-zero value
     is used,  that  value will  be  used  in a  le_rewrite_scrn()  call  in
     le_help().   Since le_help() automatically  saves the  screen, it  will
     automatically be restored on exit.  The default is 0.

     _le_help_clr
     This variable contains the help screen color.  The default is 112.

     _le_help_explode_sw
     This  switch indicates  as to whether  the help screen  is an exploding
     box.   Valid values  are EXPLODE_ON  and EXPLODE_OFF.   The default  is
     EXPLODE_ON.  If  you use exploding boxes  and help screens, be  sure to
     call le_fudge_factor() during  program initialization.

     _le_help_box_type;
     This variable  indicates the type of box to  use when creating the help
     window.    Valid values  are  SINGLE_LINE, DOUBLE_LINE,  SVER_DHOR, and
     DVER_SHOR. The default is DOUBLE_LINE. 

     le_input.c globals

     _le_clr_in
     This variable indicates the color to be used during input.  The default
     is 12.

     _le_clr_out
     This variable indicates  the color to reset the input field to on exit.
     The default is 30.

     _le_toggle_key1
     This variable is the integer value of the  key to be used for returning
     to the  previous field when using the le_input() function.  The default
     value is the reverse tab  (shift-tab).  If you use a special key, don't
     forget  that its integer  value is its  value times 256.   For example,
     CTRL-Left Arrow  is 29440.  Also, if you use a regular key, its integer
     value is its scan code times 256 plus its ASCII value.










     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 7




                                                                     Globals
     -----------------------------------------------------------------------

     _le_toggle_key2
     This variable is the integer value of the key  to be used for advancing
     to the  next field  when using  the le_input()  function.   The default
     value is the tab key.  If you use  a special key, don't forget that its
     integer value is the value times 256.  For example, CTRL-Right Arrow is
     29696.  Also, if you use  a regular key, its integer value is  its scan
     code times 256 plus its ASCII value.

     _le_skey[]
     This table of integers defines a list  of special function keys for use
     with the LE_C input and  menu functions.  Up to 40 special  keys may be
     defined.   If you  use a special  extended key,  don't forget  that its
     integer value is the value times 256.  For example, CTRL-Right Arrow is
     29696 (116 * 256).   Also, if you use a regular  key, its integer value
     is its scan code times 256 plus its ASCII value.

     Every item in the _le_skey[] table is initialized to zero.

     The LE_C input and menu functions  will return a value from -11 to  -51
     for table elements 0-39 respectively.


     le_menu.c globals

     _le_bmenu_bar_clr
     This variable contains the color to be used for the menu bar for a call
     to le_bmenu().  Its default value is 12.

     _le_bmenu_clr
     This variable contains the color to be used for the menu for a call  to
     le_bmenu().  Its default value is 112.

     _le_bmenu_act_clr
     This  variable contains  the color to  be used for  the activation (hot
     key) key in the menu bar.  Its default value is 15.

     _le_bmenu_norm_act_clr
     This variable contains  the color to  be used for  the activation  (hot
     key) key in the menu.  Its default value is 127.

     _le_bmenu_shadow
     This variable contains the shadow color for the menu.  If
     you do not wish to use the shadow feature, set it to 0.





     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 8




                                                                     Globals
     -----------------------------------------------------------------------

     _le_bmenu_hot_sw
     This switch indicates whether  or not menu selections can  be activated
     by a hot key.  Its default value is 1 for on.

     _le_bmenu_width
     This variable contains  the explicit width  of a  bar menu.   If it  is
     zero,  the  le_bmenu()  function  will  automatically  size  the  menu.
     Otherwise, le_bmenu()  will set it  to the  defined with.   Its default
     value is 0.

     _le_bmenu_rows
     This variable contains the  explicit number of rows of a  bar menu.  If
     it is zero, the  le_bmenu() function will automatically size  the menu.
     Otherwise, le_bmenu() will set the number  of rows to the defined rows.
     Its default value is 0.

































     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order                Page 9




                                                              LE_C Functions
     -----------------------------------------------------------------------

                                  LE_C Functions

     The following is an explanation of each of the LE_C functions.  A brief
     description, required parameters, and  a short example is  provided for
     each function.   Feel free to experiment with the examples.  After all,
     the best way to discover LE_C's functions is by doing.

     le_date.c functions

     le_get_date(date, row, col, xkey, help)

     This function will allow the user to  enter a date in the standard date
     format of either MM/DD/YY  or MM/DD/YYYY.  This routine will not verify
     a date.  Use the le_verify_date() to validate a date.

     The function will automatically  advance to the next space  when either
     at the end of the MM or DD field  or when the / is pressed.  The  space
     bar may be used to clear the field and start over.

       (char *) date : character pointer to 11 byte date field
       (char) row : row position of input field
       (char) col : column position of input field
       (struct fkey) xkey : active function keys
       (int) help : help page

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program assumes that the le_c.hlp file
        contains page one of the help facility */

     /* this function will allow the input of a date */
     main()
     {
        char my_date[]={"  /  /    "};
        struct fkey xkey;
        int ret_val;

        le_init_fkey_struct(&xkey);  /* initialize function key structure */

        xkey.F10=1;          /* exit if F10 is pressed */


     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 10




                                                              LE_C Functions
     -----------------------------------------------------------------------

        /* clear screen */
        le_clear_block(0,0,24,79,30);

        /* get date */
        ret_val=le_get_date(my_date, 10, 0, xkey, 1);

        le_goto_xy(20,0);
        printf("Return value: %d",ret_val);
     }







































     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 11




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_dbl.c functions

     le_get_double(value, row, col, left, right, xkey, help)

     This function will allow the user to input a double value.   This value
     may have  up to 1-12  digits left of  the decimal point  and up to  1-6
     digits right of the decimal point.  The  input and output colors may be
     changed by changing the global variables _le_clr_in & _le_clr_out.

     The space bar may be used to clear the field. 
      
       (double *) value : pointer to double precision variable
       (char) row : row position of input field
       (char) col : column position of input field
       (char) left : digits left of decimal
       (char) right : digits right of decimal
       (struct fkey) xkey : active function keys
       (int) help : help facility page

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed
     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program assumes that the le_c.hlp file
        contains page one of the help facility */
     /* this function will allow the input of a double value */
     main()
     {
        double my_value=12345.6789;
        struct fkey xkey;
        int ret_val;

        le_init_fkey_struct(&xkey);  /* initialize function key structure */

        xkey.F10=1;          /* exit if F10 is pressed */

        /* clear screen */
        le_clear_block(0,0,24,79,30);
        /* get value */
        ret_val=le_get_double(&my_value, 10, 0, 8, 6, xkey, 1);

        le_goto_xy(20,0);
        printf("Return value: %d",ret_val);
     }

     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 12




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_format_double(value, format, left, right, dollar_sw)

     This function  will format a  double type  with commas and  an optional
     dollar sign.   A pointer to the  double type is passed  in addition the
     format string, the maximum number of digits left of the  decimal point,
     the maximum number of digits right of the decimal point, and the dollar
     sign switch.  This function will  automatically round the value to  the
     right_dig precision.  This  function assumes that the format  string is
     large enough to receive  the formatted value.  Its minimum  size should
     be the total of  left_dig, right_dig, 1 for decimal point,  1 for sign,
     and 1 for null terminating string.

       (double *) value : double pointer to value
       (char []) format : format string
       (int) left : number of digits left of decimal
       (int) right : number of digits right of decimal
       (char) dollar_sw : dollar sign switch

     Return Value : 0 is returned if unsuccessful
                    1 is returned if successful

     Example:
     #include <stdio.h>
     #include <le_c.h>


     /* this program will format a double value */
     main()
     {
          double my_value=12345.6789;
          char format1[15];

          le_format_double(&my_value, format1, 6, 2, 1);
          printf("Formatted value:  %s\n",format1);
     }













     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 13




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_round_double(value, digits)

     This function will round a double  precision up to the specified number
     of decimal digits (0-6).

       (double *) value : pointer to double to be rounded
       (int) digits : number of decimal digits to round to

     Return Value: none

     Example:

     #include <stdio.h>
     #include <le_c.h>

     main()
     {
        double my_value=12345.6789;

        printf("Before rounding: %10.4lf\n",my_value);

        /* round value to 2 digits */
        le_round_double(&my_value, 2);

        printf("After rounding: %10.4lf\n",my_value);
     }






















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 14




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_help.c functions

     le_read_help() & le_help(help_page)

     le_read_help()
     This function will  read the help file  and build a table of  help page
     locations.  The help file must be in  the following layout in order for
     this function to read it successfully.  The width of each line in  this
     ASCII file must  be <=  _le_help_width.   It is  recommended that  this
     function  be  called during  initialization  of the  program  since the
     entire help facility must be read.  Otherwise, le_help() will call this
     function if the le_help_page[] table has not been initialized.

        Help file layout:
        >1                   <-  Page #
        This is help page number one.
        This is line two of number one.
        >2
        This is help page number two.
        >3
        This is help page number three.
        <                    <-End of help facility

     Return Value:  none

     le_help(help_page)
     This function will display a page from the help facility.   The current
     screen is automatically saved  by a call to le_save_scrn()  and will be
     restored upon exit by le_restore_scrn().  The help_page must be a valid
     help page of  the facility.  If  the _le_help_move_sw is set,  the user
     may move the help  window with the arrow keys.  The help screen will be
     displayed until the user presses any key.  Please  read the information
     on the le_help.c globals for changing various le_help() defaults.

       (int) help_page : help page in help facility













     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 15




                                                              LE_C Functions
     -----------------------------------------------------------------------

     Example:

     #include <le_c.h>

     /* this program assumes that the le_c.hlp file has been
        established in the current directory and contains
        page 1 */
     main()
     {
          le_read_help();
          _le_help_explode_sw=0;  /* turn explode switch off */
          help_example();
     }

     /* this function will clear the screen, display a message,
        and activate page 1 of the help facility */
     help_example()
     {
          /* clear screen */
          le_clear_block(0,0,24,79,30);

          le_write_string(0,0,"Press any key to exit the help or",30);
          le_write_string(1,0,"the arrow keys to move the help window",30);
          le_help(1);
     }























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 16




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_init.c functions

     le_init_field(field, chr, size)

     This function will  initialize a field  to a desired  character.   This
     function assumes that *str points to a field of size+1 or larger.

       (char *) field : character pointer to field
       (char) chr : initialization character
       (int) size : size of field

     Return Value: none

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will initialize a field to '*' */
     main()
     {
          char test[11];

          le_init_field(test, '*', 10);

          printf("Result:  %s\n",test);
     }






















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 17




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_inpt.c functions

     le_input(input_flds, items, pos, xkey)

     This  function  will circulate  through a  series  of input  fields for
     input.        The   le_get_double(),    le_get_long(),   le_get_date(),
     le_item_switch(), le_get_string(), and le_get_multln() functions may be
     used.  An array of
     le_input  structures is set  up with  information describing  the input
     fields.

     The up/down  arrow keys may be used to toggle  from field to field.  In
     addition, the le_toggle_key1 and  le_toggle_key2 may be used  to toggle
     the fields (default: tab and reverse tab);

       (struct le_input[]) input_flds : structure array of input fields
       (int) items : number of input fields
       (int *) : current input field
       (struct fkey xkey) : active function keys

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program assumes that the le_c.hlp file
        has one page -- not all fields use a help page */

     main()
     {
          struct le_input inputf[7];
          char my_mfield[401];
          char my_field[41];
          char my_date[11]={"  /  /    "};
          long my_long1=0L;
          long my_long2=0L;
          double my_dbl=0.0;
          int input_pos=0;

          char *my_items[]=
          {
            "Apples",
            "Oranges",
            "Grapes"

     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 18




                                                              LE_C Functions
     -----------------------------------------------------------------------

          };
          int ret_val;
          struct fkey xkey;

          le_init_fkey_struct(&xkey);

          xkey.F10=1;             /* exit on F10 */

          /* clear screen */
          le_clear_block(0,0,24,79,30);

          /* initialize fields to spaces */
          le_init_field(my_mfield, ' ', 400);
          le_init_field(my_field,' ', 40);

          /* prime input array */
          le_write_string(5,0,"Long 1:",30);
          inputf[0].long_val=&my_long1;
          inputf[0].type=GET_LONG;
          inputf[0].row=5;
          inputf[0].col=10;
          inputf[0].size=6;
          inputf[0].help=1;

          le_write_string(7,0,"Long 2:",30);
          inputf[1].long_val=&my_long2;
          inputf[1].type=GET_LONG;
          inputf[1].row=7;
          inputf[1].col=10;
          inputf[1].size=6;
          inputf[1].help=1;

          le_write_string(5,20,"String:",30);
          inputf[2].string=my_field;
          inputf[2].type=GET_STRING;
          inputf[2].row=5;
          inputf[2].col=30;
          inputf[2].size=40;
          inputf[2].help=1;

          le_write_string(7,20,"Mult:",30);
          inputf[3].string=my_mfield;
          inputf[3].type=GET_MULTLN;
          inputf[3].row=7;
          inputf[3].col=30;
          inputf[3].size=40;
          inputf[3].lines=10;

     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 19




                                                              LE_C Functions
     -----------------------------------------------------------------------

          inputf[3].help=1;

          le_write_string(19,20,"Date:",30);
          inputf[4].string=my_date;
          inputf[4].type=GET_DATE;
          inputf[4].row=19;
          inputf[4].col=30;
          inputf[4].help=0;

          le_write_string(21,20,"Double:",30);
          inputf[5].dbl_val=&my_dbl;
          inputf[5].type=GET_DOUBLE;
          inputf[5].row=21;
          inputf[5].col=30;
          inputf[5].left_dig=6;
          inputf[5].right_dig=3;
          inputf[5].help=0;

          le_write_string(23,20,"Items:",30);
          inputf[6].type=GET_ITEM;
          inputf[6].row=23;
          inputf[6].col=30;
          inputf[6].lines=3;      /* number of items */
          inputf[6].item_pos=0;
          inputf[6].size=7;
          inputf[6].help=1;
          inputf[6].item_table=my_items;

          input_pos=0;
          ret_val=le_input(inputf, 7, &input_pos, xkey);
          printf("Return value:  %d\n",ret_val);
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 20




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_item.c functions

     le_item_switch(item_info, items, xkey, help)

     This function will allow the user to switch between various pre-defined
     alternatives in the *item_ptr[]  array.  The arrow keys,  spacebar, and
     tab  key  will be  used  to toggle  between  selections.   The  ESC and
     function  keys  will terminate  the  function  and return  the  current
     position  to the calling  function.  The  *item_info is a  pointer to a
     structure containing information about the various items.

       (item_struct *) item_info : pointer to item_struct
       (char *[]) items : pointer array to items
       (struct fkey) xkey : active function keys
       (int) help : help page

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program assumes that the le_c.hlp file
        contains page one of the help facility */


     /* this function will allow the user to toggle various items */
     main()
     {
        char *my_items[]=
        {
           "This is the first item",
           "This is the second item"
        };
        struct fkey xkey;
        struct item_struct item_info;
        int ret_val;

        /* prime item structure with info */
        item_info.row=10;
        item_info.col=0;
        item_info.pos=0;
        item_info.width=23;
        item_info.items=2;


     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 21




                                                              LE_C Functions
     -----------------------------------------------------------------------

        le_init_fkey_struct(&xkey);  /* initialize function key structure */

        xkey.F10=1;          /* exit if F10 is pressed */

        /* clear screen */
        le_clear_block(0,0,24,79,30);

        /* get item */
        ret_val=le_item_switch(&item_info, my_items, xkey, 1);

        le_goto_xy(20,0);
        printf("Return value: %d",ret_val);
     }



































     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 22




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_key.c functions

     le_get_key()

     This function will wait for a key stroke and return that  key stroke in
     the union variable defined in the calling function.

     Return Value:  int value of key pressed

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will call le_get_key() and
        determine if the key pressed was a special
        key (function key, etc.) or a normal key */
     main()
     {
          union key_in
          {
            char ch[2];
            int i;
          } in_key;

          printf("Press a key...\n");
          in_key.i=le_get_key();

          if(!in_key.ch[0])
            printf("Special key was pressed.\n");
          else
            printf("Regular key was pressed.\n");
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 23




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_long.c functions

     le_get_long(value, row, col, size, xkey, help)

     This function  will allow the user to  enter a long integer  up to nine
     digits.  The space bar may be used to clear the field.

       (long *) value : pointer to long integer
       (char) row : row position of input field
       (char) col : column position of input field
       (char) size : width of field
       (struct fkey) xkey : active function keys
       (int) help : help page

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:

     #include <stdio.h>
     #include <le_c.h>

     /* this program assumes that the le_c.hlp file
        contains page one of the help facility */


     /* this function will allow the input of a long integer */
     main()
     {
        long my_long=123456L;
        struct fkey xkey;
        int ret_val;

        le_init_fkey_struct(&xkey);  /* initialize function key structure */

        xkey.F10=1;          /* exit if F10 is pressed */

        /* clear screen */
        le_clear_block(0,0,24,79,30);

        /* get value */
        ret_val=le_get_long(&my_long, 10, 0, 8, xkey, 1);

        le_goto_xy(20,0);
        printf("Return value: %d",ret_val);
     }

     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 24




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_format_long(value, form_str[], size, dollar_sw)

     This function  will format a long  integer with commas and  an optional
     dollar sign.  If the value exceeds  the desired size, the function will
     fill  the field  with '*'.   This function  assumes that  form_str[] is
     large enough to handle the formatted string.

       (long) value : value to be formatted
       (char []) form_str : receiving field (null terminated)
       (int) size : size of receiving field
       (char) dollar_sw : dollar sign switch

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will format a long integer */
     main()
     {
          long my_value=123456L;
          char format1[15];

          le_format_long(my_value, format1, 10, 1);
          printf("Formatted value:  %s\n",format1);
     }























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 25




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_menu.c functions

     le_bmenu(&menu, items, xkey)
     This  function  will  display  a bar  menu.    Menu  selections  may be
     activated by either positioning the cursor bar and pressing enter or by
     pressing the highlighted "hot"  key.  The cursor bar  may be positioned
     by using the arrow keys  or the space bar.  Please  see the information
     on the le_menu.c globals for changing default settings.

     A  value of NULL may be used as a menu selection so as to create a line
     separating groups of selections.

     Help  may be defined  for both the menu  selection and the  menu.  If a
     help  page is  specified for both  the menu  and a selection,  the menu
     selection's help page will be used.  If the current menu selection does
     not have a help page  (0), the menu's help page will be used.   If both
     the menu and the current selection  do not have a specified help  page,
     no help will be displayed.

       (struct BMENU *) menu : pointer to BMENU menu information
       (struct BMENU_ITEMS []) items : array of menu items
       (struct fkey) : xkey : active function keys

     Return Value:  0 is returned if a menu selection was made
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:

     #include <stdio.h>
     #include <le_c.h>

     /* This program assumes that the le_c.hlp file exists
        and contains two pages.  Please note the use
        of the help page settings to create context
        sensitive help */

     /* this structure defines each item, its
        hot key and the a help page, if any */
     struct BMENU_ITEMS main_items[] = { "Data Entry", 0, 2,
                             "Reports", 0, 1,
                              NULL, 0, 0,       /* NULL draws line */
                             "Utilities", 0, 0,
                             "Miscellaneous", 0, 0 };




     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 26




                                                              LE_C Functions
     -----------------------------------------------------------------------

     /* this structure defines the title, the row
        and column of the first selection, the
        current selection, the number of items,
        the box type, exploding box, and the
        help page */
     struct BMENU main_menu = { "  MAIN MENU  ", 10, 5, 0,
     5, DOUBLE_LINE, EXPLODE_OFF, 1 };

     main()
     {
          example_menu();
     }

     example_menu()
     {
         int i, ret_val;
         struct fkey xkey;           /* active function keys */
         le_init_fkey_struct(&xkey); /* initialize function key structure */

         xkey.F5=1;          /* exit on F5 function key */
         xkey.F6=1;          /* exit on F6 function key */

         /* clear screen */
         le_clear_block(0,0,24,79,30);

         /* display menu */
         ret_val=le_bmenu(&main_menu, main_items, xkey);

         le_goto_xy(20,0);

         /* don't forget that the NULL selection counts
            as one selection */
         printf("Current selection: %d\n",main_menu.pos+1);
         printf("Return value is: %d\n",ret_val);
     }













     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 27




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_box_menu(menu, items, xkey)

     This  function will display a box menu type.   The user may use the tab
     and arrow keys to position the current  selection.  A selection is made
     by pressing  the enter key  or the hot  key for the  desired selection.
     The function will position the box based on the row/col position.  The
     row/col position is the position of the first menu selection. 

     Up to three  optional messages may be  provided.  The  size of the  box
     will adjust to accommodate each additional message.

     Help may be defined for both the menu selection and the menu. If a help
     page  is  specified  for both  the  menu  and  a  selection,  the  menu
     selection's help page will be used.  If the current menu selection does
     not have a help page (0), the menu's  help page will be used.  If  both
     the menu and the  current selection do not have a  specified help page,
     no help will be displayed.

       (struct BOX_MENU *) menu : pointer to BOX_MENU menu information
       (struct BMENU_ITEMS []) items : array of menu items
       (struct fkey) : xkey : active function keys

     Return Value:  0 is returned if a menu selection was made
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:

     #include <stdio.h>
     #include <le_c.h>

     /* This program assumes that the le_c.hlp file exists
        and contains two pages.  Please note the use
        of the help page settings to create context
        sensitive help */

     /* this structure defines the box menu message (only 1
        is used), the current position, row/col, number
        of selections, explode switch, and help page */

     struct BOX_MENU exit_menu = { "Are you sure you want to exit?", "",
     "", 0, 8, 30, 3, EXPLODE_ON, 1 };






     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 28




                                                              LE_C Functions
     -----------------------------------------------------------------------

     /* this structure defines each item, its
        hot key and the a help page, if any */
     struct BMENU_ITEMS exit_items[] = {"Yes", 0, 1,
                                        "No", 0, 1,
                                        "Cancel", 0, 1};

     main()
     {
          example_box_menu();
     }

     example_box_menu()
     {
         int i, ret_val;
         struct fkey xkey;           /* active function keys */
         le_init_fkey_struct(&xkey); /* initialize function key structure */

         xkey.F5=1;          /* exit on F5 function key */
         xkey.F6=1;          /* exit on F6 function key */

         /* clear screen */
         le_clear_block(0,0,24,79,30);

         /* display menu */
         ret_val=le_box_menu(&exit_menu, exit_items, xkey);

         le_goto_xy(20,0);

         printf("Current selection: %d\n",exit_menu.pos+1);
         printf("Return value is: %d\n",ret_val);
     }

















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 29




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_misc.c functions

     le_goto_xy(x, y)

       (char) x : row position
       (char) y : column position

     This function calls  the ROM-BIOS  service function 2  to position  the
     cursor at x,y on the screen.

     Return Value: none

     Example:

     #include <stdio.h>
     #include <le_c.h>

     /* this program will position the cursor at absolute
        row 15 and column 10 and display a message */
     main()
     {
          le_goto_xy(15,10);
          printf("This message started at row 16/column 11.\n");
     }
























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 30




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_scroll_up(startx, starty, endx, endy, rows, attrib)

     This function will  scroll a window  of the screen  up.  The  number of
     lines to scroll  up is  designated by  the rows parameter.   The  blank
     line(s) is filled  with spaces  using attrib for  the color  attribute.
     This function  calls the  ROM-BIOS function  service 6  to perform  the
     scrolling. 

     le_scroll_down(startx, starty, endx, endy, rows, attrib)

     This function will scroll a  window of the screen down.  The  number of
     lines to scroll  down is designated by  the rows parameter.   The blank
     line(s) is filled  with spaces  using attrib for  the color  attribute.
     This function  calls the  ROM-BIOS function  service 7  to perform  the
     scrolling.

       (char) startx : starting row position
       (char) starty : starting column position
       (char) endx : ending row position
       (char) endy : ending column position
       (char) rows : number of rows to scroll
       (char) attrib : fill color

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 31




                                                              LE_C Functions
     -----------------------------------------------------------------------

     Example:

     #include <stdio.h>
     #include <conio.h>
     #include <le_c.h>

     main()
     {
          scroll_example();
          exit(1);
     }

     /* this function will display 15 lines, wait for a key,
        scroll a window up 3 lines, wait for a key, and
        scroll the window down 2 lines */
     scroll_example()
     {
          int i;

          le_clear_block(0,0,24,79,30);   /* clear the screen */

          for(i=0;i<15;i++)       /* fill a window */
          {
             le_goto_xy(i,10);    /* position the cursor */
             printf("Row:  %d  Scroll Example",i+1);
          }
          le_goto_xy(18,0);
          printf("Press any key to scroll window up 3 lines...");
          getch();                /* wait for key */

          /* scroll up */
          le_scroll_up(0,10,14,40,3,30);

          printf("\nPress any key to scroll window down 2 lines...\n");
          getch();                /* wait for key */

          /* scroll down */
          le_scroll_down(0,10,14,40,2,30);

     }








     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 32




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_size_cursor(cursor_sw)

       (int) cursor_sw : CURSOR_ON, CURSOR_OFF, CURSOR_INSERT

     Return Value: none

     This function will  set the cursor  the normal size, CURSOR_ON,  insert
     mode, CURSOR_INSERT, or  turn the cursor off,  CURSOR_OFF. The function
     will  automatically  size  the  cursor for  both  monochrome  and color
     screens.

     Example:

     #include <conio.h>
     #include <stdio.h>
     #include <le_c.h>

     /* this program will set the cursor to off, insert, and
        normal modes */

     main()
     {
          le_size_cursor(CURSOR_OFF);
          printf("\nCursor is off ... press any key");
          getch();
          le_size_cursor(CURSOR_INSERT);
          printf("\nCursor is set to insert ... press any key");
          getch();
          le_size_cursor(CURSOR_ON);
          printf("\nCursor is set to normal mode ... press any key");
          getch();
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 33




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_save.c functions

     le_build_buffers(num_buffs)

       (int) num_buffs : number of screen buffers to allocate

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     This function will build the screen buffers for use with le_save_scrn()
     and le_restore_scrn().  Up to LE_BUFFS screens (4000 bytes each) may be
     allocated.  The  function calls _fmalloc()  to allocate memory for  the
     desired number of  buffers, num_buffs.   If _fmalloc()  returns a  null
     pointer, the function  will terminate the  program.  The screen  buffer
     information  is  stored  in  a  structure  type  of  le_buffers  called
     le_scrn_buf.  A pointer to each buffer page is set for each buffer.  In
     addition, the index to the current page is set as well as the maximum
     number of buffers allowed.

     Example:

     #include <le_c.h>

     /* this program will allocate 5 video
        buffers for saving and restoring screens */
     main()
     {
          le_build_buffers(5);
          exit(1);
     }


















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 34




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_save_block(index, startx, starty, endx, endy)
     le_restore_block(index, action, startx, starty, endx, endy)

     le_save_block()

     This function  will  save  a window  of  the screen  to  a  dynamically
     allocated buffer.  An index is passed to the function to identify
     the buffer to be saved.  The function will call _fmalloc to dynamically
     allocate space for the size  of the buffer.  Both the character and its
     attribute will be  saved to  the buffer.   The user  may specify  index
     values 0-18 for saving and  restoring blocks.  Index 19 is used  by the
     le_help() help facility.

     le_restore_block()

     This function will restore and/or free a window previously saved by the
     le_save_block()  function.     The  value  of  action   determines  the
     processing.    If  action==RESTORE_ONLY, the  function  will  restore a
     previously   saved   window   to  the   specified   coordinates.     If
     action==FREE_ONLY, the window will  not be restored to the  screen, but
     the   allocated   memory   will   be  released   by   _ffree().      If
     action==RESTORE_FREE, the previously  saved window will be  restored to
     the  screen  and  the  buffer  will  be  released  by  _ffree().    The
     coordinates need not be  the same as those used by the le_save_block().
     This gives the user the ability to place a window somewhere else on the
     screen.   However,  do not  specify  a larger  or smaller  window  than
     originally saved by le_save_block().  This may result in bad screens or
     program crash.

        (char) index : block index
        (char) action : restore action - RESTORE_ONLY, FREE_ONLY,
                        RESTORE_FREE
        (char) startx : starting row position
        (char) starty : starting column position
        (char) endx : ending row position
        (char) endy : ending column position

     Example:

     #include <stdio.h>
     #include <conio.h>
     #include <le_c.h>

     main()
     {
          le_block_example();
     }

     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 35




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_block_example()
     {
          /* clear the screen */
          le_clear_block(0,0,24,79,30);

          /* draw a window */
          le_draw_border(DOUBLE_LINE,4,5,10,30,30,EXPLODE_OFF);

          /* save the window as block 1 */
          le_save_block(1,4,5,10,30);

          le_goto_xy(21,0);
          printf("Press any key to move window to the right...");
          getch();

          /* clear the screen */
          le_clear_block(0,0,24,79,30);

          /* restore the block 10 columns to the right */
          le_restore_block(1, RESTORE_ONLY, 4, 15,  10, 40);

          printf("\nPress any key to move window down...");
          getch();

          /* clear the screen */
          le_clear_block(0,0,24,79,30);

          /* restore the block 5 rows down & free memory */
          le_restore_block(1, RESTORE_FREE, 9, 15,  15, 40);

     }

















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 36




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_save_scrn(buffer_num)
     le_restore_scrn(buffer_num)

       (int) buffer_num : 0 if next available page desired
                    non-zero to specify video page

     The le_save_scrn() function  will save a screen  to a buffer for  a new
     window or  help screen.   If zero is  passed to the  function, the next
     available screen buffer is used.   Otherwise, the index, buffer_num, is
     decremented  by one and used as  the index. Invalid buffer numbers will
     cause the function to return a value of 0 to the calling function.  The
     le_build_buffers()  function  should be  called  prior to  calling this
     function in order to allocate space for the screen.

     The le_restore_scrn() function  will restore a screen  previously saved
     to a buffer  using the le_save_scrn() function.   If zero is  passed to
     the function, the previously saved screen will be restored.  Otherwise,
     the index,  buffer_num, is  decremented by one  and used as  the index.
     Invalid buffer numbers will  cause the function to return a  value of 0
     to the calling function.

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     Example:

     #include <conio.h>
     #include <le_c.h>

     /* this program will allocate 5 screen buffers, save the current
        screen, display junk, wait for the user to press a key, and
        restore the screen to its original contents */
     main()
     {
        le_build_buffers(5);         /* allocate 5 screen buffers */
        save_restore_example();
     }











     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 37




                                                              LE_C Functions
     -----------------------------------------------------------------------

     save_restore_example()
     {
        int i;

        le_save_scrn(0);     /* save screen */

        for(i=0;i<20;i++)    /* display junk */
          le_write_string(i,0,"Junk Junk Junk Junk Junk Junk Junk",30);

        getch();             /* wait for key */

        le_restore_scrn(0);  /* restore saved screen */
     }



































     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 38




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_strng.c functions

     le_get_multln(editstring, width, lines, row, col, xkey, help)

     This function  will allow  the  editing of  a multi-line  field.   This
     function supports word wrap and various edit keys.  

       (char *) editstring : character pointer to field
       (int) width : width of field
       (int) lines : number of lines
       (int) row : row position of input field
       (int) col : column position of input field
       (struct fkey) xkey : active function keys
       (int) help : help page

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:
     #include <stdio.h>
     #include <le_c.h>

     main()
     {
          char field[401];
          int ret_val;
          struct fkey xkey;

          le_init_fkey_struct(&xkey);

          xkey.F10=1;             /* exit on F10 */

          /* clear screen */
          le_clear_block(0,0,24,79,30);

          /* initialize field to spaces */
          le_init_field(field, ' ', 400);

          ret_val=le_get_multln(field, 40, 10, 10, 0, xkey, 0);

          printf("Return value:  %d\n",ret_val);
     }





     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 39




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_get_string(editstring, size, row, col, xkey, help)

     This function will allow the input of a simple one line field.

       (char *) editstring : character pointer to field
       (int) size : width of field
       (int) row : row of input field
       (int) col : column of input field
       (struct fkey) xkey : active function keys
       (int) help : help page

     Return Value:  0 is returned if enter pressed
                    A non zero is returned if a special key was pressed
                    -100 is returned if ESC was pressed

     Example:
     #include <stdio.h>
     #include <le_c.h>

     main()
     {
          char field[41];
          int ret_val;
          struct fkey xkey;

          le_init_fkey_struct(&xkey);

          xkey.F10=1;             /* exit on F10 */

          /* initialize field to spaces */
          le_init_field(field, ' ', 40);

          ret_val=le_get_string(field, 40, 10, 0, xkey, 0);

          printf("\nResult:  %s\n",field);
          printf("Return value:  %d\n",ret_val);
     }











     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 40




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_util.c functions

     le_display_error(error, row, col, back_clr, err_clr, box_sw)

     This  function  is called  to  display  an error  that  occurred during
     processing.  The error will be  displayed and a key must be pressed  to
     indicate the user's acknowledgement.  If  the box_sw is set, the  error
     will  appear in a box at  the desired row in  the center of the screen.
     Otherwise,  the  error  will  appear  at  the desired  row  and  column
     position.

     This  function  will  call le_save_scrn()  and  le_restore_scrn().   If
     screen buffers have  not been  allocated, le_display_error() will  call
     le_build_buffers() to allocate three screen buffers. 

       (char *) error : character pointer to error to be displayed
       (char) row : row to display error
       (char) col : column to display error
       (char) back_clr : background screen color
       (char) err_clr : error color
       (char) box_sw : switch to indicate box in center of screen

     Return Value:  0 is returned if unsuccessful
                    1 is returned is successful

     Example:
     #include <stdio.h>
     #include <le_c.h>

     char *error_table[]=
     {
        "Invalid date",
        "Value must be less than $25,000"
     };

     main()
     {
          le_display_error(error_table[1],5,0,30,30,1);
     }









     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 41




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_fright_zero(fr_str[], fr_size, row, col, attrib)

     This function will remove any character  other than a digit and replace
     it with a space, move the value  to the flush right position, zero fill
     any spaces, and display at row/col.

     This  function  comes in  handy  when  writing  programs  that  require
     transaction numbers, invoice numbers, etc.

       (char []) fr_str : field to be right flushed and zero filled
       (int) fr_size : size (width) of field
       (char) row : row position to display output
       (char) col : column position to display output
       (char) attrib : display attribute

     Return Value: none

     Example:
     #include <le_c.h>

     /* this program will zero fill and right flush
        a value and display it at the screen origin */
     main()
     {
          char my_field[7]={"12"};

          le_fright_zero(my_field,6,0,0,30);
     }




















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 42




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_fudge_factor()
     le_wait()

     le_fudge_factor()

     This function  will  set a  fudge  factor based  on  the speed  of  the
     processor.  The  fudge factor is then  used when calling  the le_wait()
     function.  The  fudge factor is approximately 1/100th of a second.  The
     default value is set for  a 12mhz processor.  If  you plan to use  LE_C
     with exploding boxes or the le_wait()  function, it is recommended that
     you call this function  during program initialization to calculate  the
     speed of your processor.

     le_wait(num_hunds)
     This function will wait approximately num_hunds hundredths of a second.
     The speed is based on the fudge factor calculated by le_fudge_factor().

     Return Value: none

     Example:
     #include <stdio.h>
     #include <le_c.h>

     main()
     {
          le_fudge_factor();

          printf("Fudge factor has been calculated.\n");
          printf("Press any key to wait 2.5 seconds.\n");
          getch();
          le_wait(250);
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 43




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_init_fkey_struct(xkey)

     This function will initialize a function  key structure.  This function
     should  be called whenever  a function key structure  is defined for an
     input routine.

       (struct fkey *) xkey : structure pointer to function keys

     Return Value: none

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will prompt the user for a value
        and exit if F2, F3, or enter is pressed */

     main()
     {
          struct fkey xkey;
          long my_long=0L;
          int ret_val;

          /* initialize function key structure */
          le_init_fkey_struct(&xkey);

          xkey.F2=1;      /* exit when F2 pressed */
          xkey.F3=1;      /* exit when F3 pressed */

          ret_val=le_get_long(&my_long, 10, 50, 8, xkey, 0);

          printf("\nReturn value is:  %d\n",ret_val);
     }















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 44




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_is_dos_legal(file_name)

     This function will  verify that the characters  in a DOS file  meet DOS
     file naming conventions.  

       (char []) file_name : file name to be verified

     Return Value: 1 is returned if the file name is valid
                   0 is returned if the file name is invalid

     Example:

     #include <stdio.h>
     #include <le_c.h>

     /* this program will determine if two
        file names meet dos file naming conventions */
     main()
     {
          char file_name1[]={"\\\3030"};
          char file_name2[]={"#444xxx"};

          if(le_is_dos_legal(file_name1))
            printf("%s is a valid DOS file name\n",file_name1);
          else
            printf("%s is an invalid  DOS file name\n",file_name1);

          if(le_is_dos_legal(file_name2))
            printf("%s is a valid DOS file name\n",file_name2);
          else
            printf("%s is an invalid DOS file name\n",file_name2);
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 45




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_locate_file(path, filename)

     This function will  determine if a file exists in  the specified *path.
     The function  is passed  a pointer  to the  path and  a pointer  to the
     filename.  A  call to the  access() function will determine  whether or
     not the file exists.  If the file  exists, a value of 1 is returned  to
     the  calling  function.    Otherwise,  0  is returned  to  the  calling
     function.

       (char *) path : character pointer to file path
       (char *) filename : character pointer to file name

     Return Value : 1 is returned if the file exists
                  : 0 is returned if the file does not exist

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will call the le_locate_file() function to
        determine if there is the AUTOEXEC.BAT is in the root directory */

     main()
     {
          char root[9]={"C:\\"};

          if(le_locate_file(root,"AUTOEXEC.BAT"))
            printf("AUTOEXEC.BAT was found in root directory\n");
          else
            printf("AUTOEXEC.BAT was not found in root directory\n");
     }

















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 46




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_long_to_date(date_val, date_str)

     This function will convert a date  in long integer format, YYYYMMDD, to
     a string,  MM/DD/YYYY.   This function  assumes that  the long  integer
     contains a valid date.

     This function was  developed for use  with the le_get_date()  function.
     It  is assumed  that you  will want to  store the  date in  long format
     because of  size.  In addition, having the  date in the YYYYMMDD format
     aids in sorting.

       (long) date_val : date value in long integer (YYYYMMDD format)
       (char *) date_str : character pointer to date string

     Return Value: none

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will convert a date stored
        in a long integer to a string date */
     main()
     {
          long my_date_val=19891012;
          char my_date[11];

          le_long_to_date(my_date_val,my_date);
          printf("Converted date:  %s\n",my_date);
     }


















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 47




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_severe_error(severe_error, reset_clr)

     This  function  is  called to  process  a  severe  error that  requires
     termination of  the program.   A  pointer to  the error  is passed  for
     display.  In  addition, the reset  screen color is passed  for clearing
     the screen prior to termination.

       (char *) severe_error : character pointer to error
       (char) reset_clr : clear screen color

     Return Value: none - program is terminated

     Example:
     #include <le_c.h>

     /* this program will display a severe error,
        out of memory, and terminate the program */
     main()
     {
          le_severe_error("Out of memory.",30);
     }



























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 48




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_system_date(sys_date)

     This function will retrieve the system date and pass it to  the calling
     program in long integer form formatted as YYYYMMDD.

       (long *) sys_date : system date in YYYYMMDD

     Return Value: none

     Example:
     #include <stdio.h>
     #include <le_c.h>

     main()
     {
          long todays_date;

          le_system_date(&todays_date);
          printf("Today's     date     in     long      YYYYMMDD     format:
     %ld\n",todays_date);
     }



























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 49




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_verify_date(date_str[], date_value)

     This function will  verify the  passed date, date_str,  for valid  date
     ranges.  The  passed date is  in MM/DD/YYYY or  MM/DD/YY format.   This
     function will provide leap year processing.   This function will return
     the date as a long integer in YYYYMMDD format as date_value.

     This function may be  used in conjunction with the  le_get_date() input
     function.

       (char [11]) date_str : date string in MM/DD/YYYY format
       (long *) date_value : long pointer to date value (YYYYMMDD)

     Return Value:  1 is returned if the date is valid
                    0 is returned if the date is invalid

     Example:
     #include <stdio.h>
     #include <le_c.h>

     /* this program will determine if a date is valid or invalid */
     main()
     {
          char my_date1[11]={"10/12/1989"};
          long date1_long;

          if(le_verify_date(my_date1,&date1_long))
            printf("%s is a valid date - long value is: %ld\n",
             my_date1,date1_long);
          else
            printf("%s is an invalid date\n",my_date1,date1_long);
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 50




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_word_wrap(str_ptr, width, row, col, attrib)

     This function will wrap words in a string in a window of size width.

       (char *) str_ptr : character pointer to string
       (int) width : width of window for word wrap
       (char) row : row position
       (char) col : column position
       (char) attrib : display color

     Return Value:  0 is returned if unsuccessful
                    If successful, the number of lines displayed is returned

     Example:
     #include <le_c.h>

     main()
     {
          char my_string[]={"This string should be displayed on several
     lines of the display"};

          le_word_wrap(my_string,20,10,30,30);
     }

























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 51




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_vid.c functions

     le_set_video_mem()

     Return Value:  none

     This  function  calls  the le_video_mode()  function  to  determine the
     current video  mode and sets a  far pointer, le_video_mem, to  point to
     the video page.  LE_C supports only video  modes 2, 3, & 7.  All  other
     modes  will result  in  termination of  the  program.   The LE_C  video
     functions will call this function automatically to set le_video_mem.

     Example:

     #include <le_c.h>

     /* this program will call le_set_video_mem()
        to set the le_video_mem far pointer */
     main()
     {
          le_set_video_mem();
          exit(1);
     }

























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 52




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_video_mode()

     Return Value : current video mode

     The le_video_mode() calls the ROM-BIOS service function 15 to determine
     the  current video mode.   Video modes 2,  3, & 7  indicate text modes.
     LE_C functions will operate only with these modes.

     Example:

     #include <le_c.h>

     /* this program will print the
        current video mode */
     main()
     {
          printf("Current video mode:  %d\n",le_video_mode());
          exit(1);
     }





























     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 53




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_write.c functions

     le_clear_block(startx, starty, endx, endy, attrib)

       (char) startx : upper left row (0-24)
       (char) starty : upper left column (0-79)
       (char) endx : lower right row (0-24)
       (char) endy : lower right column (0-24)
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_clear_block() function  will clear a window on the  screen.  The
     starting and ending rows/columns  indicate the position on the   screen
     to  clear.   In  addition, the  color  is passed  to reset  the cleared
     window.

     Example:

     #include <stdio.h>
     #include <le_c.h>

     main()
     {
          clear_block_example();
          exit(1);
     }

     /* this function will display 25 lines of junk
        and clear a window using yellow on blue */
     clear_block_example()
     {
          int i;

          for(i=0;i<25;i++)
            printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n");
          le_clear_block(2,4,11,35,30);
     }









     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 54




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_cls(attrib)

       (char) attrib : screen color to clear screen to

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_cls() function will clear the  entire screen using the attrib as
     the color of the screen.

     Example:

     #include <stdio.h>
     #include <le_c.h>

     main()
     {
          cls_example();
          exit(1);
     }

     /* this function will display 25 lines of junk and
        clear a the entire screen using yellow on blue */
     cls_example()
     {
          int i;

          for(i=0;i<25;i++)
            printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n");
          le_get_key();  /* wait for key */
          le_cls(30);
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 55




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_draw_border(bar_code, startx, starty, endx, endy, attrib, type_sw)

       (char) bar_code : border type (SINGLE_LINE, DOUBLE_LINE,
                          SVER_DHOR, DVER_SHOR)
       (char) startx : upper left row (0-24)
       (char) starty : upper left column (0-79)
       (char) endx : lower right row (0-24)
       (char) endy : lower right column (0-24)
       (char) attrib : screen color to use
       (char) type_sw : exploding box switch

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_draw_border() function will draw a box on the screen.  There are
     four types from  which to choose (SINGLE_LINE,  DOUBLE_LINE, SVER_DHOR,
     DVER_SHOR).   The box coordinates  are passed in  addition to the color
     attribute.  Finally,  EXPLODE_ON or EXPLODE_OFF manifest  constants may
     be used  to indicate an exploding box.  A  call to le_wait() is used to
     time the delay  between exploding boxes.  It is recommended that a call
     be made to  le_fudge_factor() during initialization so  as to determine
     the speed of  your processor.  The call  to le_fudge_factor() need only
     be made once.

     Example:

     #include <le_c.h>

     main()
     {
          le_fudge_factor();      /* set up fudge factor for le_wait() */
          draw_box_example();
          exit(1);
     }

     /* this function will draw an
        exploding box on the screen. */
     draw_box_example()
     {
          le_draw_border(DOUBLE_LINE,4,5,20,60,30,EXPLODE_ON);
     }







     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 56




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_draw_hline (type, startx, starty, endy, attrib)

       (char) type : line type (SINGLE_LINE, DOUBLE_LINE,
                       SINGLE_ENDS, DOUBLE_ENDS
       (char) startx : starting row (0-24)
       (char) starty : starting column (0-79)
       (char) endy : ending column (0-79)
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_draw_hline() function will draw a  horizontal line on the screen
     at  the  specified  coordinates.     The  SINGLE_ENDS  and  DOUBLE_ENDS
     constants indicate T-ends at the end of the line. 

     Example:

     #include <le_c.h>

     main()
     {
          draw_hline_example();
          exit(1);
     }

     /* this function will draw a
        horizontal line at the
        specified coordinates */
     draw_hline_example()
     {
          le_draw_hline(SINGLE_ENDS, 8, 12, 50, 30);
     }















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 57




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_draw_vline (type, startx, starty, endx, attrib)

       (char) type : line type (SINGLE_LINE, DOUBLE_LINE,
                     SINGLE_ENDS, DOUBLE_ENDS
       (char) startx : starting row (0-24)
       (char) starty : starting column (0-79)
       (char) endx : ending row (0-24)
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_draw_vline() function will draw a vertical line on the screen at
     the specified coordinates.   The  SINGLE_ENDS and DOUBLE_ENDS  constant
     indicate T-ends at the end of the line.

     Example:

     #include <le_c.h>

     main()
     {
          draw_vline_example();
          exit(1);
     }

     /* this function will draw a
        vertical line at the
        specified coordinates */
     draw_vline_example()
     {
          le_draw_vline(DOUBLE_LINE, 4, 40, 24, 30);
     }















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 58




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_fill_block(fill_ch, startx, starty, endx, endy, attrib)

       (char) fill_ch : fill character
       (char) startx : starting row position
       (char) starty : starting column position
       (char) endx : ending row position
       (char) endy : ending column position
       (char) attrib : color attribute

     This function will fill a window of the screen with a specified
     character, fill_ch.

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     Example:

     #include <le_c.h>

     /* this program will fill a window on
        the screen will the extended ASCII
        character 176 */
     main()
     {
          le_fill_block(176,10,20,20,60,30);
     }






















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 59




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_rewrite_scrn(startx, starty, endx, endy, attrib)

       (char) startx : upper left row (0-24)
       (char) starty : upper left column (0-79)
       (char) endx : lower right row (0-24)
       (char) endy : lower right column (0-24)
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                 0 is returned if unsuccessful

     The le_rewrite_scrn() function  will change  the screen attribute  from
     startx/starty to endx/endy.

     Example:

     #include <le_c.h>

     main()
     {
          rewrite_scrn_example();
          exit(1);
     }


     /* this function will use the le_write_string()
        function to display junk on the screen using
        yellow on blue and then rewrite a portion
        to black on grey */
     rewrite_scrn_example()
     {
        int i;

        for(i=0;i<10;i++)
          le_write_string(i,10,"Junk Junk Junk Junk Junk Junk Junk",30);

        le_rewrite_scrn(5,10,8,40,112);
     }










     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 60




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_write_char(startx, starty, ch, attrib)

       (char) startx : starting row (0-24)
       (char) starty : starting column (0-79)
       (char) ch : character to display
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The  le_write_char() function  will display  a single character  on the
     screen  at  the specified  coordinates.   A  character constant  or its
     numeric equivalent may be provided.

     Example:

     #include <le_c.h>

     main()
     {
          write_char_example();
          exit(1);
     }

     /* this function will display the extended
        character 176 (' ') at the origin. */
     write_char_example()
     {
          le_write_char(0,0,176,30);
     }


















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 61




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_write_string(startx, starty, string, attrib)

       (char) startx : starting row (0-24)
       (char) starty : starting column (0-79)
       (char *) string : null terminated string to be displayed
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_write_string() function will  display a string at the  specified
     coordinates using attrib as the screen color.

     Example:

     #include <le_c.h>

     main()
     {
          write_string_example();
          exit(1);
     }

     /* this function will display a
        sample string on the screen */
     write_string_example()
     {
          char my_string[]={"This is line two."};

          le_write_string(10,35,"This is line one.",30);
          le_write_string(11,35,my_string,30);
     }
















     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 62




                                                              LE_C Functions
     -----------------------------------------------------------------------

     le_write_far_string(startx, starty, string, attrib)

       (char) startx : starting row (0-24)
       (char) starty : starting column (0-79)
       (char far *) string : null terminated far string to be displayed
       (char) attrib : screen color to use

     Return Value : 1 is returned if successful
                    0 is returned if unsuccessful

     The le_write_far_string() is  the same as the  le_write_string() except
     is will display a far null terminated string.




































     ----------------------------------------------------------------------
     LE_C Library (c) Copyright 1990 By ProBATE Software
     Publishing Co., Inc. - Call 303-352-3445 to Order               Page 63


