#
# Make file for BCC. Make sure to correct the definitions for
# your machine.
#
# This makefile constructs the test files using the
# large memory model, debug info on, no fast floating point,
# and all other defaults, ie emulation, and standard
# optimizations. 

# Note that virtlib.lib must be constructed first. See to_lib.mak

.AUTODEPEND

# directory definitions
CURDIR = C:\MATH\MATPP
LIBDIR = C:\TC\LIB
INCDIR = C:\TC\INCLUDE

.PATH.obj = $(CURDIR)

#		*Translator Definitions*

CC = bcc +maketest.cfg
TLINK = tlink

#		*Implicit Rules*
.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*

EXE_dependencies =  testreg.obj test.obj testgraf.obj disttest.obj
EXES = test.exe testreg.exe testgraf.exe disttest.exe

all: maketest.cfg maketest.mak $(EXE_dependencies) $(EXES)
     del maketest.cfg
 
#		*Explicit Rules*
$(EXES): maketest.cfg $(EXE_dependencies) 
  $(TLINK) /v/x/c/P-/L$(LIBDIR);$(CURDIR) @&&|
c0l.obj+
$&
$&

virtlib.lib+
emu.lib+
mathl.lib+
cl.lib+
graphics.lib
|


#		*Individual File Dependencies*
test.obj: test.cpp

testreg.obj: testreg.cpp 

testgraf.obj: testgraf.cpp

disttest.obj: disttest.cpp

#		*Compiler Configuration File*
# change -DVIRTGRAF to -DVIRTGRAF;IN_RAM for in ram version
# make sure to build the library with the same defines

maketest.cfg: maketest.mak
  copy &&|
-ml
-v
-vi
-ff-
-n$(CURDIR)
-I$(INCDIR)
-L$(LIBDIR);$(CURDIR)
-DVIRTGRAF
| maketest.cfg



