/************************************************************************

input.h 	-	Include file for use with user input functions.

Programmer	-	Edward James Pugh, AFA.

Copyright       -       (C) Edward James Pugh, 12-Jan-1990.

*************************************************************************/

#if !defined(_INPUT_DECL)

#define ALLOW_MENU_BAR          1
#define ALLOW_ALTER_WINDOW      2
#define REPORT_EXT_KEY          4
#define NO_FLUSH_KEYBD          8
#define REPORT_NULL_EVENT       16

#define TON(x)  (++(x))
#define TOFF(x) (--(x))

/* enumerate function key list */
typedef enum {F1 = 17, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12}FKey_s;

/* enumerate extended character classes */
typedef enum {VIRGIN, SHIFT_EXT, CTRL_EXT, CTRL_SHIFT_EXT, ALT_EXT,
	ALT_SHIFT_EXT, ALT_CTRL_EXT, ALT_CTRL_SHIFT_EXT, GREY_KEY,
	FAULT}ExtClass_s;

/* enumerate grey keys */
typedef enum {SHIFT_TAB, HOME, UP, PGUP, LEFT, RIGHT, END, DOWN, PGDN,
	INSERT, DEL, CTRL_PRTSCRN, CTRL_LEFT, CTRL_RIGHT, CTRL_END,
	CTRL_PGDN, CTRL_HOME, CTRL_PGUP}GreyKey_s;


/* function prototypes */
Event_t *GetEvent(unsigned int mode);
Event_t *DoObjects(Window_t *window, llnode_t *start, unsigned int mode);
Event_t *DoPopUp(BOOLEAN side_exit, Window_t *window);
int CONTINUEfunc(void);
int CANCELfunc(void);

#define _INPUT_DECL
#endif
