/**************************************************************************
ibmpc.h         -       Header file for use with IBM PC specific
			applications.

Programmer	-	Edward James Pugh, AFA.

Copyright	-	(C) Edward James Pugh, 12-Jan-1990.
***************************************************************************/

#if !defined(BOOLEAN)
#define TRUE            1
#define FALSE           0
#define BOOLEAN         int
#endif

#if !defined(_IBMPC_DECL)

#include "screen.h"
#include "input.h"
#include "thread.h"
#include "dialogue.h"
#include "llist.h"

/* define B/W (Mode 7) text attributes */
#define HIDDEN		0x00
#define NORMAL		0x07 /* white on black */
#define HIGHINT 	0x0F
#define REVERSE         0x70

/* define 16 color text attributes */
#define BLACK           0x00
#define BLUE            0x01
#define GREEN           0x02
#define CYAN            0x03
#define RED             0x04
#define MAGENTA         0x05
#define BROWN           0x06
#define WHITE           0x07
#define DARK_GREY       0x08
#define LIGHT_BLUE      0x09
#define LIGHT_GREEN     0x0a
#define LIGHT_CYAN      0x0b
#define LIGHT_RED       0x0c
#define LIGHT_MAGENTA   0x0d
#define YELLOW          0x0e
#define BRIGHT_WHITE    0x0f


#define MYATTRIB(fg, bg) ( (unsigned char) ( (bg << 4) | fg) )
#define PEEK(type, seg, off) *(type (_far *))(((long)seg << 16) + off)
#define ANDXOR(val, m1, m2) ((val & m1) ^ m2)
#define BIT_ON(var, mask) (var | mask)
#define BIT_OFF(var, mask) (var & (~mask))
#define BIT_TOG(var, mask) (var ^ mask)

/* function prototypes */

/* position the cursor */
void	PosnCurs(unsigned char row, unsigned char col);

/* get the current cursor position */
void	GetCurs(unsigned char *row, unsigned char *col);

/* get the cursor type */
void	CursorType(unsigned char *start, unsigned char *end);

/* scroll the screen */
void ScrollScreen(unsigned char inter, unsigned char lines,
	unsigned char TRow, unsigned char TCol, unsigned char
	BRow, unsigned char BCol, unsigned char attrib);

/* set the cursor type */
void	 SetCurs(unsigned char SLine, unsigned char ELine);

/* put char and attrib to screen */
void	 PutChar(unsigned char ch, unsigned char attrib);

/* save screen beneath window */
unsigned int    *SaveScreen(unsigned char TRow, unsigned char TCol,
			unsigned char BRow, unsigned char BCol);

/* put a saved area to screen */
unsigned int	*PutArea(unsigned char TRow, unsigned char TCol,
			 unsigned char BRow, unsigned char BCol,
			 unsigned int *store);

/* set a small cursor */
void	SmallCurs(void);

/* set a large cursor */
void	LargeCurs(void);

/* turn the cursor off */
void		CursOff(void);

/* set ATKEYBD type to TRUE or FALSE */
void	SetATKey(BOOLEAN status);

/* get the key struck as ascii and scan code */
BOOLEAN    PCKey(unsigned char *scan, unsigned char *ascii);

/* get the system year */
int SysYear(void);

/* get the system month */
int SysMonth(void);

/* get the system day */
int SysDay(void);

/* get the current keyboard shift status */
unsigned int KBStatus(void);

/* class an extended character */
unsigned int ExtCharClass(unsigned char *ch);

/* test INSERT state */
BOOLEAN InsertOn(void);

/* translate mickeys into screen coordinates */
void TransFMickeys(unsigned int *dx_reg, unsigned int *cx_reg);

/* translate screen co ords to mickeys */
void TransTMickeys(unsigned *row, unsigned *col);

/* reverse a screen block */
void RevScrBlock(unsigned char TRow, unsigned char TCol, unsigned char BRow,
		unsigned char BCol);

/* put screen attrib to specified location */
void PutAttrib(unsigned char TRow, unsigned char TCol, unsigned char BRow,
		unsigned char BCol, unsigned int mask1, unsigned int mask2);

/* Flip window title attributes */
void FlipArea(Screen_t *area);

/* Show a ghost window */
void ShowGhostW(Screen_t *bounds);

/* show a line */
void ShowLine(Window_t *window, int line);

/* show switch box character */
void ShowSBChar(Window_t *window, int line, unsigned char ch);

/* set bounds to incorporate moves */
void AdjBounds(Screen_t *bounds, int hmove, int vmove);

/* expand bounds to include mouse or cursor movement */
void ExpBounds(Screen_t *bounds, Screen_t *minbounds,
	int hmove, int vmove, int loc);

/* locate best position for undertaking resizing */
int BestSizingPosn(Window_t *window, int *row, int *col);

/* mouse function prototypes */

#define LEFT_BUTTON     1
#define RIGHT_BUTTON    2
#define MIDDLE_BUTTON   4

/* check mouse installed and reset parameters to default */
int	InitMouse(void);

/* display the mouse cursor */
void	ShowMouse(void);

/* hide the mouse cursor */
void	HideMouse(void);

/* get the button(s) pressed and mouse x and y coord */
int     GetMPosn(unsigned int *row, unsigned int *col);

/* put the mouse cursor at a specific location */
void    PutMouse(unsigned row, unsigned col);

/* get button pressed, no of presses and cursor location */
int     GetMPress(unsigned button,
	unsigned int *row, unsigned int *col, unsigned int *status);

/* set mouse text cursor type */
void SetMouseTCurs(unsigned int type, unsigned int CX, unsigned int DX);

/* set the video mode */
void SetVidMode(unsigned char mode);

/* get the video mode */
unsigned char GetVidMode(void);

/* restore the original video mode */
void ResVidMode(void);

/* initialize the user interface */
int InitUI(int vdu_mode);

/* leave the user interface */
void LeaveUI(void);

/* validate a supplied attribute */
unsigned char ValidAttrib(unsigned char attrib);

#define ClearSection(TRow, TCol, BRow, BCol, Attrib) \
ScrollScreen(7, 0, TRow, TCol, BRow, BCol, Attrib)

#define ScrUp(TRow, TCol, BRow, BCol, Attrib) \
ScrollScreen(6, 1, TRow, TCol, BRow, BCol, Attrib)

#define ScrDn(TRow, TCol, BRow, BCol, Attrib) \
ScrollScreen(7, 1, TRow, TCol, BRow, BCol, Attrib)

#define PutChDull(ch, attrib) \
PutChar(ch, (unsigned char)BIT_OFF(attrib, 0x08))

#define PutChBright(ch, attrib) \
PutChar(ch, (unsigned char)BIT_ON(attrib, 0x08))

#define _IBMPC_DECL
#endif
