/***************************************************************************
thread.h        -       Header file for use with DOS thread routines
			sourced in thread.c and register.asm
***************************************************************************/

#if !defined(_THREAD_DECL)

#include "llist.h"

#if defined (__MEDIUM) /* medium model */
#define REGSIZE 11
#elif defined (__COMPACT) /* Compact model */
#define REGSIZE 11
#elif defined (__SMALL) /* Small Model */
#define REGSIZE 10
#elif defined (__TINY)  /* Tiny model */
#define REGSIZE 10
#else                   /* Large or Huge model */
#define REGSIZE 12
#endif

typedef unsigned int Register_t[REGSIZE];

typedef enum {NEXT, PREV, WINDOW} Thread_s;

typedef struct
	{
	Register_t Regs;
	llist_t *PList;
	llnode_t *CurProc;
	Thread_s Type;
	}Thread_t;

/* function prototypes */
Thread_t *NewThread(Thread_s type);
void _pascal Yield(llnode_t *target);
llnode_t *NewProcess(Thread_t *thread, void (*process)(void),
	size_t stacksize);
void _pascal LaunchThread(Thread_t *thread);

#define _THREAD_DECL
#endif
