/**************************************************************************
llist.h         -       Include file for use with Linked List data
			functions.

Programmer      -       Edward James Pugh, AFA.

Copyright       -       (C) Edward James Pugh, 17-Dec-1989.

***************************************************************************/

#if !defined(BOOLEAN)
#define BOOLEAN int
#define TRUE 1
#define FALSE 0
#endif

#if !defined(_LLIST_DECL)

#include <stdio.h>

/* declare new type LLDATA for interfacing with user routines */
typedef char     LLDATA;

/* Declare node_t structure.  Uses a LLDATA pointer to the data structure
to be linked.  (Use a cast when attaching records). */

typedef struct llnode
	{
	LLDATA    *item; /* pointer to data structure - use a cast. */
	struct llnode     *next, *prev;
	}llnode_t;

/* Declare custom head_t node containing details of first and last elements
in the list along with number of items. */

typedef struct
	{
	size_t    length;  /* size_t is unsigned short */
	llnode_t  *first, *last;
	}llist_t;

/* define stack type structure */
typedef struct
	{
	size_t          length;
	llnode_t        *top;
	}llstack_t;

/* function prototypes */
llist_t *NewList(void);
llnode_t *NewNode(LLDATA *item, llnode_t *next, llnode_t *prev);
llist_t *AppendItem(llist_t *list, LLDATA *item);
llnode_t *DeleteNode(llist_t *header, llnode_t *node, BOOLEAN kill);
llist_t *MakeCirc(llist_t *list);
llist_t *MakeLinear(llist_t *list);
llnode_t *PullStack(llstack_t *stack, llnode_t *node);
LLDATA *PopStack(llstack_t *stack);
llnode_t *PushStack(llstack_t *stack, LLDATA *item);

#define _LLIST_DECL
#endif
