/**************************************************************************
dialogue.h      -       Include file for use with Dialogue Box
			functions in dialogue.c

Programmer      -       E.J.Pugh, AFA

Copyright       -       (C) Edward James Pugh, 12-Jan-1990
***************************************************************************/

#if !defined(DIALOGUE_INCL)

typedef enum {ENG, USA, JAP} DateType_s;

/* declare dialogue description type */
typedef struct dilog
	{
	char *Buffer; /* to hold input */
	int BufLen; /* The length of the buffer.
		       This will be at least the length of the visual
		       display area, if it is more, then the field is
		       scrolled horizontally to extend the input area. */
	int (*Accept)(struct dilog *); /* the address of the required acceptance
				  routine that is to be called when the
				  user presses '\r'.
				  A return value of > -1 indicates that
				  the input is not acceptable and the
				  DoExpressD() routine will continue
				  at the point in the buffer indicated by
				  the return value. */
	BOOLEAN Scalar; /* TRUE if no input allowed, else FALSE */
	int Count; /* used internally by the routine and initially
			set to 0 */
	int BufPosn;   /* ditto */
	int Offset;  /* ditto */
	int Last;    /* ditto */
	int State;   /* ditto */
	llist_t *List;
	llnode_t *LPosn;
	BOOLEAN Signed;
	int Decimals;
	}Dialogue_t;

/* new dialogue description */
void *NewDialogue(WObj_s type, int length, int(*accept)(Dialogue_t *ptr),
	BOOLEAN signtype, int decimals, llist_t *list, BOOLEAN scalar);

/* do a dialogue */
Event_t *DoDialogue(Window_t *window, unsigned int mode);

/* show number dialogue in CURWINDOW in final format */
void ShowDNumber(void);

#define DIALOGUE_INCL
#endif
