'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        BASWIZ  Copyright (c) 1990-1993  Thomas G. Hanlin III         |
'   |                                                                      |
'   |                      The BASIC Wizard's Library                      |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   '--- external routines from BasWiz
   DECLARE FUNCTION SHRI% (BYVAL Value%, BYVAL Bits%)
   DECLARE FUNCTION VALI% (St$)
   DECLARE SUB QTSound (BYVAL Freq%, BYVAL Millisec%)


   '--- internal routines to save/restore module-level globals
   DECLARE SUB QTPlay00 (BYVAL Octave%, BYVAL NoteLen%, BYVAL Tempo%, BYVAL SoundLen%, BYVAL TmpNoteLen%, BaseTime&)
   DECLARE SUB QTPlay01 (Octave%, NoteLen%, Tempo%, SoundLen%, TmpNoteLen%, BaseTime&)



SUB GetNum (St$, Nr%, ErrCode%)        ' grab a number from the music string
   NumLen% = 0
   FOR tmp% = 1 TO LEN(St$)
      ch% = ASC(MID$(St$, tmp%, 1)) - 48
      IF ch% >= 0 AND ch% <= 9 THEN
         NumLen% = NumLen% + 1
      ELSE
         EXIT FOR
      END IF
   NEXT
   IF NumLen% = 0 OR NumLen% > 3 THEN
      ErrCode% = -1
   ELSE
      ErrCode% = 0
      Nr% = VALI%(LEFT$(St$, NumLen%))
   END IF
   St$ = MID$(St$, NumLen% + 1)
END SUB



SUB QTPlay (SoundSt$)                  ' play music in the foreground

   Sounds$ = UCASE$(SoundSt$)

   REDIM BaseOctave%(0 TO 11)
   BaseOctave%(0)  = 18357        ' C
   BaseOctave%(1)  = 17292        ' C# or D-
   BaseOctave%(2)  = 16124        ' D
   BaseOctave%(3)  = 15297        ' D# or E-
   BaseOctave%(4)  = 14551        ' E
   BaseOctave%(5)  = 13715        ' F
   BaseOctave%(6)  = 12830        ' F# or G-
   BaseOctave%(7)  = 12175        ' G
   BaseOctave%(8)  = 11473        ' G#
   BaseOctave%(9)  = 10847        ' A
   BaseOctave%(10) = 10286        ' A# or B-
   BaseOctave%(11) = 9623         ' B

   QTPlay01 Octave%, NoteLen%, Tempo%, SoundLen%, TmpNoteLen%, BaseTime&

   DO                                            ' remove spaces
      Posn% = INSTR(Sounds$, " ")
      IF Posn% > 0 THEN
         Sounds$ = LEFT$(Sounds$, Posn% - 1) + MID$(Sounds$, Posn% + 1)
      END IF
   LOOP WHILE Posn%

   DO WHILE LEN(Sounds$)                         ' process music commands
      Ch$ = LEFT$(Sounds$, 1)
      Sounds$ = MID$(Sounds$, 2)
      SELECT CASE Ch$
         CASE "<"
            IF Octave% > 1 THEN Octave% = Octave% - 1
         CASE ">"
            IF Octave% < 6 THEN Octave% = Octave% + 1
         CASE "A" TO "G"
            NotePos% = ASC(MID$("JLACEFH", ASC(Ch$) - 64, 1)) - 65
            IF LEN(Sounds$) THEN
               NoteInfo$ = ""
               ch% = ASC(Sounds$)
               Sounds$ = MID$(Sounds$, 2)
               IF ch% = 45 THEN    ' -
                  IF NotePos% = 2 OR NotePos% = 4 OR NotePos% = 7 OR NotePos% = 9 OR NotePos% = 11 THEN
                     NotePos% = NotePos% - 1
                  END IF
                  IF LEN(Sounds$) THEN
                     tch% = ASC(Sounds$)
                     IF tch% = 46 OR tch% >= 48 AND tch% <= 57 THEN
                        ch% = tch%
                        Sounds$ = MID$(Sounds$, 2)
                     END IF
                  END IF
               ELSEIF ch% = 43 OR ch% = 35 THEN   ' + or #
                  IF NotePos% = 0 OR NotePos% = 2 OR NotePos% = 5 OR NotePos% = 7 OR NotePos% = 9 THEN
                     NotePos% = NotePos% + 1
                  END IF
                  IF LEN(Sounds$) THEN
                     tch% = ASC(Sounds$)
                     IF tch% = 46 OR tch% >= 48 AND tch% <= 57 THEN
                        ch% = tch%
                        Sounds$ = MID$(Sounds$, 2)
                     END IF
                  END IF
               ELSEIF ch% <> 43 AND (ch% < 48 OR ch% > 57) THEN
                  Sounds$ = CHR$(ch%) + Sounds$
               END IF
               IF ch% = 43 OR ch% >= 48 AND ch% <= 57 THEN
                  NoteInfo$ = NoteInfo$ + CHR$(ch%)
                  DO WHILE LEN(Sounds$) > 0 AND INSTR("0123456789.", LEFT$(Sounds$, 1)) > 0
                     NoteInfo$ = NoteInfo$ + LEFT$(Sounds$, 1)
                     Sounds$ = MID$(Sounds$, 2)
                  LOOP
                  IF TmpNoteLen% = 0 THEN TmpNoteLen% = NoteLen%
                  DotLen& = BaseTime&
                  DO WHILE INSTR(NoteInfo$, ".")
                     DotLen& = DotLen& \ 2&
                     BaseTime& = BaseTime& + DotLen&
                     tmp% = INSTR(NoteInfo$, ".")
                     NoteInfo$ = LEFT$(NoteInfo$, tmp% - 1) + MID$(NoteInfo$, tmp% + 1)
                  LOOP
                  IF LEN(NoteInfo$) > 0 AND LEN(NoteInfo$) < 3 THEN
                     SpecialLen% = VALI%(NoteInfo$)
                     IF SpecialLen% > 0 AND SpecialLen% < 65 THEN
                        TmpNoteLen% = SpecialLen%
                     END IF
                  END IF
               END IF
            END IF
            Freq% = SHRI%(BaseOctave%(NotePos%), Octave%)
            GOSUB PlayNote
         CASE "L"
            GetNum Sounds$, Nr%, ErrCode%
            IF NOT ErrCode% AND (Nr% > 0 AND Nr% < 65) THEN NoteLen% = Nr%
         CASE "M"
            IF LEN(Sounds$) THEN
               SELECT CASE LEFT$(Sounds$, 1)
                  CASE "L": SoundLen% = 8   ' legato
                  CASE "N": SoundLen% = 7   ' normal
                  CASE "S": SoundLen% = 6   ' staccato
                  CASE ELSE  ' either MF (default) or MB (not supported)
               END SELECT
               Sounds$ = MID$(Sounds$, 2)
            END IF
         CASE "N"
            GetNum Sounds$, Nr%, ErrCode%
            IF NOT ErrCode% AND (Nr% >= 0 AND Nr% <= 84) THEN
               IF Nr% THEN
                  Nr% = Nr% - 1
                  Freq% = SHRI%(BaseOctave%(Nr% MOD 12), Nr% \ 12)
               ELSE
                  Freq% = Nr%
               END IF
               GOSUB PlayNote
            END IF
         CASE "O"
            GetNum Sounds$, Nr%, ErrCode%
            IF NOT ErrCode% AND (Nr% >= 0 AND Nr% <= 6) THEN Octave% = Nr%
         CASE "P"
            GetNum Sounds$, Nr%, ErrCode%
            IF NOT ErrCode% AND (Nr% > 0 AND Nr% < 65) THEN
               TmpNoteLen% = Nr%
               Freq% = 0
               GOSUB PlayNote
            END IF
         CASE "T"
            GetNum Sounds$, Nr%, ErrCode%
            IF NOT ErrCode% AND (Nr% >= 32 AND Nr% <= 255) THEN Tempo% = Nr%
      END SELECT
   LOOP

   QTPlay00 Octave%, NoteLen%, Tempo%, SoundLen%, TmpNoteLen%, BaseTime&

   EXIT SUB



PlayNote:          ' play the note defined by Freq%
   IF TmpNoteLen% = 0 THEN TmpNoteLen% = NoteLen%
   NoteTime% = BaseTime& \ CLNG(Tempo% * TmpNoteLen%)
   IF Freq% > 0 THEN
      QTSound CINT(1193180 \ CLNG(Freq%)), SoundLen% * NoteTime%
   ELSE
      QTSound 0, SoundLen% * NoteTime%
   END IF
   QTSound 0, (8 - SoundLen%) * NoteTime%
   TmpNoteLen% = 0
   BaseTime& = 30600
   RETURN

END SUB




SUB QTInitPlay               ' reset defaults to original values
   Octave% = 4
   NoteLen% = 4
   Tempo% = 120
   SoundLen% = 7
   TmpNoteLen% = 0
   BaseTime& = 30600
   QTPlay00 Octave%, NoteLen%, Tempo%, SoundLen%, TmpNoteLen%, BaseTime&
END SUB
