'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        BASWIZ  Copyright (c) 1990-1993  Thomas G. Hanlin III         |
'   |                                                                      |
'   |                      The BASIC Wizard's Library                      |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE FUNCTION BCDAdd$ (Nr1 AS STRING, Nr2 AS STRING)
   DECLARE FUNCTION BCDSet$ (NumSt$)
   DECLARE SUB BCDGetSize (LeftDigits AS INTEGER, RightDigits AS INTEGER)

   DECLARE SUB BCDMul1 (Num1 AS STRING, BYVAL Num2 AS INTEGER)

   DEFINT A-Z

FUNCTION BCDMul$ (Nr1 AS STRING, Nr2 AS STRING)
   BCDGetSize LeftD, RightD
   TotalD = LeftD + RightD
   IF LEFT$(Nr1, 1) = LEFT$(Nr2, 1) THEN
      Sign$ = " "
   ELSE
      Sign$ = "-"
   END IF
   N1$ = MID$(Nr1, 2)
   N2$ = MID$(Nr2, 2)
   Total$ = BCDSet$("0")
   FOR tmp2 = LEN(N2$) TO 1 STEP -1
      ch = ASC(MID$(N2$, tmp2, 1))
      IF ch THEN
         St$ = N1$
         BCDMul1 St$, ch
         IF tmp2 > TotalD - RightD THEN
            ShiftVal = RightD - (TotalD - tmp2)
            St$ = " " + STRING$(ShiftVal, 0) + LEFT$(St$, LEN(St$) - ShiftVal)
         ELSE
            ShiftVal = LeftD - tmp2
            St$ = " " + MID$(St$, ShiftVal + 1) + STRING$(ShiftVal, 0)
         END IF
         Total$ = BCDAdd$(Total$, St$)
      END IF
   NEXT
   BCDMul$ = Sign$ + MID$(Total$, 2)
END FUNCTION
