'PIXDEMO.BAS (c) K.Willetts 1992/2
'Note: Demo Quick Library PIX4? must be loaded.
'This short program demonstrates just about all you need to know to use
'Pixshow. Use it to redisplay the 3 included demo .QPX images...
'
'   CGADEMO, EGADEMO, VGADEMO
'
'....by specifying one of the above names as a Command Line argument (via the
'Run/Modify COMMAND$ QB Editor menu selection above). No need to include the
'.QPX filename extension, that is added in the code below. Ensure the image
'files are in the same directory as this program. CGADEMO is a 2 color 640 x
'200 image; EGADEMO is a 16 color 640 x 350 image; VGADEMO is a 256 color
'320 x 200 image.


'Program Starts...

  DEFINT A-Z                                  'Usually useful.
  DECLARE FUNCTION biostobasic (biosmode)     'See below.
  '$INCLUDE: 'PIXSHOW.BI'                     'Get Pixshow declarations.
  CONST FALSE = 0, TRUE = NOT FALSE
  CONST DEFAULTBUFFER = 0                     'See below.

'Because this demo prog can display images in several screen modes we need to
'query each image file before displaying it to find out which video mode it
'uses. The qpxheader TYPE is used to get information about an on - disk .QPX
'image file. qpxheader is declared in PIXSHOW.BI and further described in the
'on disk manual PIXMAN.COM...

  DIM imageinfo AS qpxheader

'Build the image filename string. Image file/pathnames MUST always be
'explicitly terminated by a zero byte...

  image$ = COMMAND$ + ".QPX" + CHR$(0)
  IF LEN(image$) = 5 THEN
    CLS
    PRINT "You must place an image name in COMMAND$. See program comments"
    END
  END IF

'...Query the image to get it's screen mode. In .QPX files screen mode
'numbers follow BIOS numbering. Unfortunately QuickBasic screen mode numbers
'are different, so the FUNCTION biostobasic(...) has been included in this
'demo program to handle the conversion...

  IF getqpxinfo(imageinfo, image$) THEN
    basicmode = biostobasic(imageinfo.videomode)
  ELSE
    'problem...
    CLS
    PRINT "Error accessing .QPX image file. Program terminated"
    END
  END IF

'...Set QB screen mode via SCREEN and matching Pixshow library screen modes
'via library SUB setqpxmode(...)...
 
  ON ERROR GOTO VideoError
  SCREEN basicmode
  setqpxmode basicmode
  ON ERROR GOTO 0

'...Release memory from QB, then call Pixshow lib function setqpxbuffer(...)
'using the default argument value of zero (DEFAULTBUFFER is declared as 0
'above). See manual for alternative argument values. The resulting 32k buffer
'memory is used for decompressing images (In the manual it is called the
'Parcel Buffer). It is physically located in the FAR HEAP, not in QB's 64k
'DATA area. SETMEM with a negative argument tells QB to release memory for
'subsequent use by Pixshow. QB is greedy - it grabs all memory for itself
'even when running the smallest program...

  heap& = SETMEM(-33000)
  IF NOT setqpxbuffer(DEFAULTBUFFER) THEN
    'problem...
    SCREEN 0
    PRINT "Unable to allocate decompression buffer. Program terminated"
    END
  END IF

'...OK to load & display image if setqpxbuffer succeeds. The arguments to
'showqpx(...) are listed at the end of this file...

  IF NOT showqpx(650, 0, TRUE, FALSE, image$) THEN
    'problem...
    SCREEN 0
    PRINT "Error occurred loading .QPX image file"
  END IF
  LOCATE 25, 2: PRINT "press any key to end...";
  DO: LOOP WHILE INKEY$ = ""

'...Release memory & return it to QB before exiting. A successful call to
'setqpxbuffer(...) needs a matching call to rlsqpxbuffer. SETMEM with a
'positive argument returns the memory to QB's pool. Making the argument
'larger than the original allocation ensures all the memory is released...

  rlsqpxbuffer
  heap& = SETMEM(40000)
  SCREEN 0
  END

'...END OF PROGRAM

'Errror handlers...

VideoError:
  CLS
  PRINT "This machine does not support the videomode needed to redisplay"
  PRINT "the requested image. Program terminated"
  END


'Additional Comments...
'======================

'Arguments for showqpx(...), reading left to right...
'
'  horizontal (x) image top left corner position
'  vertical (y) image top left corner position
'  TRUE or FALSE = use/don't use file palette to reset screen colours
'  TRUE or FALSE =  blank/don't blank the screen while loading image
'  zero terminated string containing image path/filename

'Image positioning: to display the image in the same screen location it was
'at when captured by Pixsnap set x to an impossibly large value (greater than
'the pixel width of the screen). If showqpx finds a legal x position it will
'try to reposition the image according to the x & y argument values. For more
'information see on - disk manual PIXMAN.COM.

'*** END OF FILE ***

FUNCTION biostobasic (biosmode)

'Convert BIOS screen mode numbers to QB screen mode numbers.

  SELECT CASE biosmode
  CASE &H13
    biostobasic = 13     'VGA 320 x 200 x 256
  CASE &H12
    biostobasic = 12     'VGA 640 x 480 x 16
  CASE &H10
    biostobasic = 9      'EGA 640 x 350 x 16
  CASE &HE
    biostobasic = 8      'EGA 640 x 200 x 16
  CASE &HD
    biostobasic = 7      'EGA 320 x 200 x 16
  CASE &H6
    biostobasic = 2      'CGA 640 x 200 x 2
  CASE &H5, &H4
    biostobasic = 1      'CGA 320 x 200 x 4
  END SELECT

END FUNCTION

