DECLARE SUB Monocheck ()

'/TEST PROGRAM FOR MENU 4 + POPHELP.
' Note that INCLUDEd files and help text file MENU4.HLP must be
' available in the default drive/directory. The directory containing
' INCLUDE files may be specified via the Options/Set Paths... menu.
' If you want the program to look for MENU4.HLP in a directory other
' the default, find helpath$ below and change it's assignment/

'$INCLUDE: 'MENU4DCL.BI'      '/FUNCTION declarations needed for Menu4/

DEFINT A-Z                    '/default for this module/

'/dimension arrays to hold main and submenu selections, quick
' keys and help page pointers. DIM to the number of main menu
' entries and number of longest submenu entries PLUS 1. This
' menu implementation has five main menu entries and the longest
' submenu has 12/

DIM menu$(1 TO 6, 1 TO 13)    '/main & submenu selections/
DIM qkey(1 TO 6, 1 TO 13)     '/quick key selections/
DIM query$(1 TO 6, 1 TO 13)   '/query$ is used to hold uppercase letters in
                              ' the range A-Z. These control the context
                              ' sensitivity of Pophelp when it is called
                              ' from within an open menu. The letters are
                              ' coded in the DATA statements also used to
                              ' define menu entries and quick key selections.
                              ' See manual QUICKREF.DOC and study the DATA
                              ' statements at the end of this Module/

DIM spectrum(16)              '/spectrum(0..5) holds menus colours.
                              ' spectrum(8..11) holds Pophelp colours.
                              ' Study SUB Monocheck/

  menuentries = 5             '/5 main menu selections this implementation.
                              ' Make sure you define the number of main menu
                              ' entries before you call up the following
                              ' INCLUDE file/

'$INCLUDE: 'MENU34.BI'        '/call up a routine to fill menu$(), qkey()
                              ' and query$() from DATA statements/

'/go set colours according to monitor in use/

  CALL Monocheck              '/not a quick library subroutine/

'/finish menu initialisation. M4Init also draws the main menu
' bar along screen row 1/

  CALL M4Init(menuentries, menu$(), spectrum())


'**********************************************************************
'/This section of code (between the asterisks) is included for
' demonstration purposes only and may be deleted without
' affecting the operation of the Menus or Pophelp/

'/Fill screen with test background/

  LOCATE 2, 1
  CALL clrbox(spectrum(12), 80, 23)   '/see manual QUICKREF.DOC for details/

'/do prompt line/

  COLOR spectrum(13), spectrum(14)
  LOCATE 25, 1
  PRINT "   Menu4 + Pophelp  "; CHR$(179);
  PRINT "    F10 to Open Menu    F1 to call Help    Alt+X to Exit   ";
'**************************************************************************

'/going to use Pophelp so we need to intialise/

  code$ = "08125414"    '/Pophelp will pop up screen row 08, column 12
                        ' with a page size (including border) 54 columns
                        ' wide and 14 rows deep/

  context$ = "X"        '/if we call Pophelp from outside the menu (i.e.
                        ' from this module) it will pop up displaying the
                        ' index. X,Y & Z mean special things to Pophelp.
                        ' see manual for details/

  helpath$ = "MENU4.HLP"            '/tell Pophelp where it can find
                                    ' the help text file/

  CALL HelpInit(helpath$)             '/pass Pophelp the
  CALL Popcode(code$, spectrum())     ' information it needs/

'/miscellaneous variables/

  sh = 1                '/turn shadows on. sh = 0 turns them off/
  null$ = CHR$(0)       '/need for processing Function & Alt keys/

'**********************************************************************
'/Ready to go. Wait for call to display Menu4 or Pophelp Index or Quit/
'**********************************************************************
 
  DO
    DO
      sel$ = INKEY$
    LOOP WHILE sel$ = ""      '/wait for keypress/
   
    SELECT CASE sel$
       
    CASE null$ + CHR$(68)     '/F10 key calls menus/

'/open the menu/
   
    CALL M4Open(menu$(), qkey(), query$(), spectrum(), sh)

'/the menu will now remain open until the user either dismisses it
' (presses the Esc key) or makes a selection either by pressing
' Return or a highlighted quick key. If Esc is pressed the menu will
' be dismissed (closed) before control returns to here. If a selection
' is made the menu will be left on screen until you close it (by calling
' M4Close). You may want to display a dialog box or something before
' closing the menu/

'/Display returned selections (if any). Getkey4 returns the ASCII code
' of the last key pressed (if it was Esc or Return) or if a menu
' selection was made Getkey4 returns 13, the ASCII code for Return.
' Getmain4 and Getsub4 return integer numbers corresponding to the menu$()
' array co-ordinates of the selected menu entries. Use as shown below.
   
    IF Getkey4 = 13 THEN                '/a selection was made/

      x = Getmain4                      '/co-ordinates for main and
      y = Getsub4                       ' submenu selections, which
                                        ' will be retrieved from menu$()/

      COLOR spectrum(13), spectrum(14)
      LOCATE 22, 3: PRINT " Your last menu selection was:    ";
      LOCATE 23, 3: PRINT SPACE$(34)
      LOCATE 23, 4
      PRINT RTRIM$(menu$(1, x)); " + "; menu$(x + 1, y)  '/display selections/
     
'/if "Call POPHELP Index" was the selection then display Pophelp/

      IF menu$(x + 1, y) = "Call POPHELP Index" THEN
        CALL Pophelp(context$, sh)
      END IF

'/finished with the menu so dismiss it. It is only necessary to dismiss
' the menu if a selection was made/
     
      CALL M4Close(menu$())       '/dismiss menus/
    END IF

    CASE null$ + CHR$(45)         '/Alt + X to terminate program/
    EXIT DO
   
    CASE null$ + CHR$(59)         '/F1 key also calls Pophelp from here/
    CALL Pophelp("A", sh)         '/open Pophelp & display page A/


    END SELECT

  LOOP

'************************
'/DATA statements follow/
'************************

'/Main menu selections/
'/Use trailing spaces to format your entries along the main menu bar.
' It's up to you not to overlap the RH end. Note that each selection is
' followed by a number and an uppercase letter. The number represents the
' POSITION in the preceding selection of the 'quick key' you want to
' highlight. The uppercase letter is the index to the help page you want
' Pophelp to display if the user presses F1 while the menu is open.
' Each group of menu selections must end with ,#/

  DATA "Stars   ",1,C,"Constellations   ",1,C,"Planets   ",1,C
  DATA "Signs                              ",2,C,Help,1,C,#

'/Submenu selections/
'/Do not use any leading/trailing spaces in sub menu selections. If you
' want to place horizontal dividers in any submenu then code *,0,Z, in the
' positions you want (see 'Earth' in the 3rd. set of DATA statements below).
' Don't forget that a horizontal divider counts as one selection when you
' are totalling selections for the purposes of DIMensioning menu$() etc.
' Submenu selection lists must also end with ,#/

  DATA Arcturus,1,D,Betelgeuse,1,D,Sirius,1,D,Aldebaran,3,D
  DATA Formalhaut,1,D,Canopus,1,D,Zubenelgenubi,1,D,#

  DATA Canis Major,1,D,Cassiopeia,7,D,Andromeda,1,D
  DATA Ursa Minor,1,D,Corona Borealis,8,D,#

  DATA Mercury,3,D,Venus,1,D,*,0,Z,Earth,1,D,*,0,Z,Mars,1,D
  DATA Jupiter,1,D,Saturn,1,D,Uranus,1,D,Neptune,1,D,Pluto,1,D,#

  DATA Capricorn,1,D,Aquarius,1,D,Pisces,1,D,Aries,2,D,Taurus,1,D,Gemini,1,D
  DATA Cancer,3,D,Leo,1,D,Virgo,1,D,Libra,2,D,Scorpio,3,D,Sagittarius,1,D,#

  DATA Call POPHELP Index,14,D,#
                                   
END

SUB Monocheck STATIC
SHARED spectrum()

  COLOR 7, 0
  CLS
  LOCATE 2, 3
  PRINT "Press <C> for Colour"
  LOCATE 3, 3
  PRINT "Press <M> for Monochrome"

  DO
    sel$ = INKEY$
    IF UCASE$(sel$) = "C" THEN

'/Allocate menu colours/

      spectrum(0) = 14    '/highlighted letters (quick keys)/
      spectrum(1) = 10    '/menu border/
      spectrum(2) = 11    '/menu text/
      spectrum(3) = 4     '/menu background/
      spectrum(4) = 10    '/selected entries text/
      spectrum(5) = 0     '/selected entries background/

'/allocate Pophelp colours/

      spectrum(8) = 14      '/page text/
      spectrum(9) = 1       '/background/
      spectrum(10) = 10     '/border/
      spectrum(11) = 15     '/border text/

'/other colours needed for program/

      spectrum(12) = 2      '/screen backgound colour/
      spectrum(13) = 0      '/prompt line foreground/
      spectrum(14) = 7      '/prompt line background/
      EXIT DO

    ELSEIF UCASE$(sel$) = "M" THEN

'/not colour so set for mono monitor/

      spectrum(0) = 15
      spectrum(1) = 0
      spectrum(2) = 0
      spectrum(3) = 7
      spectrum(4) = 15
      spectrum(5) = 0
      spectrum(6) = 0
      spectrum(8) = 0
      spectrum(9) = 7
      spectrum(10) = 0
      spectrum(11) = 15
      spectrum(12) = 0
      spectrum(13) = 0
      spectrum(14) = 7
      EXIT DO

    END IF
  LOOP

END SUB

