DECLARE SUB Monocheck ()

'/TEST PROGRAM FOR POPHELP/
'/program expects to find help text file HELPTEST.HLP in the default
' drive/directory. If it can't find it you will get a message pointing
' this out, in which case either copy the file to the default directory
' or find helpath$ below and change it's assignment accordingly/


DEFINT A-Z            '/default for this program/
DIM spectrum(12)      '/spectrum() holds colour info for all the utilities.
                      ' Pophelp uses spectrum(8..11)/

'/find out if we are to run this in mono or colour and set the colours
' accordingly/

  CALL Monocheck      '/not a quick library subroutine/

'=======================================================================
'/code between double lines only needed for this test program/

'/draw test screen background/

  LOCATE 1, 1
  CALL clrbox(spectrum(0), 80, 24)      '/see manual QUICKREF.DOC
                                        ' for details on clrbox/
'/draw prompt line (screen row 25)/

  COLOR 0, 7
  LOCATE 25, 1: PRINT "   Pophelp  "; CHR$(179); "    F1-Call Pophelp";
  PRINT "    Esc-Dismiss Pophelp    Alt+X-Exit Program   ";

'======================================================================

  null$ = CHR$(0)   '/need this to recognise Function and Alt keys/

'****************************************
'Pophelp needs the following preparations
'****************************************

  code$ = "04095417"       '/Pophelp will pop up screen row 04 column 09
                           ' with a page area (including border) 54 columns
                           ' wide and 17 rows deep. Don't forget to include
                           ' leading zeros where necessary. code$ must
                           ' always contain 8 digits/

  context$ = "X"              '/initialise to call Help Index. context$ can
                              ' contain any uppercase letter from A - Z, but
                              ' X,Y & Z mean special things to Pophelp. See
                              ' Manual for details. If you specify a letter
                              ' that doesn't have an associated help text
                              ' page Pophelp will display the Index/

  helpath$ = "HELPTEST.HLP"    '/help file for this program. You will
                               ' have to change this if HELPTEST.HLP
                               ' is not in default drive/directory/

  ON ERROR GOTO Hlperror      '/since HelpInit opens the help text file and
                              ' reads the index information plus calculates
                              ' the file position offset for each of your
                              ' help pages this is the best place to trap
                              ' any help file access problems/
 
  CALL HelpInit(helpath$)     '/get index info from help disk file
                              ' HELPTEST.HLP. CALL Helpinit again anywhere
                              ' in your program if you want Pophelp to use
                              ' a different help file (you can have as
                              ' many as you like)/

  ON ERROR GOTO 0             '/disable error trap/

  CALL Popcode(code$, spectrum())   '/pass screen location, page size
                                    ' and colours info to Pophelp routines.
                                    ' CALL Popcode anywhere in your program
                                    ' to change colours, size or position/
  sh = 1    '/turn on shadowing.
            ' sh = 0 turns it off/


'    **********************
'    now we are ready to go
'    **********************

  DO
    DO
      sel$ = INKEY$
    LOOP WHILE sel$ = ""            '/wait for keypress/

    SELECT CASE sel$

      CASE null$ + CHR$(59)         '/F1 key/
      CALL Pophelp(context$, sh)    '/open Pophelp. context$ tells Pophelp
                                    ' which page from the help file (in this
                                    ' case the Index, as we have already
                                    ' assigned an "X" to context$) to
                                    ' display when it pops up. Assigning "Y"
                                    ' or "Z" to context$ also conveys special
                                    ' instructions to Pophelp. See the manual
                                    ' for details. sh controls the shadowing
                                    ' effect/

      CASE null$ + CHR$(45)         '/Alt+X keys/
      CLS
      EXIT DO                       'terminate program/

    END SELECT
  LOOP
  SYSTEM

'/Error trapping routines/

Hlperror:

'/probably subroutine HelpInit was unable to find HELPTEST.HLP, so
' we'll issue a box with a message in it (see BOXTEST.BAS for
' details on Drawbox)/
   
    CALL Drawbox(1, 1, 13, 44, 30, 8, 0, sh, spectrum())
    LOCATE 14, 46: PRINT "Unable to find Help file";
    LOCATE 15, 46: PRINT "HELPTEST.HLP.  This file";
    LOCATE 16, 46: PRINT "must be in the default";
    LOCATE 17, 46: PRINT "drive/directory for this";
    LOCATE 18, 46: PRINT "program to run.";
    LOCATE 19, 46: PRINT "Press any key to continue";

    DO: LOOP WHILE INKEY$ = ""
    CALL Zapbox(1, 13, 44, sh)      '/dismiss the box/

END

SUB Monocheck STATIC
SHARED spectrum()

  COLOR 7, 0
  CLS
  LOCATE 2, 3
  PRINT "Press <C> for Colour"
  LOCATE 3, 3
  PRINT "Press <M> for Monochrome"

  DO
    sel$ = INKEY$
    IF UCASE$(sel$) = "M" THEN        '/set for monochrome/
      spectrum(0) = 0
      spectrum(6) = 7
      spectrum(7) = 0
      spectrum(8) = 0
      spectrum(9) = 7
      spectrum(10) = 0
      spectrum(11) = 15
      EXIT DO
    ELSEIF UCASE$(sel$) = "C" THEN    '/set for colour/

'/we're not using any of the Menus so we can use spectrum(0...5)
' for other purposes/
  
      spectrum(0) = 2         '/screen background/
  
'/spectrum(6) and spectrum(7) are reserved for Drawbox/
  
      spectrum(6) = 14        '/Drawbox Foreground/border/
      spectrum(7) = 4         '/Drawbox Backgound/

'/spectrum(8...11) are reserved for Pophelp/

      spectrum(8) = 11        '/Pophelp page text/
      spectrum(9) = 1         '/Pophelp background/
      spectrum(10) = 12       '/Pophelp border/
      spectrum(11) = 14       '/Pophelp border text/
     
      EXIT DO
    END IF
  LOOP

END SUB

