DECLARE SUB Monocheck ()

'/TEST PROGRAM FOR MENU 1.
' INCLUDEd files need to be available in default drive/directory,
' or a directory specified via the Options/Set Paths... menu/

'$INCLUDE: 'MENU1DCL.BI'      '/reads in FUNCTION declarations for Getkey1,
                              ' Getmain1 & Getsub1. These must be included
                              ' in your program if you are using Menu 1.
                              ' Uses explained below/

DEFINT A-Z                    '/default for this module/

'/dimension arrays to hold main and submenu selections & quick
' keys. DIM to the number of main menu entries PLUS 1 and number
' of longest submenu entries PLUS 1. This menu implementation has
' five main menu entries and the longest submenu has 12/

DIM menu$(1 TO 6, 1 TO 13)
DIM qkey(1 TO 6, 1 TO 13)

DIM spectrum(12)          '/spectrum() holds the colour values used by
                          ' all the utilities. All the Menus always use
                          ' spectrum(0) to spectrum(5). spectrum(6) and
                          ' spectrum(7) are reserved for DRAWBOX and
                          ' spectrum(7..11) are reserved for POPHELP.

'/Allocate colours (default to colour)/

  spectrum(0) = 15    '/menu highlighted letters (quick key selections)/
  spectrum(1) = 14    '/menu border/
  spectrum(2) = 0     '/menu text (non-highlighted)/
  spectrum(3) = 3     '/menu background/
  spectrum(4) = 11    '/menu text (highlighted)/
  spectrum(5) = 1     '/background colour for highlighted text/

'/we're going to use spectrum(6) for the screen background
' since we're not using Drawbox in this program/

  spectrum(6) = 6     '/screen backgound colour/

'/go ask if a mono monitor is being used. If it is change the colours/

  CALL Monocheck


'**********************************************************************
'/This section of code (between the asterisks) is included for
' demonstration purposes only and may be deleted without affecting
' the operation of the menu/

'/Fill screen background/

  sb = spectrum(6)
  LOCATE 1, 1                 '/clrbox() is a useful assembly language
  CALL clrbox(sb, 80, 24)     ' procedure rather like a refined CLS
                              ' statement. sb can be any background
                              ' colour from 0-7. The 80, 24 in the argument
                              ' list means clear an area 80 columns wide by
                              ' 24 rows deep using the background colour
                              ' specified. Note you must LOCATE the top LH
                              ' corner of the box first. clrbox() does not
                              ' save the original screen. See manual
                              ' QUICKREF.DOC for full information/

'/do prompt line (screen row 25)/

  COLOR 0, 7
  LOCATE 25, 1
  PRINT "   Pulldown Menu M1  "; CHR$(179);
  PRINT "      F10 to open menu        Alt+X to Exit program       ";

'**************************************************************************


'/menu initialisation continues/

  sh = 1             '/turn the shadowing on. sh = 0 turns it off/
  menuentries = 5    '/there are 5 menu entries in main menu/

'/call up 2nd $INCLUDE file needed for this menu (Menu 1). This file
' contains a short routine which reads the DATA statements used to
' define menu selections and quick key codes into the arrays menu$()
' and qkey(). Included to save you the trouble of writing it yourself.
' You can of course hard code it into your program and/or choose
' different array/variable names if you want/

  '$INCLUDE: 'MENU12.BI'

'/now call up a library routine which works out how big your
' menu is going to be/

  CALL M1Init(menuentries, menu$())

  null$ = CHR$(0)     '/need this to recognise Function & Alt keys/
 
  mrow = 2            '/screen row position of top of menu and
  mcol = 4            ' screen column position LH edge of menu.
                      ' You can ask Menu 1 to pop up anywhere
                      ' as long as you don't place it off screen!/

'/now we are ready to go. Wait for call to display menu or quit/
   
  DO
    DO
      sel$ = INKEY$
    LOOP WHILE sel$ = ""        '/wait for keypress/
     
    SELECT CASE sel$
     
      CASE null$ + CHR$(68)     '/F10 key calls menu. Use any key you like/

'/open the menu/
       
      CALL M1Open(menu$(), qkey(), spectrum(), sh, mrow, mcol)

'/the menu is now open and control will not return to here until the user
' either makes a selection or presses the Escape key/

'/FUNCTION Getkey1 will return 13 if a selection was made. If the user
' dismissed the menu by pressing Escape then Getkey1 will return 27, in
' which case the menu will already have been cleared from the screen/
       
      IF Getkey1 = 13 THEN          '/a selection was made so
                                    ' we'll just display it/

        x = Getmain1                '/Getmain1 and Getsub1 are FUNCTIONS
        y = Getsub1                 ' that return numbers corresponding
                                    ' to the positions in array menu$()
                                    ' of the menu selection made. Use them
                                    ' to extract the selection from menu$()
                                    ' as shown in the third PRINT
                                    ' statement below/
        COLOR 0, 7
        LOCATE 22, 4
        PRINT " Your last menu selection was:   ";
        LOCATE 23, 4
        PRINT SPACE$(33);
        LOCATE 23, 5
        PRINT RTRIM$(menu$(1, x)); "/"; menu$(x + 1, y)

'/you could now process the menu selections using SELECT CASE, for example.
' Note that we strip away the trailing spaces from the main menu selection.
' Now we can dismiss the menu (remember that it is left on screen when a
' selection is made, in case you want to display a dialog box or the like)/

        CALL M1Close            '/dismiss menu/
      END IF

      CASE null$ + CHR$(45)     '/Alt + X to terminate program/
        CLS
        EXIT DO

    END SELECT
  LOOP

'/DATA statements follow/
'/Main menu selections. Use trailing spaces to format your main menu
' entries along the bar. Do not use leading spaces. Note that the righmost
' main menu entry requires no trailing spaces, and consequently no enclosing
' quotation marks. The library routines will automatically size the main
' menu bar but it's up to you not to overlap the edges of the screen. Each
' number following a selection represents the POSITION in that selection of
' the "quick key" highlighted letter. Each list of menu selections must
' end with ,#/

  DATA "Stars   ",1,"Constellations   ",1,"Planets   ",1
  DATA "Signs                   ",2,Astronauts,1,#

'/Submenu selections/
'/Do not use any leading/trailing spaces in sub menu selections, or you
' will confuse the routine which automatically works out the size of the
' submenu. Where you want a horizontal dividing line you enter *,0, in the
' list of selections. Each horizontal divider counts as one selection when
' you add up the totals for the purpose of dimensioning menu$() and qkey().
' Each list of submenu selections must also end with ,#/

  DATA Arcturus,1,Betelgeuse,1,Sirius,1,Aldebaran,3
  DATA Formalhaut,1,Canopus,1,Zubenelgenubi,1,#

  DATA Canis Major,1,Cassiopeia,7,Andromeda,1
  DATA Ursa Minor,1,Corona Borealis,8,#

  DATA Mercury,3,Venus,1,*,0,Earth,1,*,0,Mars,1
  DATA Jupiter,1,Saturn,1,Uranus,1,Neptune,1,Pluto,1,#

  DATA Capricorn,1,Aquarius,1,Pisces,1,Aries,2,Taurus,1,Gemini,1
  DATA Cancer,3,Leo,1,Virgo,1,Libra,2,Scorpio,3,Sagittarius,1,#

  DATA James T. Kirk,10,Neil Armstrong,6,Yuri Gagarin,1,Doctor Who,8,#

END

SUB Monocheck STATIC
SHARED spectrum()

  COLOR 7, 0
  CLS
  LOCATE 2, 3
  PRINT "Press <C> for Colour"
  LOCATE 3, 3
  PRINT "Press <M> for Monochrome"
 
  DO
    sel$ = INKEY$
    IF UCASE$(sel$) = "M" THEN
      spectrum(0) = 15
      spectrum(1) = 0
      spectrum(2) = 0
      spectrum(3) = 7
      spectrum(4) = 15
      spectrum(5) = 0
      spectrum(6) = 0
      EXIT DO
    ELSEIF UCASE$(sel$) = "C" THEN
      EXIT DO
    END IF
  LOOP

END SUB

