DECLARE SUB Monocheck ()
DECLARE SUB Domessage (sel$)

'/test program for Drawbox/

  DEFINT A-Z          '/default for this module/
 
  DIM spectrum(11)    '/Drawbox always uses spectrum(6 & 7)
                      ' for colour information/

  sh = 1              '/shadowing on. sh = 0 means shadowing off/

  CLS

'/go ask what sort of monitor is in use & set colours accordingly/

  CALL Monocheck      '/not a quick library subroutine/

'****************** Set Up Demonstration Screen ******************

'/draw background screen and promptline. See manual for
' details on clrbox. clrbox is not part of the Drawbox
' routines, but a separate utility for clearing any
' rectangular screen area with a specified background colour/

  LOCATE 1, 1
  CALL clrbox(spectrum(0), 80, 24)

'/draw promptline screen row 25/

  COLOR spectrum(1), spectrum(2)
  LOCATE 25, 1
  PRINT "  Drawbox  "; CHR$(179); "  Press:  1-style 1 box   ";
  PRINT "2-style 2 box   3-style 3 box   Esc-Exit  ";

'******************************************************************

'/now we are ready to go. The library routine Drawbox() is used to
' draw boxes and Zapbox() is used to dismiss them. Screen areas used
' are saved and restored/

    DO
      DO
        sel$ = INKEY$
      LOOP WHILE sel$ = ""          '/wait for keypress/

      SELECT CASE sel$

        CASE "1"
        '/draw a style 1 box, write message in it, then dismiss it/
          CALL Drawbox(1, 1, 4, 10, 56, 17, 4, sh, spectrum())
          CALL Domessage(sel$)
          CALL Zapbox(1, 4, 10, sh)
        CASE "2"
        '/draw a style 2 box etc./
          CALL Drawbox(2, 2, 8, 15, 40, 12, 0, sh, spectrum())
          CALL Domessage(sel$)
          CALL Zapbox(2, 8, 15, sh)
        CASE "3"
        '/draw a style 3 box etc./
          CALL Drawbox(1, 3, 4, 10, 40, 12, 0, sh, spectrum())
          CALL Domessage(sel$)
          CALL Zapbox(1, 4, 10, sh)
        CASE CHR$(27)                 '/escape key/
        '/terminate program/
          EXIT DO
      END SELECT
    LOOP
 
'/Drawbox arguments reading left to right are as follows/
'
'  /screen buffer to use - 1 or 2/
'  /style - 1,2 or 3/
'  /screen row location top LH corner of box/
'  /screen column location top LH corner of box/
'  /width of box in columns/
'  /depth of box in rows/
'  /position of hor. divider as number of rows down
'   from the top of the box.  0 = no horizontal divider/
'  /sh = 1 means shadow on. sh = 0 means shadow off/
'  /spectrum() passes the colours to use/
'
'/Zapbox arguments reading from left to right are as follows/
'
'  /screen buffer that was used - 1 or 2/
'  /screen row location top LH corner of box/
'  /screen column location top LH corner of box/
'  /sh = 1 means a shadow was used, sh = 0 means no shadow was used/
 
END

SUB Domessage (sel$) STATIC
SHARED spectrum()

'/write messages in boxes/
'/Note: if a PRINT statement is used immediately after drawing a
' style 1 or 2 box then the colours passed to Drawbox will be used.
' Style 3 boxes operate slightly differently as any PRINT statement
' issued after drawing the box will use the colours in effect before
' the box was drawn/

  IF sel$ = "1" THEN
    LOCATE 5, 17: PRINT "Style 1 box - drawn with single line border";
    LOCATE 8, 19: PRINT "A horizontal divider has been included";
    LOCATE 19, 24: PRINT "Press any key to continue...";
  ELSEIF sel$ = "2" THEN
    LOCATE 9, 29: PRINT "Style 2 box";
    LOCATE 10, 20: PRINT "Drawn with double line border";
    LOCATE 18, 21: PRINT "Press any key to continue...";
  ELSEIF sel$ = "3" THEN
    COLOR spectrum(3), spectrum(7)      '/specify text colours for box 3/
    LOCATE 5, 24: PRINT "Style 3 box";
    LOCATE 6, 19: PRINT "Drawn without borders";
    LOCATE 14, 16: PRINT "Press any key to continue...";
  END IF

  DO: LOOP WHILE INKEY$ = ""

END SUB

SUB Monocheck STATIC
SHARED spectrum()

  COLOR 7, 0
  CLS
  LOCATE 2, 3
  PRINT "Press <C> for Colour"
  LOCATE 3, 3
  PRINT "Press <M> for Monochrome"

  DO
    sel$ = INKEY$
    IF UCASE$(sel$) = "C" THEN

'/set colours for colour monitor/

      spectrum(0) = 1     '/use for screen background colour/
      spectrum(1) = 0     '/promptline text/
      spectrum(2) = 7     '/promptline background/
      spectrum(3) = 15    '/text colour for style 3 box/
      spectrum(6) = 14    '/box border colour/
      spectrum(7) = 4     '/box background colour/
      EXIT DO

    ELSEIF UCASE$(sel$) = "M" THEN

'/not colour so set for mono monitor/

      spectrum(0) = 0
      spectrum(1) = 0
      spectrum(2) = 7
      spectrum(3) = 15
      soectrum(6) = 15
      spectrum(7) = 7
      EXIT DO
                    
    END IF
  LOOP

END SUB

