*********************************************************************
*
* MVS.DOC - PC/370 RELEASE 2 MVS.ALC SHELL SVC LABELS/DOCUMENTATION
*
*********************************************************************
*
* MVS.ALC IS A SUBROUTINE WHICH CAN BE CALLED BY ANY PC/370 MAIN
* PROGRAM RUNNING IN SUPERVISOR STATE (THE DEFAULT AT STARTUP).
* MVS.ALC ESTABLISHES SVC, PROGRAM, AND EXTERNAL INTERRUPT HANDLERS
* TO EMULATE AN IBM MVS/XA OPERATING SYSTEM ENVIRONMENT AND RETURNS
* TO THE CALLING PROGRAM IN PROBLEM STATE MODE.  FROM THAT POINT ON
* IN THE PC/370 PROGRAM EXECUTION, ALL SVC CALLS AND PROGRAM CHECK
* INTERRUPTIONS WILL BE HANDLED BY MVS.ALC.  THE LABELS OF THE COMMON
* MVS SVCS FOLLOW WITH DOCUMENTATION ON HOW SELECTED SVC'S HAVE BEEN
* IMPLEMENTED IN THE CURRENT VERSION OF MVS.ALC.
*
* MVS SUPPORTS RESIDENT AND DYNAMICALLY LOADED SVCS.  ALL SVCS ARE
* NAMED IGC0NNN WHERE NNN IS THE DECIMAL SVC NUMBER 000-255.  IF THE
* SVC TABLE DOES NOT HAVE SVC ENTRY ADDRESS IN IT WHEN ACCESSED, MVS
* WILL ATTEMP TO LOAD IGC0NNN.MOD AND STORE ADDRESS FOR FUTURE USE.
* IF LOAD FAILS, 106 ABEND PROCESSING IS INVOKED.
*
* MVS SUPPORTS RESIDENT AND DYNAMICALLY LOADED MACRO INS.  ALL INS ARE
* NAMED INS0NNN WHERE NNN IS THE DECIMAL INS NUMBER 000-255.  IF THE
* INS TABLE DOES NOT HAVE INS ENTRY ADDRESS IN IT WHEN ACCESSED, MVS
* WILL ATTEMP TO LOAD INS0NNN.MOD AND STORE ADDRESS FOR FUTURE USE.
* IF LOAD FAILS, 106 ABEND PROCESSING IS INVOKED.  THIS IS NOT A STANDARD
* MVS/XA OFFERING BUT IS USEFUL FOR SIMULATING SELECTED 370 SUPR. INSTR.
* SUCH AS THE SIO SAMPLE WHICH IMPLEMENTS CCW CHANNEL SIMULATION I/O
* TO/FROM CONSOLE VIA SIO X'01F'.
*
*********************************************************************
MVSSVCS  DSECT    TYPE/REGS/DESCRIPTION
EXCP     EQU   0
XDAP     EQU   0
WAIT     EQU   1
WAITR    EQU   1
PRTOV    EQU   1
POST     EQU   2
EXIT     EQU   3   T1 (NO REGS - EXIT MVS TO PC/370 SUPR. STATE)
GETMAIN  EQU   4
FREEMAIN EQU   5
LINK     EQU   6
XCTL     EQU   7
LOAD     EQU   8
DELETE   EQU   9
GMAINR   EQU   10  T1 R0 = SPL,LENGTH, R1=NEG. GMAIN
FMAINR   EQU   10  T1 R0 = SPL,LENGTH, R1=POS. FMAIN ADDRESS
TIME     EQU   11  T1 R0 = TIME, R1 = FORMAT CODE IN LOW 4 BITS
SYNCH    EQU   12
ABEND    EQU   13  T1/T4 R1 = COMPLETION CODE (DUMP OPT. INVOKES T4)
SPIE     EQU   14
ERREXCP  EQU   15
PURGE    EQU   16
RESTORE  EQU   17
BLDL     EQU   18
FIND     EQU   18
OPEN     EQU   19
CLOSE    EQU   20
STOW     EQU   21
OPENJ    EQU   22
CLOSEJ   EQU   23
DEVTYPE  EQU   24
TRKBAL   EQU   25
CATALOG  EQU   26
INDEX    EQU   26
LOCATE   EQU   26
OBTAIN   EQU   27
SCRATCH  EQU   29
RENAME   EQU   30
FEOV     EQU   31
ALLOC    EQU   32
IOHALT   EQU   33
MGCR     EQU   34
QEDIT    EQU   34
WTO      EQU   35  T1 R1 = AL2(L'MSG,0),C'MSG'
WTOR     EQU   35  T1 R1 = AL1(L'REPLY),AL3(REPLY),AL2(L'MSG,0),C'MSG'
WTL      EQU   36
SEGLD    EQU   37
SEGWT    EQU   37
LABEL    EQU   39
EXTRACT  EQU   40
IDENTIFY EQU   41
ATTACH   EQU   42
CIRB     EQU   43
CHAP     EQU   44
OVLYBRCH EQU   45
TIMER    EQU   46
STIMER   EQU   47
DEQ      EQU   48
SNAP     EQU   51
SDUMP    EQU   51
RESTART  EQU   52
RELEX    EQU   53
DISABLE  EQU   54
EOV      EQU   55
ENQ      EQU   56
RESERVE  EQU   56
FREEBUF  EQU   57
REFBUF   EQU   58
REQBUF   EQU   58
OLTEP    EQU   59
STAE     EQU   60
STAI     EQU   60
ESTAE    EQU   60
ESTAI    EQU   60
IKJEGS6A EQU   61
DETACH   EQU   62
CHKPT    EQU   63
RDJFCB   EQU   64
BTAMTEST EQU   66
SYNADAF  EQU   68
SYNADRLS EQU   68
BSP      EQU   69
GSERV    EQU   70
ASGNBFR  EQU   71
BUFINQ   EQU   71
RLSBFR   EQU   71
SPAR     EQU   73
DAR      EQU   74
DQUEUE   EQU   75
IFBSTAT  EQU   76
LSPACE   EQU   78
STATUS   EQU   79
SETPRT   EQU   81
DASDR    EQU   82
SMFWTM   EQU   83
GRAPHICS EQU   84
DDRSWAP  EQU   85
ATLAS    EQU   86
DOM      EQU   87
MOD88    EQU   88
VOLSTAT  EQU   91
TCPEXEC  EQU   92
TGET     EQU   93
TPUT     EQU   93
SYSEVENT EQU   95
STAX     EQU   96
IKJEGSSG EQU   97
PROTECT  EQU   98
DYNALLOC EQU   99
IKJEFFIB EQU   100
QTIP     EQU   101
AQCTL    EQU   102
XLATE    EQU   103
TOPCTL   EQU   104
IMGLIB   EQU   105
MODSET   EQU   107
PGRLSE   EQU   112
PGFIX    EQU   113
PGFREE   EQU   113
PGLOAD   EQU   113
PGOUT    EQU   113
EXCPVR   EQU   114
DEBCHK   EQU   117
TESTAUTH EQU   119
GETMAIN2 EQU   120
FREMAIN2 EQU   120
VSAM     EQU   121
PURGEDQ  EQU   123
TPIO     EQU   124
EVENTS   EQU   125
MSSUCB   EQU   126
RACHECK  EQU   130
RACINIT  EQU   131
RACLIST  EQU   132
RACDEF   EQU   133
*********************************************************************
* END OF MVS.DOC
*********************************************************************

