;  WASHING MACHINE (Version 2)
; name and date

; constants
portA    equ    6
portB    equ    7
controlport equ 9
go       equ    2
go+water equ    10
rev+go+drain equ 35
go+water+soap equ 26
rev+go+heat equ 67
go+drain equ    34
rev+go+water equ 11
go+fast+drain equ 38
start    equ    1
empty    equ    4
full     equ    8
stop     equ    0
delaycount equ  5
none     equ    0

         out controlport,131 ; sets up 8255 i/o chip
outerloop mov b, data; address of data
innerloop mov a,(b)   ; get data
          out portA, a ; send data to lights

          inc b     ; point to terminator
          mov a,(b) ; get terminator
          inc b     ; point to next data
          cmp a,stop ; finished sequence?
          je outerloop
          cmp a,start ; waiting for start?
          je waitstart
          cmp a,full   ; waiting for full?
          je waitfull
          cmp a,empty   ; waiting for empty?
          je waitempty

delay     dec a
          jne delay
          jmp innerloop

waitstart in a,portB
          and a,3; start + door closed
          cmp a,start
          jne waitstart
          jmp innerloop

waitfull  in a,portB
          and a,full
          jz waitfull
          jmp innerloop

waitempty in a,portB
          and a,empty
          jz waitempty
          jmp innerloop

;           outputs , step ended by
;           -----------------------
data      db none,start
          db go+water,full
          db rev+go+drain,empty
          db go+water+soap,full
          db rev+go+heat,delaycount
          db go,delaycount
          db rev+go+heat,delaycount
          db go,delaycount
          db go+drain,empty
          db rev+go+water,full
          db go, delaycount
          db rev+go+drain,empty
          db go+fast+drain,delaycount
          db none,stop
;  wash 2  -  disk A32
