
; WASHING MACHINE (Version 1)
; name and date

; constants
portA    equ    6
portB    equ    7
controlport equ 9
start    equ    1
go       equ    2
empty    equ    4
full     equ    8

       out controlport,131   ; sets up 8255 i/o chip

start1 out portA,0  ; all outputs off
start2 in a, portB
       and a, 3     ; start + door open
       cmp a, start ; door should be closed
       jnz start2

       out portA, 26 ; water + soap + go
       call waitfull
       mov loopcount,3

loop  out portA, 67 ; go + rev + heat
      call delay

      out portA, go
      call delay

      dec loopcount
      jnz loop

      out portA, 34 ; drain + go
      call waitempty

      out portA, 10 ; water + go
      call waitfull

      out portA, 34 ; drain + go
      call waitempty

      out portA, 38 ; fast + go + drain
      call delay

      jmp start1

loopcount ds 1

delay mov a, 4
delay2 dec a
      jne delay2
      ret

waitfull in a,portB ; waits for drum to fill
         and a,full
         jz waitfull
         ret

waitempty in a,portB ; waits for drum to empty
          and a,empty
          jz waitempty
          ret                ;  wash1prg.asm  disk A26
