; msgprg.asm
;
;Loc Obj        Source code
;==========================
;            ; MESSAGE PROGRAM
;            
;            ; This writes a message to the CPU 'screen'.
;            
;            ; Register A is used for data,
;            ; and register B is used for
;            ; the address of the data in memory.
;            
;            ; Screen data is written to output port $56.
;            
;            ; name and date
;            
;            ; constants
;              CR       EQU 13        ; carriage return
;            ;                     does line feed also
;              SCREEN   EQU $56       ; hex 56
;               
00: 1B 0D    ; START    MOV B,DATA    ; address of data
02: 13       ;          MOV A,(B)     ; get data
03: 38 56    ; LOOP     OUT SCREEN,A  ; write char to screen
05: 61       ;          INC B         ; address next character
06: 13       ;          MOV A,(B)     ; get data
07: FA 00    ;          CMP A,0       ; end of data?
09: 5B 03    ;          JNZ LOOP      ; no
0B: 50 00    ;          JMP START     ; go round again
;               
0D: 20 4D 65 ; DATA     DB ' Message to be sent ',CR 
10: 73 73 61 67 65 20 74 6F 20 62 65 20 73 65 6E 74 
20: 20 0D 
22: 00       ;          DB 0          ; terminator
;               
;               
;            ; Msgprg -  Disk A32
;
;  0 errors detected
;
;   SYMBOL TABLE: symbols = 5
;   ------------
; 0D: CR                   56: SCREEN               00: START
; 03: LOOP                 0D: DATA                 
;
