
Comment
==========================================================

This section allows for a screen crawl on the bottom line of the screen.
It reads a file and displays it over and over.

If TODAY.TXT doesn't exist then no crawl will be displayed.

Blank lines in the TODAY.TXT file cause * * * to appear.

==========================================================
EndComment


;----- Background Tasking

var
  CrawlFile = 'TODAY.TXT'     ;name of the file you want to display
  CrawlDelay = 30             ;seconds to wait to start
  ThisLine
  NextLine
  LinePtr
  OldTimer
  Crawl


;----- Setup

OldTimer = Timer
IdleProgram = Loc CrawlTask


;----- Procedures

Procedure FillLine
   while length(ThisLine) < (ScreenWidth - 2)
      if NextLine = ''
         NextLine = Crawl[LinePtr]
         LinePtr = LinePtr + 1
         if NextLine = ''
            NextLine = '* * * '
         else
            NextLine = NextLine + ' '
         endif
      endif
      ThisLine = ThisLine + Left(NextLine,1)
      delete(NextLine,1,1)
   endwhile
EndProc


Procedure CrawlTask
var X

;   if Hour = 1
       ;this is where you can start something at 1:00 in the morning
;   endif

   while not KbdReady and (Timer - OldTimer < (CrawlDelay * 18))
   EndWhile

   OldTimer = Timer
   if KbdReady then Return

   ThisLine = ' * * * * * * * * * * '
   LinePtr = 1
   NextLine = ''

   ;----- Read the text file.

   if NumberOfElements(Crawl) = 0
      CrawlFile = ExistOnPath(CrawlFile)
      if CrawlFile = ''
         IdleProgram = Nil
         Return
      endif
      ReadTextFile (CrawlFile,Crawl)
      if Crawl[NumberOfElements(Crawl)] > ''
         AppendArray(Crawl,'')
      endif
      AppendArray(Crawl,'###')
      AppendArray(Crawl,'')
   endif

   SetTopWindow StatusWindow
   while not KbdReady
      if LinePtr > NumberOfElements(Crawl) then LinePtr = 1
      FillLine
      X = Timer
      if (X mod 2 = 0) and (X <> OldTimer)
         GotoXY 2 1
         Write ThisLine
         delete(ThisLine,1,1)
         OldTimer = X
      endif
   endwhile

   ClearScreen
   WriteCenter StatusLineText
   SetWindowUnder (StatusWindow,StatusWindow + 1)
   OldTimer = Timer
EndProc


