PAGE ,132
	TITLE SAMTSR
; -----------------------------------------------------------------------------
;	This is a sample TSR A/D converter driver for N6NKF's spectrum
;	analyzer program.  Add code to read samples from your A/D 
;	converter to make your own driver.
;
;	On entry, AX contains either -1 if this call is to set
;	the sample rate of your A/D converter hardware, or a positive number,
;	NUMSAM, if this	call is intended to return NUMSAM samples from the A/D.
;	NUMSAM may be as large as 1024.  The driver should buffer at least this
;	many samples, and be ready to deliver them to the calling program on
;	demand.
;
;	ES:BX contains a pointer to the address of the buffer, into which
;	we are supposed to place the A/D converter samples.
;
;	Suggest you replace the routines SETSAM and GETSAM with your own
;	code, but leave the routine intF1 as is.  SETSAM and GETSAM may
;	use any registers.
;
;	To build this program...    >  MASM samtsr;
;				    >  LINK samtsr;
;				    >  EXE2BIN samtsr.exe samtsr.com
;				    >  DEL samtsr.exe
;
; -----------------------------------------------------------------------------

cseg	segment	para public 'code'
	org	100H		;COM files must start at 100H
	assume cs:cseg,ds:cseg


;Main routine.  This code executes once when you run the TSR.  It sets up
;interrupts, sets up your A/D converter hardware, then executes the DOS
;TSR (Terminate and Stay Resident) call.

TSR	proc	near		;

;  set F1 interrupt to vector to our interrupt routine...
	mov	dx,offset cseg:intF1    ;addr of our interrupt handler
	mov	ah,25H		;set vector
	mov	al,0F1H		;for for our interrupt
	int	21H		;doscall

;  do the DOS Terminate & Stay Resident function..
	mov	ah,31H		;TSR function
	mov	al,0		;success return code
	mov	dx,offset cs:high_address    ;highest addr in program
	add	dx,15		;round up
	mov	cl,4		;cnvt to
	shr	dx,cl		;paragraphs
	int	21H		;doscall
tsrend:	jmp	tsrend		;the doscall should never return

TSR	ENDP

PAGE
; -----------------------------------------------------------------------------
;  Software interrupt handler for F1 interrupt.  This is the entry point
;  by which the spectrum analyzer calls the driver.
; -----------------------------------------------------------------------------

intF1	proc	far		;
	jmp	in2		;jmp around identification words
	dw	0FAFAH		;this jmp and two id words expected by calling
	dw	0FAFAH		;pgm, and used to verify that TSR is present

in2:	push	ds		;save critical registers
	sti			;reenable interrupts

	cmp	ax,-1		;set sample rate call?
	je	tsrssr		;so go do it.

	call	getsam		;invoke a routine to get some samples
	jmp	intxit		;and return

tsrssr:	call	setsam		;invoke a routine to set sample rate

intxit:	pop	ds		;restore
	iret			;and return
intF1	endp			;

PAGE

; -----------------------------------------------------------------------------
;SETSAM -- routine to set sample rate...
; -----------------------------------------------------------------------------

setsam	proc	near		;
	mov	ax,es:[bx]	;get sample rate
	mov	dx,es:+1[bx]	;get sample rate
;  now dx,ax contains the desired sample rate in units of samples 
;  per second.  insert instructions here which write this to your
;  hardware...

	ret			;return
setsam	endp


PAGE

; -----------------------------------------------------------------------------
;GETSAM -- routine to read samples into the input buffer...
;replace this with code which reads samples from your A/D converter.
;I urge you to use interrupts (or whatever mechanism) to allow this driver to
;read samples from your A/D converter while the spectrum analyzer program
;is computing.  When the program needs the next buffer of samples, it will
;call this driver, which will simply transfer a buffer of samples which have
;accumulated.  This overlapped processing allows the program to run much
;faster than a simple wait-for-the-samples-then-return approach.
; -----------------------------------------------------------------------------


getsam	proc	near		;
	mov	cx,ax		;#samples
	mov	di,bx		;destination address now in es:di
	mov	si,offset samples  ;some example samples
	mov	ax,cs		   ;which are in code segment of course
	mov	ds,ax		   ;because this loads as a .COM program
	cld			;forward direction
	rep	movsw		;xfer buffer of samples to calling program
	ret			;return
getsam	endp			;

samples:			;sample buffer which already contains
				;some samples...
	rept	1024/40+1	;>1024 samples of a square wave
	dw 20 dup ( 8192)
	dw 20 dup (-8192)
	endm


high_address equ this byte	;symbol for highest address used in the code
				;segment (the only segment) in this TSR.
				;allows DOS to know how much memory we need
				;when we Terminate & Stay Resident
cseg	ENDS
	end tsr			;specify entry point
