/* a thousand points of light */

#include "stdio.h"
#include "stdlib.h"
#include "math.h"

#define BOXSIZE 4096     /* for the sphere the largest x y or z is BOXSIZE/2 */
#define MAXSTARSIZE 12   /* size of star */
#define STARSPERSIDE 1000 /* number of stars */

#ifndef BOX
main()
{
    double j,x,y,z,t,ymax,sz;
    int i,color,size;
    
fprintf(stderr,"STAR - Points of light generator.\nBy Karl A. Weller 08/92\nUsage: Star >file.out\nCreates a POV 1.0 file\n(Working) ");

    sz = BOXSIZE / 2;
    printf("// Star - Points of light generator (actually spheres they're faster)\n");
    printf("// Brought to you by Karl A. Weller CIS [74620,2112]\n");
    printf("// This version for POV Ray 1.0\n");
    printf("// Feel free to beg barrow or steal this code.\n");
    printf("// If you do something interesting with it drop me a line!\n\n");
    printf("// Sphere Mode:\n");
    printf("//        Size of sphere    %d\n",BOXSIZE);
    printf("//        Max sphere size   %d\n",MAXSTARSIZE);
    printf("//        Number of spheres %d\n",STARSPERSIDE);
    printf("\n\ncomposite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        if (kbhit()) if (getch() == 27) break;
        if (i%10 == 0) fprintf(stderr,".");
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;

        x = rand() / (32768/BOXSIZE);
        x -= (sz);
        ymax = sqrt((sz*sz)-(x*x));
        y = 0;
        if (ymax != 0) {
            y = rand() / (32768/(ymax*2));
            y -= ymax;
        }
 /* keep points above 0 */
/*
if (y<0) y *= -1;
*/
        z = sqrt((sz*sz)-((x*x)+(y*y)) );
        j = rand();
        t = -1;
        if (j>16384) t = 1;
        z *= t;

        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        printf("object { sphere { <%f %f %f> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
/*
        t = sqrt((x*x)+(y*y)+(z*z) );
        printf("// %f\n",t); 
*/
    }
    printf("bounded_by {\n   sphere {<0 0 0> %d } \n}\n}\n",(BOXSIZE/2)+(MAXSTARSIZE*2) );
    fprintf(stderr,"\n\n");
}
#else
main()
{
    int i,j,x,y,z,size;
    int color;
    
    z = BOXSIZE/2;                   /* back */
    printf("composite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;
        x = rand() / (32768/BOXSIZE);
        y = rand() / (32768/BOXSIZE);
        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        x -= (BOXSIZE/2);
        y -= (BOXSIZE/2);
        printf("object { sphere { <%d %d %d> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
    }
    printf("bounded_by {\n   box {<%d %d %d> <%d %d %d>}\n}\n}\n",
      (-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),((BOXSIZE/2))-(MAXSTARSIZE*2),
      (   (BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2),((BOXSIZE/2))+(MAXSTARSIZE*2) );

    z = (-1*(BOXSIZE/2));                   /* front */
    printf("composite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;
        x = rand() / (32768/BOXSIZE);
        y = rand() / (32768/BOXSIZE);
        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        x -= (BOXSIZE/2);
        y -= (BOXSIZE/2);
        printf("object { sphere { <%d %d %d> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
    }
    printf("bounded_by {\n   box {<%d %d %d> <%d %d %d>}\n}\n}\n",
      (-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),
      (   (BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2),(-1*(BOXSIZE/2))+(MAXSTARSIZE*2) );

    x = BOXSIZE/2;                   /* right */
    printf("composite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;
        z = rand() / (32768/BOXSIZE);
        y = rand() / (32768/BOXSIZE);
        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        z -= (BOXSIZE/2);
        y -= (BOXSIZE/2);
        printf("object { sphere { <%d %d %d> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
    }
    printf("bounded_by {\n   box {<%d %d %d> <%d %d %d>}\n}\n}\n",
      ((BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),
      ((BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2) );

    x = (-1*(BOXSIZE/2));                   /* left */
    printf("composite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;
        z = rand() / (32768/BOXSIZE);
        y = rand() / (32768/BOXSIZE);
        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        z -= (BOXSIZE/2);
        y -= (BOXSIZE/2);
        printf("object { sphere { <%d %d %d> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
    }
    printf("bounded_by {\n   box {<%d %d %d> <%d %d %d>}\n}\n}\n",
      (-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),
      (-1*(BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2) );

    y = BOXSIZE/2;                   /* top */
    printf("composite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;
        x = rand() / (32768/BOXSIZE);
        z = rand() / (32768/BOXSIZE);
        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        x -= (BOXSIZE/2);
        z -= (BOXSIZE/2);
        printf("object { sphere { <%d %d %d> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
    }
    printf("bounded_by {\n   box {<%d %d %d> <%d %d %d>}\n}\n}\n",
      (-1*(BOXSIZE/2))-(MAXSTARSIZE*2),((BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),
      (   (BOXSIZE/2))+(MAXSTARSIZE*2),((BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2) );

    y = (-1*(BOXSIZE/2));                   /* bottom */
    printf("composite {\n");
    for(i=0;i<STARSPERSIDE;++i) {
        color = rand() / 8192;
        color += 6;
        if (color >= 10) color = 9;
        x = rand() / (32768/BOXSIZE);
        z = rand() / (32768/BOXSIZE);
        size = rand() / (32768/MAXSTARSIZE);
        size += 1;
        x -= (BOXSIZE/2);
        z -= (BOXSIZE/2);
        printf("object { sphere { <%d %d %d> %d } texture { color red 0.%d green 0.%d blue 0.%d ambient 1.0 diffuse 0.0 } }\n",x,y,z,size,color,color,color);
    }
    printf("bounded_by {\n   box {<%d %d %d> <%d %d %d>}\n}\n}\n",
      (-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),(-1*(BOXSIZE/2))-(MAXSTARSIZE*2),
      (   (BOXSIZE/2))+(MAXSTARSIZE*2),(-1*(BOXSIZE/2))+(MAXSTARSIZE*2),(   (BOXSIZE/2))+(MAXSTARSIZE*2) );

}
#endif
