DEFDBL A-Z
CONST FALSE = 0
CONST TRUE = NOT FALSE
CONST PI = 3.141592653589#
CONST Rad2Deg = 180 / PI
DEF fnNum$ (L, x) = MID$(STR$((10 ^ L) + x), 3)
DEF fnMargin (x) = x * 1.000001

Init:
  PRINT "SPRING generator for PVRAY 1.0 by K. Koehler v1.2"
  print "       Additions by Jeff Bowermaster"
  PRINT
  ' 05-03-92 KJK New program for PVRay 0.51, from STAR v1.1
  ' 07-08-92 Jeff Bowermaster added:
  '    sine wave motion
  '    torus code,
  '    sinister colors.
  ' 08-26-92 KJK Updated to POVRay 1.0

  INPUT "Wire radius             :"; wr
  INPUT "Spring radius           :"; sr

  a9 = -2 * (sr ^ 2 + wr ^ 2)
  a25 = 2 * (sr ^ 2 - wr ^ 2)
  a34 = (sr ^ 2 - wr ^ 2) ^ 2

  INPUT "Number of coils         :"; nc
  INPUT "Spring height min.      :"; shmin

  IF nc * wr * 2 < shmin THEN shmin = nc * wr * 2  ' prevent smushed coils

  INPUT "Spring height max.      :"; shmax
  INPUT "Number of frames        :"; nf
  INPUT "Subdirectory to write to (i.e. \POV) :"; sub$
  length = LEN(sub$)
  IF length > 0 THEN
	  IF LEFT$(sub$, 1) <> "\" THEN sub$ = "\" + sub$
	  sub$ = sub$ + "\"
  END IF

  OPEN sub$ + "runem.bat" FOR OUTPUT AS #2

  video = TRUE
  IF shmax > sr + wr THEN wy = shmax * 1.1 ELSE wy = (sr + wr) * 1.1
  wx = wy * 1.5' adjust aspect ratio

  sb = 0    ' spring bottom
  CoilRange = shmax - shmin
  boundxz = (wr + sr) * 1.01
  boundy = shmax * 1.01
  IF boundxz > boundy THEN size = boundxz ELSE size = boundy' !boundy recalc later!

Main:
  IF video THEN
	 SCREEN 12
	 WINDOW (-wx, -wy)-(wx, wy)
  END IF
  dsp$ = sub$ + "sprdsp.inc"
  OPEN dsp$ FOR OUTPUT AS #1
  GOSUB DspFile
  CLOSE #1

  obj$ = sub$ + "sprobj.inc"
  OPEN obj$ FOR OUTPUT AS #1
  GOSUB ObjTop
  ' build object INClude guts
  FOR Part = nc * 2 TO 1 STEP -2
	 PRINT #1, "    object { CoilHalf"
	 PRINT #1, "      rotate <0 0 -LoopAngle>"
	 PRINT #1, USING "      translate <0 CoilHalf\  \Y 0>"; fnNum$(4, Part)
	 PRINT #1, "    }"
	 PRINT #1, "    object { CoilHalf"
	 PRINT #1, "      rotate <180 0 0>"
	 PRINT #1, "      rotate <0 0 LoopAngle>"
	 PRINT #1, USING "      translate <0 CoilHalf\  \Y 0>"; fnNum$(4, Part - 1)
	 PRINT #1, "    }"
  NEXT Part
  GOSUB ObjBottom
  CLOSE #1

  FOR FrameNum = 0 TO nf-1
	 a = 180 * (1 + FrameNum / nf)
	 shcur = shmin + CoilRange * (1 + COS(a / Rad2Deg)) / 2
	 GOSUB BuildDat
  NEXT FrameNum
  PRINT #2, "dta spr*.tga /r6 /p /ffspring /s17"
  CLOSE #2
  END

BuildDat:
  IF video THEN
	 CLS
	 ink = 5
  END IF
  PRINT #2, "call p spr" + fnNum$(5, FrameNum); " "
  OPEN sub$ + "spr" + fnNum$(5, FrameNum) + ".pov" FOR OUTPUT AS #1
  GOSUB DatTop
  PRINT #1, ""
  PRINT #1, USING "declare BoundTop      = #####.#################"; fnMargin(shcur + wr)
  PRINT #1, USING "declare BoundRadius   = #####.#################"; fnMargin(sr + wr)
  PRINT #1, USING "declare BoundBottom   = #####.#################"; fnMargin(sb - wr)
  PRINT #1, USING "declare CoilRadius    = #####.#################"; sr
  PRINT #1, USING "declare CoilTop       = #####.#################"; shcur
  IF video THEN LINE (-sr, sb)-(sr, sb), ink: ink = ink XOR 1

  inc1 = shcur / (nc * 2)   ' distance moved in 1/2 cycle
  inc2 = shcur / (nc * 4)   ' 1/4 cycle

  ch = shcur / (nc * 4)
  cw = SQR((sr ^ 2) - (ch ^ 2))
  ca = ATN(ch / cw) * Rad2Deg

  PRINT #1, USING "declare LoopAngle     = ######.#################"; ca

  cyold = sb: cwold = -cw

  FOR Part = nc * 2 TO 1 STEP -1
		cy = (Part * inc1) - inc2
		PRINT #1, USING "declare CoilHalf\  \Y = ######.#################"; fnNum$(4, Part); cy

		IF video THEN
			LINE (-cwold, cy)-(cwold, cy + ch * 2), ink
			cwold = -cwold
			ink = ink XOR 1
		END IF

		cyold = cy
  NEXT Part

  PRINT #1, USING "declare CoilBottom    = ######.#################"; sb
  IF video THEN LINE (-sr, sb)-(sr, sb), ink
  GOSUB DatBottom
  CLOSE #1
RETURN

ObjTop:
  PRINT #1,
  PRINT #1, "#declare SpringTex   = texture { Shiny  colour Red  }"
  PRINT #1,
  PRINT #1, "#declare torus01 ="
  PRINT #1, "   quartic {"
  PRINT #1, "      <1.0 0.0 0.0 0.0 2.0 0.0 0.0 2.0 0.0 "
  PRINT #1, "      "; a9; " 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0"
  PRINT #1, "       0.0 0.0 1.0 0.0 0.0 2.0 0.0 "; a25; " 0.0"
  PRINT #1, "       0.0 0.0 0.0 1.0 0.0 "; a9; "0.0"; a34; ">"
  PRINT #1, "    }"
  PRINT #1,
  PRINT #1, "#declare CoilWhole ="
  PRINT #1, "  object {"
  PRINT #1, "    quartic { torus01  rotate <0 0 0>  }"
  PRINT #1, "    texture { SpringTex }"
  PRINT #1, "  }"
  PRINT #1,
  PRINT #1, "#declare CoilHalf ="
  PRINT #1, "  object {"
  PRINT #1, "    intersection {"
  PRINT #1, "      quartic {torus01  rotate <0 0 0>  }"
  PRINT #1, "      plane { <0  0 -1> 0.0 }"
  PRINT #1, "    }"
  PRINT #1, "    texture { SpringTex }"
  PRINT #1, "  }"
  PRINT #1,
  PRINT #1, "#declare Spring ="
  PRINT #1, "  composite {"
  PRINT #1, "       // wr="; wr; "  sr="; sr; "  shmin="; shmin; "  shmax="; shmax; "  nc="; nc; "  nf="; nf
  PRINT #1, "    object { CoilWhole"
  PRINT #1, "      translate <0 CoilTop 0>"
  PRINT #1, "    }"
RETURN

ObjBottom:
  PRINT #1, "    object { CoilWhole"
  PRINT #1, "      translate <0 CoilBottom 0>"
  PRINT #1, "    }"
  PRINT #1, "    bounded_by {"
  PRINT #1, "      intersection {"
  PRINT #1, "        plane { <0  1  0> BoundTop }"
  PRINT #1, "        quadric {Cylinder_Y  scale <BoundRadius 1 BoundRadius>  }"
  PRINT #1, "        plane { <0 -1  0> -BoundBottom }"
  PRINT #1, "      }"
  PRINT #1, "    }"
  PRINT #1, "  }"
RETURN


DspFile:
  PRINT #1,
  PRINT #1, "camera {"
  PRINT #1, USING "   location <#######.####  ######.####  ######.####>"; shmax / -2, 1.125 * shmax, -1.5 * shmax
  PRINT #1, "   direction <0.0 0.0  1.0>"
  PRINT #1, "   up  <0.0  1.0  0.0>"
  PRINT #1, "   right <1.33333 0.0 0.0>"
  PRINT #1, "   look_at ";
  PRINT #1, USING "<0.0 ######.#### 0.0>"; shmax / 2
  PRINT #1, "}"
  PRINT #1,
  PRINT #1, "// put down a disputbing yellow and blue checker floor"
  PRINT #1, "object {"
  PRINT #1, USING "   plane {<0.0 1.0 0.0> ######.#### }"; -fnMargin(wr)
  PRINT #1, "   texture {"
  PRINT #1, "      checker colour Coral colour CornflowerBlue"
  PRINT #1, USING "      scale <#####.#### #####.#### #####.####>"; sr; sr; sr
  PRINT #1, "      ambient 0.3"
  PRINT #1, "      diffuse 0.7"
  PRINT #1, "   }"
  PRINT #1, "}"
  PRINT #1,
  PRINT #1, "composite { Spring"
  PRINT #1, "    rotate <0 45 0>"
  PRINT #1, "  }"
  PRINT #1,
  print #1,"object { light_source { ";
  print #1,"<";10*size;" ";12*size;" ";-13*size;"> colour White } }"

RETURN

DatTop:
  PRINT #1, "// Persistence of Vision Raytracer"
  PRINT #1, "#include "; CHR$(34); "colors.inc"; CHR$(34)
  PRINT #1, "#include "; CHR$(34); "shapes.inc"; CHR$(34)
  PRINT #1, "#include "; CHR$(34); "textures.inc"; CHR$(34)
  PRINT #1, ""
  PRINT #1, "// ----------------------- Definitions start here -----------------------"
RETURN

DatBottom:
  PRINT #1,
  PRINT #1, "#include "; CHR$(34); "sprobj.inc"; CHR$(34)
  PRINT #1,
  PRINT #1, "// ----------------------- Display starts here -----------------------"
  PRINT #1,
  PRINT #1, "#include "; CHR$(34); "sprdsp.inc"; CHR$(34)
RETURN
