*********************************************************
* Clipper Demonstration Program
* Using Visage Document Image Processing
* Copyright 1992, Document Image Development Corp.
*********************************************************
i = 0
declare brwse_fields[1]
brwse_fields[1] = "DOCID"

use docs index docs
choice = 0

* Make sure that Visage is loaded
i = LOCATETSR()
if (i = 0)
  ? "Visage must be loaded before running this program."
  return
endif

* Start the menu system
do while choice != 5
  clear screen
  @  5, 9 to 11, 19
  @  6, 10 PROMPT " Memos   "
  @  7, 10 PROMPT " Letters "
  @  8, 10 PROMPT " Bills   "
  @  9, 10 PROMPT " Misc    "
  @ 10, 10 PROMPT " Quit    "
  menu to choice

  if choice = 1
    set filter to DOCS->DOCTYPE = "MEMO"
    DOC_ST = "MEMO"
  endif

  if choice = 2
    set filter to DOCS->DOCTYPE = "LETTER"
    DOC_ST = "LETTER"
  endif

  if choice = 3
    set filter to DOCS->DOCTYPE = "BILL"
    DOC_ST = "BILL"
  endif

  if choice = 4
    set filter to DOCS->DOCTYPE = "MISC"
    DOC_ST = "MISC"
  endif

  if choice = 5
    clear screen
    return
  endif

  save screen to scr
  @ 3, 29 to 15, 50
  @ 16, 29 say "Press INS to add a record"
  @ 17, 29 say "Press ENTER to edit a record"
  @ 18, 29 say "Press F10 for Document Menu"
  dbedit(4, 30, 14, 49, brwse_fields, "USERFUNC")
  restore screen from scr
enddo

*********************************************************

function userfunc
parameters status, fld_ptr
private request

key_stroke = lastkey()

do case

   case status = 4

     if key_stroke = 22 && INS key means add a new record
       add_record()
     endif

     if key_stroke = 27 && ESC exits from DBEDIT
       return 0
     endif

     if key_stroke = 13 && Enter means edit current record or add if blank
       if empty(DOCS->DOCTYPE)
         add_record()
       else
         edit_record()
       endif
     endif

     if key_stroke = -9 && F10 activates Visage menu system.
       if .not. empty(DOCS->IMGKEY)
         CALLMENU("DOCS",DOCS->IMGKEY,0,"")
       endif
     endif

endcase

return 1

*********************************************************

function edit_record
private scr
save screen to scr

@ 21,10 say "DOCID: " get docs->docid
set cursor on
read
set cursor off

restore screen from scr
return 0

*********************************************************

function add_record
private scr,m1

m1 = space(10)
save screen to scr

@ 21,10 say "DOCID: " get m1
set cursor on
read
set cursor off

if lastkey() != 27
  append blank
  replace docs->doctype with DOC_ST
  replace docs->docid with m1

  * Get a unique image key from Visage
  replace docs->IMGKEY with UKEY("DOCS",10)
endif

restore screen from scr
return 0
