/*****************************************************************************
*   Copyright (c) DIDC, 1991.  All rights reserved.                          *
*   Unauthorized use, duplication, or distribution is strictly prohibited.   *
*****************************************************************************/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>
#include <string.h>
#include <time.h>
#include <direct.h>
#include "mscvis.h"

#define DB_NAME_TOO_LONG       -561
#define KEY_TOO_LONG           -559
#define MAX_FNAME_LEN 64
#define PARAM_ERR              -531


#define MAX_RETRY     10
#define DTI_TIMEOUT -555

static union REGS DIDC_regs;
static char *DIDC_params;
static unsigned DIDC_int;
static char DIDC_strng[200];
static int DIDC_res;

static char CWDPATH[100];
static char CURRENT_PATH[100];
static char DRIVE[_MAX_DRIVE];
static char DIR[_MAX_DIR];
static char FNAME[_MAX_FNAME];
static char EXT[_MAX_EXT];
static char FULL_PATH[100];

/*************************************************************/

int DIDC_tsrloaded(unsigned int func_no)
{
static union REGS inregs, outregs;
  
inregs.x.ax = func_no;
int86(0x16, &inregs, &outregs);
if (outregs.x.ax == SIG)
    return(TRUE);
else
    return(FALSE);
}

/*************************************************************/

void DIDC_write_params(char s[])
{
static int i;
for (i = 0; i <= strlen(s); i++)
  DIDC_params[i] = (char) toupper(s[i]);
}

/************************************************************************/

void DIDC_delay(clock_t ms)
{
static clock_t start;

start = clock();
while ((clock()-start) < ms);
}

/************************************************************************/

int DIDC_dti_done(void)
{
if (DIDC_params[0] == 0)
  return 1;
return 0;
}

/************************************************************************/

int DIDC_result(void)
{
static int res;
memmove(&res,&DIDC_params[1],2);
return res;
}

/************************************************************************/

int DIDC_call_tsr(char s[])
{
static int retry;

if (DIDC_int == 0)
  return -557;

memset(&DIDC_regs,0,sizeof(DIDC_regs));

for (retry = 0; retry < MAX_RETRY; retry++)
  {
  DIDC_write_params(s);
  DIDC_regs.x.ax = 1;
  int86(DIDC_int,&DIDC_regs,&DIDC_regs);
  DIDC_delay((clock_t) 100);
  
  if (DIDC_dti_done())
    return DIDC_result();
  }
/*printf("timeout\n");*/
return DTI_TIMEOUT;
}

/************************************************************************/

void *DIDC_ptr(unsigned s, unsigned o)
{
void *p;
p = ((long) s << 16) + o;
return p;
}

/************************************************************************/
/* General functions                                                    */
/************************************************************************/

int DIDC_locate_tsr(void)
{
static unsigned *a;
static unsigned s,o;
static char *aa;
static unsigned i,j;

for (j = 0x60; j <= 0x67; j++)
  {
  a = (unsigned *) DIDC_ptr(0,(j*4));
  s = a[1];
  o = a[0];

  if (s > 0)
  for (i = 0; i < 5; i++)
    {
    aa = (char *) DIDC_ptr(s,o);
    if ((aa[0] == 'P') &&
        (aa[1] == 'Q') &&
        (aa[2] == 'R') &&
        (aa[3] == 'S'))
      {
      /* Obtain the address of the shared memory area */
      DIDC_regs.x.ax = 0;
      int86(j,&DIDC_regs,&DIDC_regs);
      DIDC_params = (char *) (((long) DIDC_regs.x.cx << 16) + DIDC_regs.x.dx);
      DIDC_int = j;
      return 1;
      }
    o++;
    }
  }
return 0;
}

/************************************************************************/

int DIDC_total_pages(char dbname[], char kname[])
{
/* Function 001: Return total document pages */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
sprintf(DIDC_strng,"%d %s %s",1,dbname,kname);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_total_pages_type(char dbname[], char kname[], int doc_type)
{
/* Function 002: Total pages of document type */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (doc_type < 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d",2,dbname,kname,doc_type);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_call_menu(char dbname[], char kname[], int flag, char tfname[])
{
/* Function 003: call visage menu */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if ((flag < 0) || (flag > 1))
  return PARAM_ERR;

_splitpath(dbname,DRIVE,DIR,FNAME,EXT);

/*
printf("dbname= %s\n",dbname);
printf("DRIVE %s\n", DRIVE);
printf("DIR   %s\n", DIR);
printf("FNAME %s\n", FNAME);
printf("EXT   %s\n", EXT);
*/

getcwd(CWDPATH,100);
/*
printf("CURRENT PATH %s\n",CWDPATH);
*/

#ifdef NODEF
if (strlen(DIR))
  {
  strcpy(FULL_PATH,dbname);
  }
else /* full path was not provided */
  {
  if (strlen(DRIVE)) /* drive was provided but not path */
    {
    printf("Full path not provided\n");
    return -1;
    }
  else
    sprintf(FULL_PATH,"%s\\%s",CWDPATH,dbname);
  }
#endif

/*
printf("FULL_PATH %s  length=%d\n",FULL_PATH,strlen(FULL_PATH));
getch();
*/

strcpy(FULL_PATH,dbname);
if (strlen(FULL_PATH) > 63)
  {
  printf("Path length error\n");
  return -1;
  }

sprintf(DIDC_strng,"%d %s %s %d %s",3,FULL_PATH,kname,flag,tfname);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_tsr_type(void)
{
/* Function 004 */
sprintf(DIDC_strng,"%d",4);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_batch_update(void)
{
/* Function 005 */
strcpy(DIDC_strng,"5");
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_set_write_vol(unsigned wv)
{
/* Function 006 */
sprintf(DIDC_strng,"%d %d",6,wv);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_clear_doc_page(void)
{
/* Function 007 */
sprintf(DIDC_strng,"%d",7);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_unique_key(char dbname[], char kname[], int len)
{
/* Function 008 */
int res;

if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (len > 30)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %d",8,dbname,len);
res = DIDC_call_tsr(DIDC_strng);
if (!res)
  strcpy(kname,&DIDC_params[3]);
else
  strcpy(kname,"");
return res;
}

/************************************************************************/

int DIDC_get_write_vol(void)
{
/* Function 010 */
sprintf(DIDC_strng,"%d",10);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_show_luns(void)
{
/* Function 011 */
sprintf(DIDC_strng,"%d",11);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/
/* Scan functions                                                       */
/************************************************************************/

int DIDC_scan_page(char dbname[], char kname[], int page_type)
{
/* Function 101 */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (page_type <= 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d",101,dbname,kname,page_type);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_auto_scan(char dbname[], char kname[], int page_type)
{
/* Function 102 */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (page_type <= 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d",102,dbname,kname,page_type);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_set_scanner(int page_len, int source, int intensity)
{
/* Function 103 */
if ((page_len < 0) || (page_len > 1))
  return PARAM_ERR;
if ((source < 0) || (source > 1))
  return PARAM_ERR;
if ((intensity < 0) || (intensity > 6))
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %d %d %d",103, page_len, source, intensity);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_insert_page(char dbname[],
                     char kname[],
                     int page_type,
                     int page_num)
{
/* Function 104 */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (page_type <= 0)
  return PARAM_ERR;
if (page_num <= 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d %d",104, dbname, kname, page_type, page_num);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_delete_page(char dbname[],
                     char kname[],
                     int page_type,
                     int page_num)
{
/* Function 105 */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (page_type <= 0)
  return PARAM_ERR;
if (page_num <= 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d %d",105, dbname, kname, page_type, page_num);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_get_scanner(int param)
{
/* Function 106 */
sprintf(DIDC_strng,"%d %d",106, param);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_save_scan_set(void)
{
/* Function 107 */
sprintf(DIDC_strng,"%d",107);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/
/* Print functions                                                      */
/************************************************************************/

int DIDC_print_all_pages_type(char dbname[],
                              char kname[],
                              int doctype)
{
/* Function 201 */
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (doctype < 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d", 201, dbname, kname, doctype);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_print_pages(char dbname[],
                     char kname[],
                     int doctype,
                     int first_page,
                     int last_page)
{
if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (doctype < 0)
  return PARAM_ERR;
if (first_page < 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d %d %d",
  203, dbname, kname, doctype, first_page, last_page);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/
/* Display Functions                                                    */
/************************************************************************/

int DIDC_display_page(char dbname[],
                      char kname[],
                      int pagetype,
                      int page,
                      int control)
{
/* Function 300 */

if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (pagetype < 1)
  return PARAM_ERR;
if (page < 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d %d %d",300,dbname,kname,pagetype,page,control);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/
/* OCR Functions                                                        */
/************************************************************************/

int DIDC_ocr_page(char dbname[],
                  char kname[],
                  int pagetype,
                  int page,
                  char textfname[],
                  int append_flag)
{
/* Function 400 */

if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (pagetype < 0)
  return PARAM_ERR;
if (page < 0)
  return PARAM_ERR;
if (strlen(textfname) == 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d %d %s %d",
            400,dbname,kname,pagetype,page,textfname,append_flag);
return DIDC_call_tsr(DIDC_strng);
}

/************************************************************************/

int DIDC_extract_image(char dbname[],
                       char kname[],
                       int doctype,
                       int page,
                       char fname[])
{
/* Function 401 */

if (strlen(dbname) > MAX_FNAME_LEN)
  return DB_NAME_TOO_LONG;
if (strlen(kname) > 30)
  return KEY_TOO_LONG;
if (strlen(fname) > MAX_FNAME_LEN)
  return PARAM_ERR;
if (doctype < 0)
  return PARAM_ERR;
if (page <= 0)
  return PARAM_ERR;

sprintf(DIDC_strng,"%d %s %s %d %d %s",11,dbname,kname,doctype,page,fname);
return DIDC_call_tsr(DIDC_strng);
}


/************************************************************************/
/* Other Functions                                                      */
/************************************************************************/

int DIDC_printer_status(void)
{
return _bios_printer(_PRINTER_STATUS,0,0);
}
