/*****************************************************************************
*   Copyright (c) DIDC, 1991.  All rights reserved.                          *
*   Unauthorized use, duplication, or distribution is strictly prohibited.   *
*****************************************************************************/
#include "mscvis.h"
#include "extend.h"

/*************************************************************/
/* Clipper Calls */
/*************************************************************/

CLIPPER LOCATETSR(void)
{
int res;
res = DIDC_locate_tsr();
_retni(res);
}

/*************************************************************/

CLIPPER CNT_P_TYPE(void)
{
/* 002 */
char far *db;
char far *key;
int doctype;
int res;

db = _parc(1);
key = _parc(2);
doctype = _parni(3);

res = DIDC_total_pages_type(db,key,doctype);
_retni(res);
}

/*************************************************************/

CLIPPER CALLMENU(void)
{
/* 003 */
char far *db;
char far *key;
char far *docfname;
int flag;
int res;

db = _parc(1);
key = _parc(2);
flag = _parni(3);
docfname = _parc(4);

res = DIDC_call_menu(db,key,flag,docfname);
_retni(res);
}

/***********************************************************/

CLIPPER TSRTYPE(void)
{
/* 004 */
int res;
res = DIDC_tsr_type();
_retni(res);
}

/*************************************************************/

CLIPPER BATCHUP(void)
{
/* 005 */
int res;

res = DIDC_batch_update();
_retni(res);
}

/*************************************************************/

CLIPPER SETWVOL(void)
{
/* 006 */
int vol,res;

vol = _parni(1);
res = DIDC_set_write_vol(vol);
_retni(res);
}

/***********************************************************/

CLIPPER CLRPGE(void)
{
/* 007 */
int res;
res = DIDC_clear_doc_page();
_retni(res);
}

/*************************************************************/

CLIPPER UKEY(void)
{
/* 008 */
char far *db;
static char key[30];
int res,len;

db = _parc(1);
len = _parni(2);
res = DIDC_unique_key(db, key, len);
_retc(key);
}

/***********************************************************/

CLIPPER GETWVOL(void)
{
/* 010 */
int res;
res = DIDC_get_write_vol();
_retni(res);
}

/***********************************************************/

CLIPPER SHOWLUNS(void)
{
/* 011 */
int res;
res = DIDC_show_luns();
_retni(res);
}

/***********************************************************/

CLIPPER SCNPGE(void)
{
/* 101 */
char far *db;
char far *key;
int page_type;
int res;

db = _parc(1);
key = _parc(2);
page_type = _parni(3);

res = DIDC_scan_page(db, key, page_type);
_retni(res);
}

/***********************************************************/

CLIPPER AUTOSCAN(void)
{
/* 102 */
char far *db;
char far *key;
int page_type;
int res;

db = _parc(1);
key = _parc(2);
page_type = _parni(3);

res = DIDC_auto_scan(db, key, page_type);
_retni(res);
}

/***********************************************************/

CLIPPER SETSCAN(void)
{
/* 103 */
int page_len;
int source;
int intensity;
int res;

page_len = _parni(1);
source = _parni(2);
intensity = _parni(3);

res = DIDC_set_scanner(page_len,source,intensity);
_retni(res);
}

/***********************************************************/

CLIPPER INSPGE(void)
{
/* 104 */
char far *db;
char far *key;
int page_type;
int page_num;
int res;

db = _parc(1);
key = _parc(2);
page_type = _parni(3);
page_num = _parni(4);

res = DIDC_insert_page(db, key, page_type, page_num);
_retni(res);
}

/***********************************************************/

CLIPPER DELPGE(void)
{
/* 105 */
char far *db;
char far *key;
int page_type;
int page_num;
int res;

db = _parc(1);
key = _parc(2);
page_type = _parni(3);
page_num = _parni(4);

res = DIDC_delete_page(db, key, page_type, page_num);
_retni(res);
}

/***********************************************************/

CLIPPER GETSCAN(void)
{
/* 106 */
int param;
int res;

param = _parni(1);
res = DIDC_get_scanner(param);
_retni(res);
}

/***********************************************************/

CLIPPER SAVESCAN(void)
{
/* 107 */
int res;
res = DIDC_save_scan_set();
_retni(res);
}

/***********************************************************/

CLIPPER PRTALL(void)
{
char far *db;
char far *key;
int doctype;
int res;

db = _parc(1);
key = _parc(2);
doctype = _parni(3);

res = DIDC_print_pages(db,key,doctype,0,0);
_retni(res);
}

/***********************************************************/

CLIPPER PRTPGES(void)
{
char far *db;
char far *key;
int doctype;
int first_page;
int last_page;
int res;

db = _parc(1);
key = _parc(2);
doctype = _parni(3);
first_page = _parni(4);
last_page  = _parni(5);

res = DIDC_print_pages(db,key,doctype,first_page,last_page);

_retni(res);
}

/***********************************************************/

CLIPPER DISPPAGE(void)
{
char far *db;
char far *key;
int doctype;
int page;
int control;
int res;

db = _parc(1);
key = _parc(2);
doctype = _parni(3);
page = _parni(4);
control = _parni(5);

res = DIDC_display_page(db,key,doctype,page,control);
_retni(res);
}

/***********************************************************/

CLIPPER OCR_PAGE(void)
{
char far *db;
char far *key;
char far *textfname;
int doctype,page,append_flag;
int res;

db = _parc(1);
key = _parc(2);
doctype = _parni(3);
page = _parni(4);
textfname = _parc(5);
append_flag = _parni(6);

res = DIDC_ocr_page(db,key,doctype,page,textfname,append_flag);
_retni(res);
}

/***********************************************************/

CLIPPER PRT_STAT(void)
{
int res;
res = DIDC_printer_status();
_retni(res);
}

/***********************************************************/

CLIPPER EXTIMG(void)
{
char far *db;
char far *key;
int doctype;
int page;
char far *fname;
int res;

db = _parc(1);
key = _parc(2);
doctype = _parni(3);
page = _parni(4);
fname = _parc(5);

res = DIDC_extract_image(db,key,doctype,page,fname);

_retni(res);
}

/***********************************************************/


