
 IMPLEMENTATION MODULE FIT;



  PROCEDURE WriteRec ( F : FIO.File; Rc : Foods );
  (* Writes a record  (Rc) to file F *)

  BEGIN
   FIO.WrChar (F, ' ');
   FIO.WrChar (F, Rc.Cat);
   FIO.WrCard (F, Rc.IdNum, -4);
   FIO.WrStr (F, Rc.Name);
   FIO.WrCard (F, Rc.Prot, -5);
   FIO.WrCard (F, Rc.Carbo, -5);
   FIO.WrCard (F, Rc.KCal, -5);
   FIO.WrCard (F, Rc.Fat, -5);
   FIO.WrCard (F, Rc.Satur, -5);
   FIO.WrCard (F, Rc.Calc, -5);
   FIO.WrCard (F, Rc.Fibre, -5);
   FIO.WrCard (F, Rc.Quantity, -5);
   FIO.WrStr (F, Rc.Unit);
   FIO.WrLn (F);
  END WriteRec;



  PROCEDURE ReadRec ( F : FIO.File; VAR Done : BOOLEAN ): Foods;
  (* Reads a record from file; if end of file then Done is set to false.
   Otherwise Done is set to TRUE, a record is read and returned *)

            VAR Rc : Foods;
                 B : CHAR;

  BEGIN  (* ReadRec *)
   Rc := InitRec;
     FIO.RdItem (F, B);
     IF (FIO.EOF) THEN Done := FALSE;
     ELSE
     Done := TRUE;
     Rc.Cat := B;
     Rc.IdNum := FIO.RdCard (F);
     FIO.RdStr (F, Rc.Name );
     Rc.Prot := FIO.RdCard (F);
     Rc.Carbo := FIO.RdCard (F);
     Rc.KCal := FIO.RdCard (F);
     Rc.Fat := FIO.RdCard (F);
     Rc.Satur := FIO.RdCard (F);
     Rc.Calc := FIO.RdCard (F);
     Rc.Fibre := FIO.RdCard (F);
     Rc.Quantity := FIO.RdCard (F);
     FIO.RdItem (F, Rc.Unit);
     FIO.WrLn (F);
   END; (* if *)
   RETURN Rc;
   END ReadRec;



  PROCEDURE Smallest (VAR A, B : Foods ) : INTEGER;
  (* Finds the smallest record (by category then name). If B<A then they swop
   and 1 is returned, if A<B then there is no swop and -1 is returned. If 
  they are equal then 0 is returned (the values of A & B are swopped only
  if B is less than A) *)

    VAR Int : ShtInt;
        Tmp : Foods;

  BEGIN
    IF (A.Cat < B.Cat) THEN
    RETURN -1;
    ELSIF (A.Cat > B.Cat) THEN
    Tmp := B;
    B := A;
    A := Tmp;
    RETURN 1;
    ELSE
    Int := Compare ( A.Name, B.Name );
      IF Int = 1 THEN
      Tmp := B;
      B := A;
      A := Tmp;
      RETURN 1;
      ELSE
      RETURN Int;
    END; (* if *)
  END; (* if *)
  END Smallest;


  PROCEDURE Spaces (A : LngStr): LngStr;
  (* appends spaces (max 22) to string A *)
    VAR Spc : LngStr;

  BEGIN
  Spc := '                      ';
  Append (A, Spc);
  RETURN A;
  END Spaces;


 PROCEDURE DeleteRec (Ch : CHARCat; Num : CARDINAL);

   VAR A : Foods;
       C : ShtInt;
      One : FIO.File;
      Two : FIO.File;
      Done : BOOLEAN;

 BEGIN
   IF FIO.Exists ('No1.fod') THEN
   One := FIO.Open ('No1.fod');
   Two := FIO.Create ('No2.fod');
   C := 0;
    LOOP
    A := ReadRec (One, Done);
      IF NOT Done THEN EXIT;
    END; (* if *)
      IF ((A.Cat = Ch) AND (A.IdNum = Num)) THEN
      WrLn; WrStr ('  THE FOOD ITEM HAS BEEN DELETED,  PLEASE WAIT..');
      C := 1;
      ELSE
      WriteRec (Two, A);
    END; (* if *)
   END; (* loop *)

     IF C # 1 THEN
     WrLn;  WrStr ('   RECORD WAS NOT FOUND ');
   END; (* IF *)
   FIO.Close (One);
   FIO.Close (Two);
   FIO.Erase ('No1.fod');
   FIO.Rename ('No2.fod', 'No1.fod');
 END; (* if *)
 END DeleteRec;



 PROCEDURE DeleteCatRecs (Ch : CHARCat);

   VAR A : Foods;
       C : ShtInt;
      One : FIO.File;
      Two : FIO.File;
      Done : BOOLEAN;

 BEGIN
   IF FIO.Exists ('No1.fod') THEN
   One := FIO.Open ('No1.fod');
   Two := FIO.Create ('No2.fod');
   C := 0;
    LOOP
    A := ReadRec (One, Done);
      IF NOT Done THEN EXIT;
    END; (* if *)
      IF A.Cat # Ch THEN
      WriteRec (Two, A);
      ELSE
      C := 1;
   END; (* if *)
  END; (* loop *)
  WrLn;
    IF C # 1 THEN
    WrStr ('   NO CATEGORY RECORDS WERE FOUND ');
    ELSE
    WrStr ('  CATEGORY RECORDS HAVE BEEN DELETED ');
   END; (* IF *)
   FIO.Close (One);
   FIO.Close (Two);
   FIO.Erase ('No1.fod');
   FIO.Rename ('No2.fod', 'No1.fod');
 END; (* if *)
 END DeleteCatRecs;


 PROCEDURE AddReport (F : FIO.File; Rec : Foods);

  (* Writes a record to report file F *)

  BEGIN
   FIO.WrChar (F, ' ');
   FIO.WrStr (F, '  ');
   FIO.WrStr (F, Rec.Name);
   FIO.WrCard (F, Rec.Prot, -5);
   FIO.WrCard (F, Rec.Carbo, -5);
   FIO.WrCard (F, Rec.KCal, -5);
   FIO.WrCard (F, Rec.Fat, -5);
   FIO.WrCard (F, Rec.Satur, -5);
   FIO.WrCard (F, Rec.Calc, -5);
   FIO.WrCard (F, Rec.Fibre, -5);
   FIO.WrCard (F, Rec.Quantity, -5);
   FIO.WrStr (F, Rec.Unit);
   FIO.WrLn (F);
  END AddReport;


 END FIT.

