IMPLEMENTATION MODULE FD;


PROCEDURE RdCategories (F : FIO.File; VAR Done : BOOLEAN) : CatNames;

      VAR A : CatNames;
          Q : CHARCat;
          B : CHAR;
          St : LngStr;

 BEGIN
   FOR Q := 'A' TO 'T' DO
   FIO.RdItem (F, B);
     IF FIO.EOF THEN
     Done := FALSE;
     A[Q] := InitCat;
     ELSE
     Done := TRUE;
     A[Q].CKey := B;
     A[Q].Posit := FIO.RdLngCard (F);
     FIO.RdItem (F, A[Q].Name);
     FIO.RdStr (F, St);
     FIO.WrLn (F);
     Append (A[Q].Name, ' ');
     Append (A[Q].Name, St);
   END; (* if *)
 END; (* for *)
 RETURN A;
 END RdCategories;



 PROCEDURE WrCategories (F : FIO.File; A : CatNames);

     VAR Q : CHARCat;

 BEGIN
   FOR Q := 'A' TO 'T' DO
   FIO.WrChar (F, ' ');
   FIO.WrChar (F, A[Q].CKey);
   FIO.WrLngCard (F, A[Q].Posit, -11);
   FIO.WrStr (F, A[Q].Name);
   FIO.WrStr (F, '  ');
   FIO.WrLn (F);
 END; (* for *)
 END WrCategories;

 PROCEDURE InitialCats (VAR A : CatNames);

   VAR B : CHARCat;

 BEGIN
   FOR B := 'A' TO 'T' DO
   A[B] :=  InitCat;
   A[B].CKey := B;
 END; (* for *)
 END InitialCats;


 PROCEDURE ShowCategories ( A : CatNames );

   VAR B : CHARCat;
       C : CHAR;

 BEGIN
   WrLn;
   FOR B := 'A' TO 'T' DO
   WrStr ('  ');
   WrChar ( A[B].CKey );
   WrStr (' : ');
   WrStr (A[B].Name);
   WrLn;
 END; (* for *)
   WHILE NOT KeyPressed () DO
 END; (* while *)
 END ShowCategories;

 PROCEDURE AddCategory (VAR A : CatNames; C : CHARCat);

 BEGIN
 WrLn; WrLn;
 WrStr (' Input a Name for category  ');
 WrChar ( C );
 WrStr (' : ');
 RdStr (A[C].Name);
 Append (A[C].Name, '                      ');
 Caps (A[C].Name);
 END AddCategory;


 PROCEDURE RenameCat (Ch : CHARCat);

   VAR A : CatNames;
       One, Two : FIO.File;
       Done : BOOLEAN;

 BEGIN
   IF FIO.Exists ('Cats.fod') THEN
   One := FIO.Open ('Cats.fod');
   Two := FIO.Create ('Cattmp.fod');
   A := RdCategories (One, Done);
     IF Done THEN
     WrStr (' Category ');
     WrChar ( Ch );
     WrStr (' - ');
     WrStr (A[Ch].Name);
     WrLn;
     AddCategory (A, Ch);
     WrCategories (Two, A);
     FIO.Close (One);
     FIO.Close (Two);
     FIO.Erase ('Cats.fod');
     FIO.Rename ('Cattmp.fod', 'Cats.fod');
   END; (* if *)
   ELSE
   WrLn;
   WrStr ('  FILE DOES NOT EXIST OR UNABLE TO READ CATEGORY FILE');
 END; (* IF *)
 END RenameCat;

END FD.