/********************************************************/
/*							*/
/*		    ROFF4, Version 1.60 		*/
/*							*/
/*(C) 1983,4 by Ernest E. Bergmann			*/
/*		Physics, Building #16			*/
/*		Lehigh Univerisity			*/
/*		Bethlehem, Pa. 18015			*/
/*							*/
/* Permission is hereby granted for all commercial and	*/
/* non-commercial reproduction and distribution of this */
/* material provided this notice is included.		*/
/*							*/
/********************************************************/

/********************************************************/
/*							*/
/* modified by F.W.Glassborow dec 1988 for Atari ST	*/
/* and largely revised january 1989			*/
/********************************************************/

/*10/1/89	*/
/*11/1/89	*/

#include "roff4st.h"

/**************************************************
handles case of leading blanks or tabs; empty lines 
***************************************************/

leadbl (line)
char *line;
{
	int i, j, white;
	brk();		/* new line starts with whitespace so print old line */ 
			/* figure out white space Nov 13*/
	for (white=0, i=0; line[i] == ' ' || line[i] == '\t'; i++ )
	{
		if(line[i]==' ') white++;
		else white=min(_RMVAL[0],_TABSIZ[0]*(1+white/_TABSIZ[0]));
	}
	if ( line[i] != NEWLINE ) TIVAL += white;
	for(j=0;(line[j]=line[i])!='\0';j++,i++);	/* move line to left */
}

/*****************************************
		    puts out page header
******************************************/

phead()
{
	int i,xftemp;
	i=NO_CRFLG;
	NO_CRFLG=0;
	xftemp=XF;
	XF=FALSE;
	CURPAG = NEWPAG++;
	if((CURPAG<FIRSTPAGE)||(CURPAG>LASTPAGE)) SUPPRESS=TRUE;
	else SUPPRESS=FALSE;
	OLDLN=-1;
	if(PAGESTOP)
	{
		CONOUT(BELL);	/*ring bell*/
		CONIN;		/*wait til char typed at console*/
	}
	PLINENO=0;
	FPLINENO=0;
	if (_M1VAL[0] > 0 )
	{ 
		VLINENO = _M1VAL[0]-1;
		if (CURPAG % 2) puttl3 ( OHEAD, OH2, OH3, CURPAG );
		else puttl3 ( EHEAD, EH2, EH3, CURPAG );
	}
	VLINENO = _M1VAL[0]+_M2VAL[0]; 
	FVLINENO=0;
	XF=xftemp;
	NO_CRFLG=i;
}
/**************************************
		    puts out page footer
***************************************/
pfoot()
{
	int i,xftemp;
	i=NO_CRFLG;
	NO_CRFLG=0;
	xftemp=XF;
	XF=FALSE;
	VLINENO = BOTTOM+_M3VAL[0]; 
	FVLINENO=0;
	if ( _M4VAL[0] > 0 )
	{ 
		if(CURPAG % 2)puttl3 ( OFOOT,OF2,OF3, CURPAG );
		else puttl3(EFOOT,EF2,EF3,CURPAG);
	}
	VLINENO = _PLVAL[0];
	FVLINENO=0;
	if (FFEED) putchar(FORMF);
	else padv();
	whole();
	OLDBOT=PLINENO=FPLINENO=0;/*printer at start of newpage*/
	OLDLN=-1;
	XF=xftemp;
	NO_CRFLG=i;
}
/**********************************************
	  space n lines or to bottom of the page
***********************************************/
space (n)
int n;
{
	brk(); /* flush out last unfilled line */
	if (VLINENO >= BOTTOM)	return; /* end of page */
	if (VLINENO<0) phead(); /* top of page */
	VLINENO += n;
	if (VLINENO >= BOTTOM) pfoot(); /* print footer if bottom */
}
/*******************************************************/
text (line)
char *line;
{
	char wrdbuf [LSZ];
	if (line[0] == BLANK || line[0]==NEWLINE || line[0] == TAB)
		leadbl (line);
	if (CEVAL > 0)
	{ 
		center(line);
		put(line);
		CEVAL--;
	}
	else if(line[0]==NEWLINE) space(_LSVAL[0]);
	else if(!_FILL[0]) put(line);
	else while (WE_HAVE_A_WORD == getwrd (line, wrdbuf))
		putwrd (wrdbuf);
}
/******************************************************
	  put out a line of text with correct indentation
	  underlining if specified
*******************************************************/
put (line)
char *line;
{
	char c;
	int fs,minfs;
	if ((VLINENO < 0)||(VLINENO >= BOTTOM)) phead();
	fs=(VLINENO-OLDLN)*FRVAL;
	minfs=OLDBOT-OUTTOP; 
	if(!(OLDBOT&&OUTTOP)) minfs++;
	while(fs<minfs) {
		fs+=FRVAL; 
		VLINENO++;
	}
	need(0);
/* now send it via extra buffer to printer */
	if( PRNTR_FRMT==0) blanks(TIVAL);	/*indent unless printer is handling it */
	for(;c=*line;line++) putout(c);
	putout('\0');
	printout();
	TIVAL = _INVAL[0];
	VLINENO += _LSVAL[0];
	if (VLINENO >= BOTTOM) pfoot();
}

/***********************************************************
concatenates the word onto the end of OUTBUF for filled text
************************************************************/

putwrd (wrdbuf)				/*Nov 22; SENTENCE for double space after major punctuation*/
char *wrdbuf;
{
	int line_len, new_out_width, wid;
	int nextra;
	skip_blanks (wrdbuf); 
	trunc_bl (wrdbuf);
	wid =1+SENTENCE+strln3(wrdbuf,TRUE,1);		/*sets WTOP,WBOT*/
	line_len = _RMVAL[0] - TIVAL;
	new_out_width = OUTW+wid;
	if (new_out_width > min (line_len, MAXLINE-1))
	{ 
		nextra = min(line_len, MAXLINE-1)-OUTW+1;
		if(OUTBUF[OUTPOS-2]==BLANK) nextra++;
		if(JUSTIFY && !PRNTR_FRMT) spread(OUTBUF,nextra,OUTWRDS);
		if(PRNTR_FRMT)
		{
			NO_CRFLG=1;	/* suppress CR/NL and leave to printer*/
		}
		brk();
		NO_CRFLG=0;
	}
	OUTW += wid;
	while(OUTBUF[OUTPOS]=*(wrdbuf++)) OUTPOS++;
	OUTBUF[OUTPOS++]=BLANK;
	if(SENTENCE) OUTBUF[OUTPOS++]=BLANK;
	OUTBUF[OUTPOS]='\0';			/* ensure last char is null */
	OUTWRDS++;
	if(WTOP<OUTTOP) OUTTOP=WTOP;
	if(WBOT>OUTBOT) OUTBOT=WBOT;
}

/**********************************************************/


gloss()				/*prints on STDOUT a glossary of .tr chars*/
{
	int i;
	char line[20],tcs;
	put("GLOSSARY:");
	put("USE     <GET>");
	tcs=_TCVAL[0];
	_TCVAL[0] |= 128;	/*set most significant bit*/
	for(i=1;i<19;i++) line[i]=' ';
	line[0]=tcs;
	line[8]='<';
	line[9]=_TCVAL[0];
	line[11]='>';
	line[12]='\0';
	for(i=' ';i<127;i++)
	{
		if(TPTR[i-' '])
		{
			line[1]=line[10]=i;
			put(line);
		}
	}
	_TCVAL[0]=tcs;
	space(HUGE);
}

