 /********************************************************/

/*							*/

/*		    ROFF4, Version 1.60 		*/

/*							*/

/*(C) 1983,4 by Ernest E. Bergmann			*/

/*		Physics, Building #16			*/

/*		Lehigh Univerisity			*/

/*		Bethlehem, Pa. 18015			*/

/*							*/

/* Permission is hereby granted for all commercial and	*/

/* non-commercial reproduction and distribution of this */

/* material provided this notice is included.		*/

/*							*/

/********************************************************/



/********************************************************/

/*							*/

/* modified by F.W.Glassborow dec 1988 for Atari ST	*/

/* and largely revised january 1989			*/

/********************************************************/



/* 9/1/89	*/

/* 10/1/89	*/

/*11/1/89	*/

/*12/1/89	*/

/*15/1/89	*/

/*16/1/89	*/

/*08/2/89	*/



#include "roff4st.h"



/*****************MAIN************MAIN*********/

/* changed by FGW to int's so that defaults can be changed without	*/

/* the need to recompile.  As the use of defaults has some significance	*/

/* this change is desirable						*/



REVSCROLL=FALSE;

FI_DEF = 1;

LS_DEF = 1;

IN_DEF = 10;

RM_DEF = 70;

TI_DEF = 0;

CE_DEF = 1;

UL_DEF = -1;

M1_DEF = 2;

M2_DEF = 2;

M3_DEF = 2;

M4_DEF = 2;

PL_DEF = 66;

FF_DEF = 1;		/* .ff defaults to "on" */

FF_INI = 1;		/* initial setting*/

SC_INI = BLANK;

OW_INI = 80;	/* initial output width*/

TS_DEF = 8; 	/* standard tabsize*/

TC_DEF = '~';	/* translation flag default*/

CF_DEF = '^';	/* Dec 4*/

IC_DEF = '\\';

CW_DEF = 12;	/* 12/120" */

JU_INI = 1;		/* right justification		*/

REGDEF = 0;		/* default for register var.	*/

			/* when .rg has no numeric arg	*/

bit8 = 0x00;		/* used to mask in bit-8 for 8-bit ASCII 12/1/89	*/

msbfilter=0x7F;	/* to allow for 8-bit ASCII, FGW 10/1/89	*/

PROP_DEF = 0;	/* not proportional printing 	*/

PAGES_DEF = 1;	/* no wait at end of page	*/

SP_DEF = 1;		/* normally 1 line of space	*/

STX_DEF = 0;

T_DEF = 0;		/* used to allow set to be used even when default

			value is computed	*/



main(argc, argv)

int argc;

char **argv;

{

	char option;

	char filename[20];

	LASTCH='\0';

	dioinit (&argc, argv);	/* directed I/O */

	fprintf(STDERR,"ROFF4, version 1.61ST, Dec 1988,\n");

	fprintf(STDERR,"	(c) 1983,4 by\n");

	fprintf(STDERR,"E. E. Bergmann, Physics,Bldg. #16\n");

	fprintf(STDERR,"Lehigh University, Bethlehem PA 18015\n\n");

	fprintf(STDERR,"Modified for 32 bit addressing etc\n	(c) 1988,9 by\n");

	fprintf(STDERR,"F.W.Glassborow\n");

	fprintf(STDERR,"Southfield Microcomputer Support Services\n");

	fprintf(STDERR,"64 Southfield Road,\n");

	fprintf(STDERR,"Oxford\n");

	fprintf(STDERR,"OX4 1PA\n");



	if (argc == 1) err_exit(8,argv);

	argv++;

	init_defaults();

	while ( --argc > 0 )

	{ 

		strcpy (filename, *argv++);

		fprintf(STDERR,"Now processing <%s>\n",filename );

		if(filename[0]=='-')

		{

			option=toupper(filename[1]);

			if(option=='M') showm();

			else if(option=='D') showd();

			else if(option=='F') putchar(FORMF);

			else if(option=='G') gloss();

			else if(option=='I') showit();

			else if(option=='R') showr();

			else if(option=='S') PAGESTOP=TRUE;

			else if(option=='O') range(&filename[2]);

			else	{

				KEYBD=option;

				dolns();

				fprintf(STDERR,"End of keyboard input <%c>\n",

				KEYBD);

				KEYBD=FALSE;

			}

			continue;

		}

		if(find2(filename,DLINK,DLINKPTR)) dclose(DLINKDATA+LINKNO);

		if (NULL == (IOBUF=fopen( filename,"r")))

		{

			fprintf(STDERR,"can't open <%s>\n",filename );

			continue;

		}

		else dolns();

		if(VLINENO>0||OUTBUF[0]) space(HUGE);

		fprintf(STDERR,"Done processing <%s>\n", filename );

		fclose(IOBUF);

	}				/* end while (--argc > 0 ) */

	dsclose();

	dioflush();

}					/* end main()	*/



/****************************************/



dolns()					/*do processing of lines*/

{

	char *pc;

	int e;

	BINP=0;

	while((e=(int) fgets2(LINE,IOBUF))||FPTR) /*until EOF*/

	{

		if(e) {

			if(LINE[0]==COMMAND)

			{

				if(pc=macq(LINE)) pbmac(pc,LINE);

				else comand(LINE);

			}

			else text(LINE);

		}

		else endso();

	}

}



/**************************************************************

initializes the global variables governing the execution of the

 format commands.

Some alterations in Jan 89 by FGW to allow for changeable

defaults

**************************************************************/



init_defaults()

{

	char *i;

/*	parameter stacks	*/



	initsk(_FILL,FI_DEF);	/* yes we want FILLed lines */

	initsk(_LSVAL,LS_DEF);	/* line spacing = 1 */

	initsk(_INVAL,IN_DEF);	/* left margin indent  0 */

	initsk(_RMVAL,RM_DEF);	/* right margin = page width  */

	initsk(_PLVAL,PL_DEF);

	initsk(_M1VAL,M1_DEF);

	initsk(_M2VAL,M2_DEF);

	initsk(_M3VAL,M3_DEF);

	initsk(_M4VAL,M4_DEF);

	initsk(_SCVAL,SC_INI);

	initsk(_OWVAL,OW_INI);

	initsk(_TABSIZ,TS_DEF);

	initsk(_TCVAL,TC_DEF);

	initsk(_CFVAL,CF_DEF);

	initsk(_ICVAL,IC_DEF);

	TIVAL = IN_DEF;		/* left margin temporary indent    0 */

	CEVAL = 0;		/* next n lines to be centered -  0  */



/*	various globals	*/



	FIRSTPAGE=1;

	LASTPAGE=30000;		/*infinite*/

	CURPAG = 0;

	NEWPAG = 1;



/*	various global flags	*/



	NO_CRFLG = 0;		/* CR at end of output line unless specified otherwise */

	PAGESTOP = PAGES_DEF;

	FFEED = FF_INI;

	PRNTR_FRMT=PROP_DEF;

	JUSTIFY=JU_INI;

	msbfilter=0x7f;		/* default to 7-bit ASCII	*/

	bit8 = 0x00;		/* used to mask in bit-7 for 8-bit ASCII 12/1/89	*/



/*	other global variables	*/



	FRQ=0;FRSTRING=WHSTRING=(char *)0;

	FRVAL=1;

	FVLINENO=FPLINENO = PLINENO = 0;

	VLINENO = -1;

	BOTTOM = _PLVAL[0] - _M3VAL[0] - _M4VAL[0];

	OUTW=OUTPOS=OUTTOP=OUTBOT=OLDLN=OLDBOT=OUTWRDS = 0;

	OUTBUF [0] = '\0';

	EH2 = EH3 = EHEAD ;

	OH2 = OH3 = OHEAD ;

	*EHEAD = *OHEAD = '\0' ;

	EF2 = EF3 = EFOOT ;

	OF2 = OF3 = OFOOT ;

	*EFOOT = *OFOOT = '\0' ;

	setmem(CPTR,( sizeof(i) * 96),0);	/* modified 08/02/89 to allow for */

	setmem(TPTR,(96 * sizeof(i)),0);	/* different pointer sizes	*/

	TREND = TRTBL;

	OUTBUF2[0]=BPOS=0;

	XCOL=-1;

	setmem(XBUF,LSZ,' ');

	XF=FALSE;

	FPTR=MLINKPTR=DLINKPTR=RLINKPTR=SLINKPTR=0;

	KPTR=KLINE;

	*KLINE=0;

	KEYBD=FALSE;

	complete();

}

/****************************************/





char *fgets2(s,iobuf)

char *s;

FILE *iobuf;

{

	int count,c,i,pnum,*pw1;

	char *cptr,*pc,*pw;

	char wbuf[LSZ],*fnd;

	count = MAXLINE;

	cptr = s;

	if ( (c=ngetc(iobuf))==EOF)

		return NULL;



	do {    

		if(c==_ICVAL[0])	/*need macro substitution*/

		{

			for(i=0;_ICVAL[0]!=(wbuf[i]=ngetc(iobuf));i++)

			{

				if(wbuf[i]=='\n')

				{

					if(i) putback('\n');

					break;

				}

			}

			if (i) {

				wbuf[i]='\0';

				if ((*wbuf==NUMSIGN) && (i==1))

				{

					if((VLINENO>=_PLVAL[0])

					||(VLINENO<0)) pnum=NEWPAG;

					else pnum=CURPAG;

					itoc(pnum,wbuf,10);

					pbstr(wbuf);

				}

				else if(find2(wbuf,RLINK,RLINKPTR))

				{

					pw1=RLINKDATA+LINKNO;	/* FGW 11/1/89	*/

					itoc(*pw1,wbuf,10);

					pbstr(wbuf);

				}

				else if(fnd=find2(wbuf,SLINK,SLINKPTR)) pbstr(fnd);

				else{

					start();

					pc=wbuf;

					pw=TREND;

					SLINK[SLINKPTR]=TREND;

					transfer(&pc,&pw,'\0');

					fprintf(STDERR,"\n%cPlease define <%s>:",BELL,wbuf);

					fflush(STDERR);

					gets(wbuf);

					pc=wbuf;

					transfer(&pc,&pw,'\0');

					TREND=(char *)pw;

					if(++SLINKPTR>255) err_exit(6,wbuf);

					if(TREND>=TRTBL+TRSIZ) err_exit(1,wbuf);

					complete();

					pbstr(wbuf);

				}

				continue;

			}

			else if(*wbuf!='\n') putback(_ICVAL[0]); 

			c=ngetc(iobuf);

		}

		if ((*cptr++ = c) == '\n') break;



	} 

	while (count--&&(c=ngetc(iobuf))!=EOF);



	*cptr = '\0';

	return(s);

}



/**************************************************************

performs the formatting command returned by comtyp -sets global

  variables ( indenting, underlining, etc. )

Changes to introduce new commands,altering of defaults and

straight stacks for parameters by FGW in Jan 89

**************************************************************/



comand ( line )

char *line;

{

	int c_type;		/* command type  */

	int arg_val;		/* argument value, if any */

	char arg_typ;		/* relative (+ or -),absolute or reset (@) */

	char wbuf[20];

	c_type = comtyp (line);

	if (c_type == UNKNOWN)

	{

		fprintf(STDERR, "UNKNOWN COMMAND: <%s>\n", line);

		return;

	}

	arg_val = get_val ( line, &arg_typ );

	switch (c_type)

	{

	case IG : 

		break;			/* ignore remark */



	case FI :			/* FILLed lines  */

		brk();

		_FILL[0] = YES;

		break;



	case NF :			/* non-FILLed lines */

		brk();

		_FILL[0] = NO;

		break;



	case NJ :			/* non-justified lines */

		JUSTIFY = NO;

		break;



	case JU :			/* justified lines  */

		JUSTIFY = YES;

		break;



	case BR :			/* just cause a break */

		brk();

		break;



	case LS :			/* set line spacing value */

		setS(_LSVAL, arg_val, arg_typ, &LS_DEF, 1, HUGE );

		break;



	case TI :			/* set temporary left indent */

		brk();

		set ( &TIVAL, arg_val, arg_typ, &TI_DEF, 0, _RMVAL[0] );

		break;



	case IN :			/* set left indent */

		setS( _INVAL, arg_val, arg_typ, &IN_DEF, 0, _RMVAL[0]-1 );

		TIVAL = _INVAL[0];

		break;



	case RM:			/* set right margin */

		setS(_RMVAL, arg_val, arg_typ, &RM_DEF, TIVAL+1, _OWVAL[0] );

		break;

	case M1:			/* set topmost margin */

		setS(_M1VAL, arg_val, arg_typ, &M1_DEF,0,HUGE);

		break;



	case M2:			/* set second top margin */

		setS(_M2VAL, arg_val, arg_typ, &M2_DEF,0,HUGE);

		break;



	case M3:			/* set first bottom margin */

		setS(_M3VAL, arg_val, arg_typ, &M3_DEF,0,HUGE);

		BOTTOM = _PLVAL[0] - _M3VAL[0] - _M4VAL[0];

		break;



	case M4:			/* set bottom-most margin */

		setS(_M4VAL, arg_val, arg_typ, &M4_DEF,0,HUGE);

		BOTTOM = _PLVAL[0] - _M3VAL[0] - _M4VAL[0];

		break;



	case CE:			/* center next arg_val lines */

		brk();

		set ( &CEVAL, arg_val, arg_typ, &CE_DEF,0, HUGE);

		break;



	case HE :			/* get header title for pages */

		gettl3 ( line, EHEAD, &EH2, &EH3 );

		gettl3 ( line, OHEAD, &OH2, &OH3 );

		break;



	case OH :			/*get odd header title*/

		gettl3 ( line, OHEAD, &OH2, &OH3 );

		break;



	case EH :			/*get even header title*/

		gettl3 ( line, EHEAD, &EH2, &EH3 );

		break;



	case FO :			/* get footer title for pages */

		gettl3 ( line, EFOOT, &EF2, &EF3 );

		gettl3 ( line, OFOOT, &OF2, &OF3 );

		break;



	case OF :			/* get odd page footer title*/

		gettl3 ( line, OFOOT, &OF2, &OF3 );

		break;



	case EF :			/* get even page footer title*/

		gettl3 ( line, EFOOT, &EF2, &EF3 );

		break;



	case SP :			/* space down arg_val blank lines */

		set (&SPVAL, arg_val, arg_typ, &SP_DEF, 0, HUGE);

		space ( SPVAL );

		break;



	case STX :			/* stop(pause) at each page?*/

		set(&PAGESTOP,arg_val,'0',STX_DEF,NO,YES);

		break;

	case BP :			/* set pageno arg_val - begin page */

		brk();

		if(((VLINENO<=0)||(VLINENO>=BOTTOM))&&(arg_val==NO_VAL)) break;

		if ( VLINENO > 0 ) space (HUGE);

		T_DEF=CURPAG+1;

		set(&CURPAG,arg_val,arg_typ,&T_DEF,0,9999);

		NEWPAG = CURPAG;

		break;

	case NE :			/*"need"*/

		if (arg_val==NO_VAL) arg_val=2;		/*default*/

		need(arg_val);

		break;



	case PL :			/* set page length */

		setS(_PLVAL, arg_val, arg_typ, &PL_DEF,

		_M1VAL[0]+_M2VAL[0]+_M3VAL[0]+_M4VAL[0]+1,HUGE);

		BOTTOM = _PLVAL[0] - _M3VAL[0] - _M4VAL[0];

		break;



	case FF :			/*formfeed*/

		set(&FFEED,arg_val,'0',&FF_DEF,NO,YES);

		break;



	case SC :			/*space character*/

		if(arg_typ) arg_val=arg_typ;

		setS(_SCVAL,arg_val,'0',&SC_INI,BLANK,127);

		break;



	case OW :			/*output device width*/

		setS(_OWVAL,arg_val,'0',&OW_INI,_RMVAL[0],HUGE);

		break;

	case TS :			/*tabsize*/

		setS(_TABSIZ,arg_val,'0',&TS_DEF,1,HUGE);

		break;



	case AB :			/*abort*/

		fprintf(STDERR,"\n***USER ABORT***\n");

		exit();



	case TC :			/*translate character flag*/

		if(arg_typ) arg_val=arg_typ;

		setS(_TCVAL,arg_val,'0', &TC_DEF,BLANK+1,127);

		break;



	case CF :			/*translate character flag*/

		if(arg_typ) arg_val=arg_typ;

		setS(_CFVAL,arg_val,'0', &CF_DEF,BLANK+1,127);

		break;



	case IC :			/*insert character for macro replace*/

		if(arg_typ) arg_val=arg_typ;

		setS(_ICVAL,arg_val,'0', &IC_DEF,BLANK+1,127);

		break;



	case TR :			/*translation string defined here*/

		gettr(); 

		break;



	case OU :			/*output code string*/

		ocode(); 

		break;



	case FR :			/*define fractional spacing code*/

		getfr(); 

		break;



	case WH :			/*define whole line spacing code*/

		getwh(); 

		break;



	case DS :			/*define string*/

		insert(); 

		break;



	case DM :			/*define macro*/

		minsert(); 

		break;



	case RG :			/*register variable*/

		dovar(); 

		break;



	case DI :			/*diversion to file*/

		dodiv(); 

		break;



	case SO :			/*source from file*/

		source(); 

		break;



	case PC :			/*printer control*/

		getpc(); 

		break;



	case SA :			/*"say" to console*/

		getwrd(LINE,wbuf);	/*skip command*/

		skip_blanks(LINE);

		trunc_bl(LINE);

		fprintf(STDERR,"<%s>\n",LINE);

		break;



	case BJ :			/*break with right justification*/

		if(_FILL[0])		/*not applicable otherwise*/

		{

			spread(OUTBUF,min(_RMVAL[0]-TIVAL,MAXLINE-1)-OUTW+1,OUTWRDS);

			brk();

		}

		break;

	case PF	:			/* set for printer formatting for proportional spacing */

		PRNTR_FRMT=TRUE;

		break;

	case RF	:			/* equal letter spacing */

		PRNTR_FRMT=FALSE;

		break;

	case AL :			/* double height letters so count an extra line */

		if(!arg_val) arg_val=1; /* default to 1	*/

		if (arg_typ=='-') PLINENO -= arg_val;	/* modified 16/1/89 */

		else PLINENO += arg_val;	/* altered 15/1/89 to allow other line count adjustments	*/

		break;

	case AS :			/* set for 8 or 7-bit ASCII	*/

		if (arg_val==8) msbfilter=0xff;

		else msbfilter=0x7f;

		break;

	

	}

}



start()					/*to insure only one entry into TRTBL at a time*/

{

	if(TFLAG) err_exit(9,&TFLAG);

	else TFLAG=TRUE;

}



complete()				/*to insure only one entry into TRTBL at a time*/

{

	TFLAG=FALSE;

}



range(s)

char *s;

{

	int num;

	num=0;

	while(isdigit(*s)) num=num*10+(*(s++)-'0');

	if(num) FIRSTPAGE=num;

	if(*s=='-')

	{

		s++; 

		num=0;

		while(isdigit(*s)) num=num*10+(*(s++)-'0');

		if(num) LASTPAGE=num;

	}

	else	LASTPAGE=FIRSTPAGE;

}

