/********************************************************/

/*							*/

/*		    ROFF4, Version 1.60 		*/

/*							*/

/*(C) 1983,4 by Ernest E. Bergmann			*/

/*		Physics, Building #16			*/

/*		Lehigh Univerisity			*/

/*		Bethlehem, Pa. 18015			*/

/*							*/

/* Permission is hereby granted for all commercial and	*/

/* non-commercial reproduction and distribution of this */

/* material provided this notice is included.		*/

/*							*/

/********************************************************/



/********************************************************/

/*							*/

/* modified by F.W.Glassborow dec 1988 for Atari ST	*/

/* and largely revised january 1989			*/

/********************************************************/



/* 9/1/89	*/

/*10/1/89	*/

/*11/1/89	*/

/*12/1/89	*/



#include "roff4st.h"



/* underline and block now assumed handled by printer direct	*/

/* strike through still internally programmed			*/



/*	assuming REVSCROLL is FALSE*/

/*	output OUTBUF2 with the vertical height of the mainline

	specified by VLINENO,FVLINENO[they must not be changed here].

	Excessive superscripting will be pushed down.*/



printout()

{

	int level,top,bot;			/*"up" is negative;units fractional*/

	int lsave,fsave;

	OUTBUF2[BPOS]='\0';

	fsave=FVLINENO;

	lsave=VLINENO;

	level=FRVAL*(PLINENO-VLINENO)+FPLINENO-FVLINENO;

	if(!OLDBOT) level++;

	excurs(&OUTBUF2[0],&top,&bot);

	if(top>level) level=top;

	if(!REVSCROLL) FVLINENO += level;

	padv();

	for(;level<=bot;level++)

		{flp(level);

		if(level<bot){

			fraction();

			putchar('\r');

			putchar('\n');

			FPLINENO++;

		}

	}

	XF=NEWXF;

	OUTBUF2[0]=BPOS=0;

	OLDLN=VLINENO=lsave;

	OLDBOT=bot;

	FVLINENO=fsave;

}



/****************************************/

/*moves printer vertically so that its position is specified by VLINENO,FVLINENO*/



padv()

{

	int w,f,psave;				/*whole,fractional lines*/

	psave=NO_CRFLG;

	NO_CRFLG=0;

	w=VLINENO-PLINENO;

	f=FVLINENO-FPLINENO;

	while(f<0) {

		w--; 

		f += FRVAL; 

	}

	while(f>=FRVAL) {

		w++; 

		f -= FRVAL; 

	}

	if(w<0){

		fprintf(STDERR,"padv():VL=%d,PL=%d\n",VLINENO,PLINENO);

		if(REVSCROLL) backup(w*FRVAL+f);

		else {

			VLINENO +=w;

			FVLINENO +=f;

			while(FVLINENO<0){

				VLINENO++;

				FVLINENO+=FRVAL;

			}

			while(FVLINENO<FRVAL){

				VLINENO--;

				FVLINENO-=FRVAL;

			}

			return;

		}

	}

	if(FRQ) {

		while(f--){

			putchar('\r');

			putchar('\n'); 

			FPLINENO++; 

		}

		if(w){

			whole();

			while(w--){

				putchar('\r');

				putchar('\n');

				PLINENO++;

			}

		}

	}

	else	{

		while(w--){

			putchar('\r');

			putchar('\n'); 

			PLINENO++; 

		}

		if(f){

			fraction();

			while(f--){

				putchar('\r');

				putchar('\n');

				FPLINENO++;

			}

		}

	}

	while(FPLINENO>=FRVAL) {

		PLINENO++; 

		FPLINENO -= FRVAL; 

	}

	NO_CRFLG=psave;

}



/****************************************/



backup(i)			/* not yet implemented and probably won't be*/

int i;				/* # of fractional lines(probably negative)*/

{

	fprintf(STDERR,"\nCan't back up %d lines yet\n",i);

}



/**************************************************/



excurs(str,t,b)			/* finds the topmost and bottommost line

				positions of str*/

char *str;

int *t,*b;

{

	int l;

	char c;

	*t=*b=l=0;			/*current line position */

	c=*str;

	while(c){

		if(c==_CFVAL[0]){

			if(c=*(++str))

				switch(c)

				{

				case '+':

					l--; 

					if(l<*t) *t=l;

					c=*(++str); 

					break;

				case '-':

					l++; 

					if(l>*b) *b=l;

					c=*(++str); 

					break;

				default : 

					c=*(++str); 

					break;

				}

		}

		else c=*(++str);

	}

}



/**************************************************/

				/* fancy line print at a given vertical level	*/

flp(level)			/* the string in OUTBUF2[] with strikout.	*/

int level;			/* current vertical level to print*/

{

	int i,chcnt;

	BLKCNT=lbc(level,OUTBUF2);

	if(NO_CRFLG)

		chcnt= cnt_chars();

		else chcnt=LSZ;

	FIRST=TRUE;

		while(BLKCNT>0) 

	{

			prpass(level,chcnt); 

			putchar('\r');

			FIRST=FALSE;

	}

	if(XCOL>-1){

		for(i=0;i<=XCOL;i++)

			putchar(XBUF[i]);

		putchar('\r');

	}

	if(XCOL>-1) {XCOL = -1; setmem(XBUF,LSZ,' ');}

}



/**************************************************/



lbc(lev,str)		/*counts printable chars in line level and

				above; parity must be reset*/

int lev;			/*=0 main line,=-1 superscripts,=+1 subscripts, etc.*/

char *str;

{

	char c;

	int l,n;

	l=n=0;

	c=*str;

	while(c){

		if(c==_CFVAL[0]){

			if(c=*(++str))

				switch(c)

				{

				case '+':

					l--;

					c=*(++str);

					break;

				case '-':

					l++;

					c=*(++str);

					break;

				default: 

					c=*(++str);

					break;

				}   

		}

		else	{

			if((c>' ')&&(l<=lev)) if(c!=_TCVAL[0]) n++;

			c=*(++str);

		}

	}

	return(n);

}



/**************************************************/

			/* printer pass initial cr; no lf anywhere*/

prpass(lev,chcnt)

int lev,chcnt;		/*=0 main line,=-1 superscripts,=+1 subscripts, etc.*/

{

	char ch;

	int xfs;	/*save variables*/

	int l,p1,p2,p3;	/*position holders*/

	int cp2;	/*for tabulation calculation*/

	xfs=XF;

	p1=p2=p3=l=BPOS=CP=PP=0;

	while((ch=OUTBUF2[BPOS]) && ( chcnt--))

	{

		switch (class(ch))

		{

		case   BLACK:			/*print it if posssible*/

			if((PP>CP)||(l>lev)){

				CP++;

				BPOS++;

				break;

			}

			else	{

				while(CP>PP){

					putchar(' ');

					PP++;

				}

				if(ch==_SCVAL[0])putchar(' ');

				else putchar(ch);

				PP++;

				OUTBUF2[BPOS++]=' ';

				if(XF&&FIRST)XBUF[XCOL=CP]=XCHAR;

				BLKCNT--; 

				CP++;

			} 

			break;

		case	WHITE:			/*assume blank*/

			CP++;

			BPOS++;

			break;

		case	TRANSLATE:		/*similar to BLACK and WHITE*/

			ch=OUTBUF2[++BPOS];

			if((PP>CP)||(l>lev)||(ch==' '))

			{

				CP++;

				BPOS++;

				break;

			}

			else

			   {

				while(CP>PP){

					putchar(' ');

					PP++;

				}

				trch(ch);

				PP++;

				OUTBUF2[BPOS++]=' ';

				if(XF&&FIRST)XBUF[XCOL=CP]=XCHAR;

				BLKCNT--; 

				CP++;

			} 

			break;

		case	CONTROL:			/*decode on following letter*/

			ch=OUTBUF2[++BPOS];

			if(CPTR[ch-' ']) {

				while (CP>PP) {		/* 2 Mar,85	  */

					putchar(' ');	/* update PP before */

					PP++;		/* printing printer */

				}			/* control string   */

				pcont(ch);

			}

			else switch(ch & 0x7F)		/* mask out msbit, 12/1/89	*/

			{

			case 'h':

			case 'H':			/*backspace*/

				if(CP)CP--;

				break;

			case '+': 

				l--; 

				break;

			case '-': 

				l++; 

				break;

			case 'X': 

				XF=TRUE;

				break;

			case 'x': 

				XF=FALSE;

				break;

			case '8':

				bit8=0x80;		/* 12/1/89 for masking */

				break;

			case '7':

				bit8=0x00;

				break;			/* and switch it off 12/1/89	*/

			case '(': 

				p1=CP;

				break;

			case ')': 

				CP=p1;

				break;

			case '[': 

				p2=CP;

				break;

			case ']': 

				CP=p2;

				break;

			case '{': 

				p3=CP;

				break;

			case '}': 

				CP=p3;

				break;

			default:/*?,ignore*/

				;

				break;

			} 

			BPOS++; 

			break;

		case	SENTINEL: 

			OUTBUF2[BPOS]='\0';

			break;

		case	HTAB: 

			for(cp2=0;CP>=0;cp2+=_TABSIZ[0])CP-=_TABSIZ[0];

			CP=cp2; 

			BPOS++; 

			break;

		case	OTHERS:

			fprintf(STDERR,"\nweird character value[octal]: %o\n",ch);

			BPOS++;

			break;

		}

	}

	NEWXF=XF;

	XF=xfs;

}





/**************************************************/

int class(c)

char c;

{

	if(c==_TCVAL[0]) return(TRANSLATE);

	if (c==_CFVAL[0]) return(CONTROL);

	if(c>' ') return(BLACK);

	if(c==' ') return(WHITE);

	if(c=='\n') return(SENTINEL);

	if(c=='\r') return(SENTINEL);

	if(c==TAB) return(HTAB);

	if(!c) return(SENTINEL);

	return(OTHERS);

}



/**************************************************/



fraction()				/*put printer in fractional spacing mode;

				set FRQ*/

{

	if(!FRQ && FRSTRING && (FRVAL!=1))

	{

		outstr(FRSTRING);

		FRQ = TRUE;

	}

}



/**************************************************/



whole()	  				/*put printer in whole line spacing;

				reset FRQ */

{

	if(FRQ && WHSTRING)

	{

		outstr(WHSTRING);

		FRQ = FALSE;

	}

}



/**************************************************/



trch(c)					/*output string translation of c*/

char c;

{

	char *p;

	if(c<' ') {

		putchar(_TCVAL[0]);

		putchar(c);

		return;

	}

	p = TPTR[c-' '];

	if(p) outstr(p);

	else	{/*not initialized*/

		putchar(_TCVAL[0]);

		putchar('?');

	}

}



/****************************************/



pcont(c)				 /*output printer control string for c*/

char c;

{

	char *p;

	if(c<' ') {

		putchar(_CFVAL[0]);

		putchar(c);

		return;

	}

	p = CPTR[c-' '];

	if(p) outstr(p);

	else	{			/*not initialized*/

		putchar(_CFVAL[0]);

		putchar('?');

	}

}



cnt_chars(){

	int x;

	for(x=LSZ-2;x;x--){

		if (OUTBUF2[x]>' '){

			OUTBUF2[x+1]=' ';

			return(x+1);

		}

	}

	return(1);

}

