/********************************************************/

/*							*/

/*		    ROFF4, Version 1.60 		*/

/*							*/

/*(C) 1983,4 by Ernest E. Bergmann			*/

/*		Physics, Building #16			*/

/*		Lehigh Univerisity			*/

/*		Bethlehem, Pa. 18015			*/

/*							*/

/* Permission is hereby granted for all commercial and	*/

/* non-commercial reproduction and distribution of this */

/* material provided this notice is included.		*/

/*							*/

/* Modified for Atari ST by F.W.Glassborow dec 1988	*/

/********************************************************/



/********************************************************/

/*							*/

/* modified by F.W.Glassborow dec 1988 for Atari ST	*/

/* and largely revised january 1989 for easy conversion	*/

/********************************************************/



/*10/1/89	*/

/*11/1/89	*/

/*12/1/89	*/



#include "roff4st.h"



/****************************************/

int *regist(s)	/*checks RLIST; creates new entry if needed;

		  returns pointer to integer variable*/

		  /* largely modified 11/1/89 for new structure with reg values

		  in their own array FGW */

char *s;

{

	char *s2;

	if(find2(s,RLINK,RLINKPTR)) return(RLINKDATA+LINKNO);

 /*else create new entry*/

	start();		/* start a new entry to TRTBL	*/

	if(RLINKPTR>255) err_exit(13,s);

	RLINK[RLINKPTR]=TREND;

	s2=s;

	transfer(&s2,&TREND,'\0');

	if(TREND>= (TRTBL+TRSIZ)) err_exit(1,s);

	RLINKDATA[RLINKPTR]=REGDEF;

	complete();

	return(RLINKDATA+RLINKPTR++);

}



/****************************************/



dovar()				/* process .RG request*/

{

	char typ, wbuf[MAXLINE];

	int val, *pw;

	getwrd(LINE,wbuf);

	skip_blanks(LINE);

	val=get_val(LINE,&typ);

	getwrd(LINE,wbuf);

	if(wbuf[0]==NUMSIGN && wbuf[1]=='\0')	/* deal with special page number register */

	{

		set(&NEWPAG,val,typ,&NEWPAG,1,9999);

	}

	else	{

		pw=(int *) regist(wbuf);

		set(pw,val,typ,&REGDEF,0,9999);

	}

}

/****************************************/

dodiv()				/*process .DIversion*/

{

	char wbuf[MAXLINE],*pc,*wb;

	struct divfd *pd;

	getwrd(LINE,wbuf);

	if(getwrd(LINE,wbuf)!=WE_HAVE_A_WORD)

	{

		strcpy(wbuf,"JUNK.$$$");

		fprintf(STDERR,"DIVERSION has no name, %s assumed\n",

		wbuf);

	}

	ucstr(wbuf);

	if(find2(wbuf,DLINK,DLINKPTR))		/* if name in table*/

	{

		pd=DLINKDATA+LINKNO;		/* position in diversion file table */

		if(!(pd->bf)){			/*if not open*/

			fprintf(STDERR,"%c <%s> ",BELL,wbuf);

			if((pd->bf=fopen(wbuf,"w"))!=NULL)

				fprintf(STDERR,"rewritten for .DI\n");

			else err_exit(10,wbuf);

		}

	}

	else							/*not in table*/

	{

		start();			/* so start entry	*/

		DLINK[DLINKPTR]=TREND;

		pc=(char *)TREND;

		wb=wbuf;

		transfer(&wb,&TREND,0);

		if(TREND>= (TRTBL+TRSIZ)) err_exit(1,wbuf);

		if(++DLINKPTR>DMAXFILES) err_exit(14,wbuf);

		complete();			/* name now in and count updated	*/

		pd=DLINKDATA+DLINKPTR-1;

		pd->nm = pc;

		pd->ls = pd->cs = 0;

		if((pd->bf=fopen(wbuf,"w"))==NULL) err_exit(11,wbuf);

	}

	while(fgets2(LINE,IOBUF))

	{

		if((*LINE==COMMAND)&&(comtyp(LINE)==ED)) break;

		if(pc=(char *) macq(LINE))

		{

			pbmac(pc,LINE);

			continue;

		}

							/*else*/

		fputs(LINE,pd->bf);

		(pd->ls)++;

		(pd->cs) += 1+strlen(LINE);		/*crlf=2*/

	}

}



/****************************************/



source()

{

	char name[MAXLINE];

	getwrd(LINE,name);

	if(getwrd(LINE,name)!=WE_HAVE_A_WORD)

	{

		fprintf(STDERR,".SO has no name\n");

		return;

	}

	ucstr(name);

	if(find2(name,DLINK,DLINKPTR)) dclose(DLINKDATA+LINKNO);

	if(FPTR<FMAX) FSTACK[FPTR++]=IOBUF;

	else err_exit(12,name);

	if((IOBUF=fopen(name,"r"))!=NULL) return;

	/*else*/

	fprintf(STDERR,"Can't open <%s>\n",name);

		if(FPTR) IOBUF=FSTACK[--FPTR];

	BINP=0;

}



/****************************************/



showr()				/*lists register names and contents*/

{

	int i;

	fprintf(STDERR,"REGISTERS and <values>:\n");

	i=RLINKPTR;

	while(i--) fprintf(STDERR,"%s    <%d>\n",(char *)RLINK[i],RLINKDATA[i]);

	dashes();

}



/****************************************/



showd()				/*shows all diversions and status*/

{

	char *pc;

	struct divfd *pd;

	int i ;

	fprintf(STDERR, "Diversion files:\n");

	i=DLINKPTR;

	while(i--)

	{

		pc=(char *)(DLINK[i]);

		fprintf(STDERR,"%s: ",pc);

		pd=DLINKDATA+i;

		fprintf(STDERR,"%d characters, %d lines [",pd->cs, pd->ls );

		if(pd->bf) fprintf(STDERR,"open]\n");

		else	fprintf(STDERR,"closed]\n");

	}

	dashes();

}



/****************************************/



dsclose()			/*flushes and closes all open diversions*/

{

	struct divfd *pd;

	int i;

	i=DLINKPTR;

	while(i--)

	{

		pd=DLINKDATA+i;

		if(pd->bf) dclose(pd);

	}

}



/****************************************/



dclose(pd)				/*flushes and closes diversion*/

struct divfd *pd;

{

	if(pd&&(!(pd->bf))) return(FALSE);

	fprintf(STDERR,"closing %s ",pd->nm);

	putc(0x1a,pd->bf);

	fflush(pd->bf);

	if(fclose(pd->bf)==ERROR)

		fprintf(STDERR,"****bad close****\n");

	else	{

		fprintf(STDERR,"[O.K.]\n");

		pd->bf = FALSE;

	}

	return(TRUE);

}



/****************************************/



ucstr(s)				/*convert s to upper case*/

char *s;

{

	while(*s)

	{

		*s = toupper(*s);

		s++;

	}

}



/****************************************/



endso()				/*called upon EOF to return to previous input file*/



{

	if(FPTR)

	{

		fclose(IOBUF);

		IOBUF=FSTACK[--FPTR];

	}

	BINP=0;

}



/****************************************/



dashes()

{

	fprintf(STDERR,"-----------\n");

}

