/********************************************************/

/*							*/

/*			   ROFF4, Version 1.60		*/

/*							*/

/*(C) 1983,4 by Ernest E. Bergmann			*/

/*		    Physics, Building #16		*/

/*		    Lehigh Univerisity			*/

/*		    Bethlehem, Pa. 18015		*/

/*							*/

/* Permission is hereby granted for all commercial and	*/

/* non-commercial reproduction and distribution of this */

/* material provided this notice is included.		*/

/*							*/

/********************************************************/



/********************************************************/

/*							*/

/* modified by F.W.Glassborow dec 1988 for Atari ST	*/

/* and largely revised january 1989 for easy conversion	*/

/********************************************************/



/* 9/1/89	*/

/*10/1/89	*/

/*11/1/89	*/

/*12/1/89	*/

/*13/1/89	*/



#include "roff4st.h"



insert()	/*	takes a command line in LINE and adds its entry to

			the table; no space check is made of TRTBL*/

		/*	space check introduced by FGW 9/1/89	*/

{

	char *pc,*s2,*s3,*fnd;

	if(SLINKPTR>255) err_exit(6,LINE);

	SLINK[SLINKPTR]=TREND;

	pc=(char *)TREND;

	gettl3(LINE,pc,&s2,&s3);

	if(fnd=find2(pc,SLINK,SLINKPTR))

	{

		fprintf(STDERR,"%cWarning: <%s> was defined to be <%s>\n", BELL,pc,fnd);

		fprintf(STDERR,"...now it is defined to be <%s>\n",s2);

	}

	SLINKPTR++;

	TREND=(char *) s3;

	if(TREND >= TRTBL + TRSIZ ) err_exit(1,pc);

}



/****************************************/



showit()			/* displays the list of entries in the string

				   substitution table pointed to by SLINK[]. */

{

	char *pc;

	int x;

	fprintf(STDERR,"ENTRIES in substitution table:\n");

	x=SLINKPTR;

	while(x--)

	{

		pc=(char *)SLINK[x];

		fprintf(STDERR,"%U: <%s>",SLINK[x],pc);

		pc += strlen(pc); 

		pc++;

		if(*pc) fprintf(STDERR," <%s>\n",pc);

		else fprintf(STDERR," <>\n");	

	}

	dashes();

}



/****************************************/



putback(c)	/*cf K & P, p256*/

char c;

{

	if(++BINP >= LSZ) err_exit(7,&c) ;

	BACKBUF[BINP]=c;

}



/****************************************/

kgetc()		/*like getc(),from keyboard, line-buffered*/

{

	int i;

	if(!*KPTR)

	{

		fprintf(STDERR,"%c",KEYBD);

		fflush(STDERR);

		if (gets(KLINE)==NULL) return(EOF);

		i=strlen(KLINE);

		KLINE[i++]='\n';

		KLINE[i]='\0';

		KPTR=KLINE;

	}

	return((int)*(KPTR++));

}



/****************************************/



int ngetc(iobuf)	/* cf K & P p256*/

FILE *iobuf;		/* filters \r followed by \n,msb*/

			/* optional use of msb introduced by FGW 10/1/89	*/

{

	int c;

	if(BINP) c=BACKBUF[BINP];

	else	{

		if(KEYBD) c=kgetc();

		else

			if ((c=getc(iobuf))!=EOF) c =c & msbfilter;

		BACKBUF[BINP=1]=c;

	}

	if((c!=EOF)) BINP--;

	if(c=='\r')

	{

		c=ngetc(iobuf);

		if(c!='\n')

		{

			putback(c);

			return('\r');

		}

	}

	return(c);

}



/********************************************/

/** add by Conrad Kwok. 9th Sept.,84 ****/

/* implements parameters with macros	*/



pbmac(s,sl)

char s[],sl[];

{ 

	char *parms[10],dupln[LSZ];

	int i;

	strcpy(dupln,sl);

	setparm(dupln,parms);

	for (i=strlen(s)-1;i>=0;)

		if (isdigit(s[i]))

			if (i>0 && s[i-1]=='$')

			{ 

				pbstr(parms[s[i--] & 0x0f]); 

				--i;

			}

			else

				putback(s[i--]);     

		else

			putback(s[i--]);

}



setparm(sl,parms)

char *sl,*parms[];

{ 

	char a,c;

	int nuparm;

	for (c=*sl;c!=' ' && c!='\n' && c!='\t';)c=*++sl;

	while (c==' ' || c=='\t')

		c=*++sl;

	for (nuparm=0;nuparm<10;) {

		if (!(isalnum(c) || (c=='+') || (c=='-')))

			sl++;

		else

			c=' ';

		parms[nuparm++]=sl;

		for (a=*sl;a!=c && a!='\n' && a!='\0';)

			if (c==' ' && a=='\t') break;

		else a=*++sl;

		*sl='\0';

		c=a;

		if (a!='\0' && a!='\n') while (c==' ' || c=='\t') c=*++sl;

	}

}



/****************************************/



pbstr(s)			/*put back string on input;cf K&P,p257*/

char s[LSZ];

{

	int i;

	for(i=strlen(s);i>0;) putback(s[--i]);

}



/****************************************/



minsert()	/*	takes a .DM and following lines and places

			the information in the table;  no macro

			definition nesting permitted*/

{

	char c, *pc;

	unsigned long *pw1;

	start();

			/*pass over command and following white space*/

	for(pc=LINE,c=*pc; (c!=' ')&&(c!='\n')&&(c!='\t'); pc++) c=*pc;

	for(; (c==' ')||(c=='\t'); pc++) c=*pc;

	if(c=='\n') fprintf(STDERR,".DM is UNnamed\n");

	else	{

		if(MLINKPTR>255) err_exit(5,LINE);

		MLINK[MLINKPTR]=TREND;

		MLINKPTR++;

		while(class(c)==BLACK)

		{

			*(TREND++)=c;

			c=*(pc++);

		}

	}

	*(TREND++)='\0';

	while(fgets2(LINE,IOBUF))	/*until EOF*/

	{

		pw1=(unsigned long *)LINE;

		if((*LINE==COMMAND)&&(comtyp(LINE)==EM)) break;

		else	{

			transfer(&pw1,&TREND,'\0');

			*(TREND-1)='\n';

		}

	}

	*(TREND++)='\0';

	if(TREND>=TRTBL+TRSIZ) err_exit(1,LINE);

	complete();

}



/****************************************/



showm() 		/*lists macro definitions*/

{

	int x;

	char *pc;

	x=MLINKPTR;

	fprintf(STDERR,"The following macros have been defined:\n");

	while(x--)

	{

		pc =(char *)MLINK[x];

		fprintf(STDERR,"Macro name: %s\n",pc);

		pc +=strlen(pc); 

		pc++;

		fprintf(STDERR,"%s\n",pc);

	}

	dashes();

}



/****************************************/



char *macq(line)	/*	looks up name to see if it is a macro definition.

				If it is, returns the corresponding string, else

				returns FALSE.	*/

char *line;

{

	char c,*pc,wb[LSZ];

	pc=wb;

	while(class(c=*(++line))==BLACK) *(pc++)=c;

	*pc='\0';

	return(find2(wb,MLINK,MLINKPTR));

}



/****************************************/



char *find2(s,link,cnt)		/*	finds or doesn't find s in table

					of substitutions pointed to by link */

/* altered 11/1/89 to place the number of an identified item in LINKNO

so that the new structure for diversion file storage can be used effectively

with minimal alterations	*/



char *s,*link[];

int cnt;

{

	char *pc;

	if(!cnt) return((char *)0);

	LINKNO=-1;

	while(cnt--)

	{

		if(!strcmp(s,link[cnt]))

		{

			pc=(char *) (link[cnt]);

			pc += strlen(pc);

			pc++;

			LINKNO=cnt;

			return(pc);

		}

	}

	return((char *)0);

}



/****************************************/



#define VERBOSE 2	/* bit setting to indicate output is to

			go to console AND directed output */

#define DIRECTED_OUT 1

#define PRINT 4

#define SERIAL 8



/* 

	The "dioinit" function must be called at the beginning of the

	"main" function:

*/



dioflush()

{

	if (_doflag & DIRECTED_OUT)

	{

		putc(0x1a,_dobuf);

		fflush(_dobuf);

		fclose(_dobuf);

	}

}



/*

	This version of "putchar" replaces the regular version when using

	directed I/O:

*/



putchar(c)

char c;

{	

	int pause;

	c=c|bit8;		/* 12/1/89, FGW set msbit if in ^8 section of text */

/* the following allows temporary halting of output on ALL machines.

   introduced by FGW 13/1/89	*/

	while( CONSTAT) {

		pause =(CONIN & 255);

		if (pause==3) exit();

		if (pause==19)CONIN;

	}

	if (SUPPRESS) return;

	if (NO_CRFLG && (c=='\r')) return;

	if (NO_CRFLG && (c=='\n')){

		if( LASTCH==' ') return;

		else c=' ';}

/*	if (LASTCH!=='\r' || c!=='\r')*/ {

		if (_doflag & DIRECTED_OUT)

		{

			if(putc(c,_dobuf) == ERROR) err_exit(2,&c);

		}

		if (_doflag==0 || _doflag & VERBOSE)

		{

			while(COSTAT==0);

			if (c == '\n') CONOUT('\r');

			CONOUT(c);

		}



		if (_doflag & PRINT)

		{

			PRINTOUT(c);

		}

		if (_doflag & SERIAL)

		{

			SERIALOUT(c);

		}

		LASTCH=c;    /* 5th Mar,85   KKP */

	}

}



/****************************************/



dioinit(argcp,argv)

int *argcp;

char **argv;

{

	char sav_out_file[20];

	int i, argcount;

	int n;					/* this keeps track of location in argument */



	_doflag = FALSE;			/* No directed /O by default   */

	argcount = 1;

	for (i = 1; i < *argcp; i++)		/* Scan the command line for > and )*/

	{

		n=0;				/* start with first character */

getmore:	

		switch(argv[i][n++]) {



		case '+': 

			_doflag |= VERBOSE;	/* console and ? */

			goto getmore;

		case ')':

			_doflag |= PRINT;	/* printer	*/

			goto getmore;



		case ']':			/* option for serial port */

			_doflag |= SERIAL;	/* printer or other device*/

			goto getmore;



		case '&':			/*Check for directed output*/

			if (!argv[i][n]) err_exit(3,argv) ;

			strcpy (sav_out_file, &argv[i][n] );

			if ((_dobuf=fopen(sav_out_file, "w")) == NULL) err_exit(4,sav_out_file);

			_doflag++;



movargv:   

			*argcp = argcount;

			argv[*argcp] = 0;

			break;



		default :			/* handle normal arguments: */

			if (n!=1) goto movargv;

			argcount++;

		}

	}

}

