/********************************************************/

/*							*/

/*		    ROFF4, Version 1.60 		*/

/*							*/

/*(C) 1983,4 by Ernest E. Bergmann			*/

/*		Physics, Building #16			*/

/*		Lehigh Univerisity			*/

/*		Bethlehem, Pa. 18015			*/

/*							*/

/* Permission is hereby granted for all commercial and	*/

/* non-commercial reproduction and distribution of this */

/* material provided this notice is included.		*/

/*							*/

/********************************************************/



/********************************************************/

/*							*/

/* modified by F.W.Glassborow dec 1988 for Atari ST	*/

/* and largely revised january 1989			*/

/********************************************************/



/*10/1/89	*/

/*11/1/89	*/



#include "roff4st.h"



/**********************************************************

Removes white-space characters at start of string.

***********************************************************/



skip_blanks ( string )

char *string;				/* cursor to original string */

{

	char *p;			/* cursor to 'final' string */

	p=string;

	while(*string==BLANK||*string==TAB||*string==NEWLINE) string++;

	while(*(p++) = *(string++));

}



/*************************************************************/



int comtyp (line)

char *line;

{

	char let1, let2;

	let1 = toupper( line[1] );

	let2 = toupper( line[2] );



	if ( let1==COMMAND )		return( IG );

	if ( let1=='I' && let2=='G')	return( IG );

	if ( let1=='F' && let2=='I')	return( FI );

	if ( let1=='F' && let2=='O')	return( FO );

	if ( let1=='T' && let2=='I')	return( TI );

	if ( let1=='B' && let2=='P')	return( BP );

	if ( let1=='B' && let2=='R')	return( BR );

	if ( let1=='C' && let2=='E')	return( CE );

	if ( let1=='H' && let2=='E')	return( HE );

	if ( let1=='I' && let2=='N')	return( IN );

	if ( let1=='L' && let2=='S')	return( LS );

	if ( let1=='N' && let2=='F')	return( NF );

	if ( let1=='P' && let2=='L')	return( PL );

	if ( let1=='R' && let2=='M')	return( RM );

	if ( let1=='S' && let2=='P')	return( SP );

	if ( let1=='S' && let2=='T')	return( STX );

	if ( let1=='N' && let2=='E')	return( NE );

	if ( let1=='F' && let2=='F')	return( FF );

	if ( let1=='S' && let2=='C')	return( SC );

	if ( let1=='O' && let2=='W')	return( OW );

	if ( let1=='T' && let2=='S')	return( TS );

	if ( let1=='O' && let2=='H')	return( OH );

	if ( let1=='O' && let2=='F')	return( OF );

	if ( let1=='E' && let2=='H')	return( EH );

	if ( let1=='E' && let2=='F')	return( EF );

	if ( let1=='A' && let2=='B')	return( AB );

	if ( let1=='T' && let2=='C')	return( TC );

	if ( let1=='T' && let2=='R')	return( TR );

	if ( let1=='C' && let2=='F')	return( CF );

	if ( let1=='I' && let2=='C')	return( IC );

	if ( let1=='O' && let2=='U')	return( OU );

	if ( let1=='J' && let2=='U')	return( JU );

	if ( let1=='N' && let2=='J')	return( NJ );

	if ( let1=='F' && let2=='R')	return( FR );

	if ( let1=='W' && let2=='H')	return( WH );

	if ( let1=='E' && let2=='M')	return( EM );

	if ( let1=='D' && let2=='M')	return( DM );

	if ( let1=='D' && let2=='S')	return( DS );

	if ( let1=='R' && let2=='G')	return( RG );

	if ( let1=='D' && let2=='I')	return( DI );

	if ( let1=='E' && let2=='D')	return( ED );

	if ( let1=='S' && let2=='O')	return( SO );

	if ( let1=='P' && let2=='C')	return( PC );

	if ( let1=='S' && let2=='A')	return( SA );

	if ( let1=='B' && let2=='J')	return( BJ );

/* FGW's new commands	*/

	if ( let1=='P' && let2=='F')	return( PF );

	if ( let1=='R' && let2=='F')	return( RF );

	if ( let1=='A' && let2=='L')	return( AL );

	if ( let1=='A' && let2=='S')	return( AS );



	if ( let1=='M')

	{ 

		if (let2=='1')		return( M1 );

		if (let2=='2')		return( M2 );

		if (let2=='3')		return( M3 );

		if (let2=='4')		return( M4 );

	}

	return( UNKNOWN );		/* no match */

}



/*************************************************************

gets the number ( if any ) associated with any command 

Altered by FGW to include reset of default value.

*************************************************************/



int get_val ( line, typ )

char *line, *typ;

{

	int i;

	char local[ MAXLINE ];

	strcpy (local, line);		/* local copy */

					/* skip over the command line */

	for(i=1; local[i]!=' '&&local[i]!='\t'&&local[i]!='\n' ;i++);

	skip_blanks (&local[i]);	/* find the number */

	*typ = local[i];		/* relative, absolute or reset */

	if ( *typ=='+' || *typ=='-' || *typ=='@' ) i++;

	else if ( !isdigit( *typ ) ) return( NO_VAL );

	return ( atoi( &local[i] ));

}



/*************************************************************

 sets a global parameter like SPVAL, PAGESTOP, etc.

 Also checks that the new value is within the range of that 

 parameter.  Assigns the default for that parameter if no value

  is specified. It can also be used to reset a default value (9/1/89)

*************************************************************/



set ( param, val, arg_typ, defval, minval, maxval )

int *param, val, *defval, minval, maxval;

char arg_typ;

{

	if(val==NO_VAL) *param = *defval;	/* defaulted */

	else if(arg_typ == '+') *param += val;	/* relative + */

	else if(arg_typ == '-') *param -= val;	/* relative - */

	else{

		*param = val;		/* set absolute	*/

		if(arg_typ == '@') *defval = min(max(minval,val),maxval);

	/* and reset default if signalled	*/

	}

	*param = min(max(*param,minval),maxval);

}



/*************************************************************

	  end current filled line 

**************************************************************/



brk()

{

	if (OUTPOS) put(OUTBUF);

	OUTW=OUTPOS=OUTTOP=OUTBOT=OUTWRDS = 0;

	OUTBUF[0] = '\0';

}



/****************************************/



need(n)			/*test for space before footer*/

int n;			/*whole lines*/

{

	if (( VLINENO>=(BOTTOM-n) ) && (BOTTOM>=VLINENO) )

	{

		space(HUGE); 

		NEWPAG= ++CURPAG;

	}

}

