/* $Header: E:\SRC\UUPC\RN\RCS/TERM.H 1.1 1992/11/21 06:14:58 ahd Exp $
 *
 * $Log: TERM.H $
 * Revision 1.1  1992/11/21  06:14:58  ahd
 * Initial
 *
 *
 *    Rev 1.0   18 Nov 1990  0:22:34
 * Initial revision.
 * Revision 4.3.2.2  90/04/06  20:35:34  sob
 * Added fixes for SCO Xenix sent by ronald@robobar.co.uk.
 *
 * Revision 4.3.2.1  89/11/28  01:54:03  sob
 * Added better support for SIGWINCH.
 *
 * Revision 4.3.1.2  85/05/13  15:52:05  lwall
 * Declared devtty on TERMIO system.
 *
 * Revision 4.3.1.1  85/05/10  11:41:24  lwall
 * Branch for patches.
 *
 * Revision 4.3  85/05/01  11:51:36  lwall
 * Baseline for release with 4.3bsd.
 *
 */

#ifdef PUSHBACK
  EXT char circlebuf[PUSHSIZE];
  EXT int nextin INIT(0);
  EXT int nextout INIT(0);
# ifdef PENDING

#   ifdef FIONREAD
      EXT long iocount INIT(0);
#     ifndef lint
#       define input_pending() (nextin!=nextout || (ioctl(0, FIONREAD, &iocount),(int)iocount))
#     else
#       define input_pending() bizarre
#     endif /* lint */
#     define PEND_OK
#   endif /* FIONREAD */

#   if   defined(RDCHK) && !defined(PEND_OK)
#     define input_pending() (rdchk(0) > 0)     /* boolean only */
#     define PEND_OK
#   endif /*  RDCHK */

#   if defined(msdos) && !defined(PEND_OK)
#     define input_pending() kbhit()
#     define PEND_OK
#   endif /* msdos */

#   ifndef PEND_OK
      int circfill();
      EXT int devtty INIT(0);
#     ifndef lint
#       define input_pending() (nextin!=nextout || circfill())
#     else
#       define input_pending() bizarre
#     endif /* lint */
#   endif /* PEND_OK */

# else /* PENDING */
#   ifndef lint
#     define input_pending() (nextin!=nextout)
#   else
#     define input_pending() bizarre
#   endif /* lint */
# endif /* PENDING */

#else /* PUSHBACK */
# ifdef PENDING
#   ifdef FIONREAD   /* must have FIONREAD or O_NDELAY for input_pending() */
#     define read_tty(addr,size) read(0,addr,size)
#     ifndef lint
#       define input_pending() (ioctl(0, FIONREAD, &iocount),(int)iocount)
#     else
#       define input_pending() bizarre
#     endif /* lint */
      EXT long iocount INIT(0);
#     define PEND_OK
#   endif /* FIONREAD */

#   if defined(RDCHK) && !defined(PEND_OK)
#     define input_pending() (rdchk(0) > 0)     /* boolean only */
#     define PEND_OK
#   endif /*  RDCHK */
#   if defined(msdos) && !defined(PEND_OK)
#     define input_pending() kbhit()
#     define PEND_OK
#   endif /* msdos */

#   ifndef PEND_OK
      EXT int devtty INIT(0);
      EXT bool is_input INIT(FALSE);
      EXT char pending_ch INIT(0);
#     ifndef lint
#       define input_pending() (is_input || (is_input=read(devtty,&pending_ch,1)))
#     else
#       define input_pending() bizarre
#     endif /* lint */
#   endif /*  PEND_OK */

# else /* PENDING */
#   define read_tty(addr,size) read(0,addr,size)
#   define input_pending() (FALSE)
# endif /* PENDING */
#endif /* PUSHBACK */

/* stuff wanted by terminal mode diddling routines */

#ifdef TERMIO
EXT struct termio _tty, _oldtty;
#else
#ifndef msdos
EXT struct sgttyb _tty;
EXT int _res_flg INIT(0);
#endif
#endif

EXT int _tty_ch INIT(2);
EXT bool bizarre INIT(FALSE);       /* do we need to restore terminal? */

/* terminal mode diddling routines */

#if   unix
#ifdef TERMIO

#define crmode() ((bizarre=1),_tty.c_lflag &=~ICANON,_tty.c_cc[VMIN] = 1,ioctl(_tty_ch,TCSETAF,&_tty))
#define nocrmode() ((bizarre=1),_tty.c_lflag |= ICANON,_tty.c_cc[VEOF] = CEOF,stty(_tty_ch,&_tty))
#define echo()  ((bizarre=1),_tty.c_lflag |= ECHO, ioctl(_tty_ch, TCSETA, &_tty))
#define noecho() ((bizarre=1),_tty.c_lflag &=~ECHO, ioctl(_tty_ch, TCSETA, &_tty))
#define nl()    ((bizarre=1),_tty.c_iflag |= ICRNL,_tty.c_oflag |= ONLCR,ioctl(_tty_ch, TCSETAW, &_tty))
#define nonl()  ((bizarre=1),_tty.c_iflag &=~ICRNL,_tty.c_oflag &=~ONLCR,ioctl(_tty_ch, TCSETAW, &_tty))
#define  savetty() (ioctl(_tty_ch, TCGETA, &_oldtty),ioctl(_tty_ch, TCGETA, &_tty))
#define  resetty() ((bizarre=0),ioctl(_tty_ch, TCSETAF, &_oldtty))
#define unflush_output()

#else

#define raw()   ((bizarre=1),_tty.sg_flags|=RAW, stty(_tty_ch,&_tty))
#define noraw()    ((bizarre=1),_tty.sg_flags&=~RAW,stty(_tty_ch,&_tty))
#define crmode() ((bizarre=1),_tty.sg_flags |= CBREAK, stty(_tty_ch,&_tty))
#define nocrmode() ((bizarre=1),_tty.sg_flags &= ~CBREAK,stty(_tty_ch,&_tty))
#define echo()  ((bizarre=1),_tty.sg_flags |= ECHO, stty(_tty_ch, &_tty))
#define noecho() ((bizarre=1),_tty.sg_flags &= ~ECHO, stty(_tty_ch, &_tty))
#define nl()    ((bizarre=1),_tty.sg_flags |= CRMOD,stty(_tty_ch, &_tty))
#define nonl()  ((bizarre=1),_tty.sg_flags &= ~CRMOD, stty(_tty_ch, &_tty))
#define  savetty() (gtty(_tty_ch, &_tty), _res_flg = _tty.sg_flags)
#define  resetty() ((bizarre=0),_tty.sg_flags = _res_flg, stty(_tty_ch, &_tty))
#ifdef LFLUSHO
#ifndef lint
EXT int lflusho INIT(LFLUSHO);
#else
EXT long lflusho INIT(LFLUSHO);
#endif /* lint */
#define unflush_output() (ioctl(_tty_ch,TIOCLBIC,&lflusho))
#else
#define unflush_output()
#endif /* LFLUSHO */
#endif /* TERMIO */
#endif   /* unix */

#ifdef TIOCSTI
#ifdef lint
#define forceme(c) ioctl(_tty_ch,TIOCSTI,Null(long*)) /* ghad! */
#else
#define forceme(c) ioctl(_tty_ch,TIOCSTI,c) /* pass character in " " */
#endif /* lint */
#else
#define forceme(c)
#endif

/* termcap stuff */

/*
 * NOTE: if you don't have termlib you'll either have to define these strings
 *    and the tputs routine, or you'll have to redefine the macros below
 */

#ifdef HAVETERMLIB
EXT char *BC INIT(Nullch);    /* backspace character */
EXT char *UP INIT(Nullch);    /* move cursor up one line */
EXT char *CR INIT(Nullch);    /* get to left margin, somehow */
EXT char *VB INIT(Nullch);    /* visible bell */
EXT char *CL INIT(Nullch);    /* home and clear screen */
EXT char *CE INIT(Nullch);    /* clear to end of line */
#ifdef CLEAREOL
EXT char *CM INIT(Nullch);    /* cursor motion -- PWP */
EXT char *HO INIT(Nullch);    /* home cursor -- PWP */
EXT char *CD INIT(Nullch);    /* clear to end of display -- PWP */
#endif /* CLEAREOL */
EXT char *SO INIT(Nullch);    /* begin standout mode */
EXT char *SE INIT(Nullch);    /* end standout mode */
EXT int SG INIT(0);     /* blanks left by SO and SE */
EXT char *US INIT(Nullch);    /* start underline mode */
EXT char *UE INIT(Nullch);    /* end underline mode */
EXT char *UC INIT(Nullch);    /* underline a character, if that's how it's done */
EXT int UG INIT(0);     /* blanks left by US and UE */
EXT bool AM INIT(FALSE);      /* does terminal have automatic margins? */
EXT bool XN INIT(FALSE);      /* does it eat 1st newline after automatic wrap? */
EXT char PC INIT(0);    /* pad character for use by tputs() */
EXT short ospeed INIT(0);  /* terminal output speed, for use by tputs() */
EXT int LINES INIT(0), COLS INIT(0);   /* size of screen */
EXT int just_a_sec INIT(960);       /* 1 sec at current baud rate */
               /* (number of nulls) */

/* define a few handy macros */

#define backspace() tputs(BC,0,putchr) FLUSH
#define clear() tputs(CL,LINES,putchr) FLUSH
#define erase_eol() tputs(CE,1,putchr) FLUSH
#ifdef CLEAREOL
#define clear_rest() tputs(CD,LINES,putchr) FLUSH  /* PWP */
#define maybe_eol() if(erase_screen&&can_home_clear)tputs(CE,1,putchr) FLUSH
#endif /* CLEAREOL */
#define underline() tputs(US,1,putchr) FLUSH
#define un_underline() tputs(UE,1,putchr) FLUSH
#define underchar() tputs(UC,0,putchr) FLUSH
#define standout() tputs(SO,1,putchr) FLUSH
#define un_standout() tputs(SE,1,putchr) FLUSH
#define up_line() tputs(UP,1,putchr) FLUSH
#define carriage_return() tputs(CR,1,putchr) FLUSH
#define dingaling() tputs(VB,1,putchr) FLUSH
#else
#ifdef   msdos
EXT int LINES INIT(25), COLS INIT(80); /* size of screen */
#define BC "\b"      /* backspace character */
#define UP "\033[A"     /* move cursor up one line */
#define CR "\r"      /* get to left margin, somehow */
#define VB "\007"    /* visible bell */
#define CL "\033[H\033[J"     /* home and clear screen */
#define CE "\033[K"     /* clear to end of line */
#ifdef CLEAREOL
#define CM ""        /* cursor motion -- PWP */
#define HO "\033[H"     /* home cursor -- PWP */
#define CD "\033[J"     /* clear to end of display -- PWP */
#endif /* CLEAREOL */
#define SO "\033[1m"    /* begin standout mode */
#define SE "\033[0m"    /* end standout mode */
#define SG 0      /* blanks left by SO and SE */
#define US "\033[1m"    /* start underline mode */
#define UE "\033[0m"    /* end underline mode */
#define UC ""     /* underline a character, if that's how it's done */
#define UG 0      /* blanks left by US and UE */
#define AM 1      /* does terminal have automatic margins? */
#define XN 0      /* does it eat 1st newline after automatic wrap? */
#define ospeed B19200   /* terminal output speed, for use by tputs() */
#define  just_a_sec 1000         /* pad takes units of ms */
#define backspace() tputs(BC,0,putchr) FLUSH
#define clear() tputs(CL,LINES,putchr) FLUSH
#define erase_eol() tputs(CE,1,putchr) FLUSH
#ifdef CLEAREOL
#define clear_rest() tputs(CD,LINES,putchr) FLUSH  /* PWP */
#define maybe_eol() if(erase_screen&&can_home_clear)tputs(CE,1,putchr) FLUSH
#endif /* CLEAREOL */
#define underline() tputs(US,1,putchr) FLUSH
#define un_underline() tputs(UE,1,putchr) FLUSH
#define underchar() tputs(UC,0,putchr) FLUSH
#define standout() tputs(SO,1,putchr) FLUSH
#define un_standout() tputs(SE,1,putchr) FLUSH
#define up_line() tputs(UP,1,putchr) FLUSH
#define carriage_return() tputs(CR,1,putchr) FLUSH
#define dingaling() tputs(VB,1,putchr) FLUSH
#define  tputs(s, npad, f) fputs(s, stdout)
#else
  ????????     /* up to you */
#endif
#endif

EXT int page_line INIT(1); /* line number for paging in print_line (origin 1) */

void  term_init();
void  term_set();
#ifdef PUSHBACK
void  pushchar();
void  mac_init();
void  mac_line();
void  show_macros();
#endif
char  putchr();   /* routine for tputs to call */
bool  finish_command();
void  eat_typeahead();
void  settle_down();
#ifndef read_tty
    int     read_tty();
#endif
void  underprint();
#ifdef NOFIREWORKS
    void no_sofire();
    void no_ulfire();
#endif
void  getcmd();
int   get_anything();
void  in_char();
int   print_lines();
void  page_init();
void  pad();
void  printcmd();
void  rubout();
void  reprint();
#ifdef CLEAREOL
void  home_cursor();
#endif /* CLEAREOL */
#ifdef SIGWINCH
int   winch_catcher();
#endif /* SIGWINCH */

#ifdef   msdos
#define  B19200   19200
#define  B9600 9600
#define  B4800 4800
#endif   /* msdos */

/*--------------------------------------------------------------------*/
/*                         Defined in TERM.C                          */
/*--------------------------------------------------------------------*/

extern stripcr( char *s);
extern noecho( void );
char *tgoto(char *common, int x, int y);
extern crmode( void );
extern unflush_output( void );
extern savetty( void );
extern resetty( void );
