/*
 * This routine implements rnmail, the rn function that replies to
 * an article.
 *
 * We expect a command like like:
 *
 * <rndir>/rnmail -h %h
 *
 *
 * (<rndir> is the directory that holds the rn utilities (e.g. d:/lib/uupc/news/rn)
 *  %h      is the name of the header file (which might contain the article)
 * )
 *
 */

#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <process.h>
#include <errno.h>
#include <string.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXDIR FILENAME_MAX
#endif

#include <time.h>

#include "version.h"

#define FALSE 0
#define FROMLINE "From: "
#define DATELINE "Date: "
#define REPLYTOLINE "Reply-To: "

#define MAIL_IDENT "\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01"

extern char *tempdir;
extern char *domain;
extern char *mailbox;
extern char *replyto;
extern char *E_filesent;
extern char *E_homedir;
extern char *E_editor;
extern char *E_signature;



char *fail_reasons[] = {
   "Arg list too long",
   "Invalid modeflag",
   "Program not found",
   "File not a program",
   "Not enough memory",
   "Unknown reason"
};


char *getval(char *nam, char *def);
void hostinit(int);


int spawn_fail(int code)
{

   switch (code)
   {
      case E2BIG:return 0;
    case EINVAL:
      return 1;
    case ENOENT:
      return 2;
    case ENOEXEC:
      return 3;
    case ENOMEM:
      return 4;
    default:
      return 5;
   }
}


int
  main(argc, argv)
   int argc;
   char **argv;
{

   char temp_reply[MAXDIR];  /* File name of temp
                              * file to send to rmail */

   /* (also used to hold the name of the editor */
   char *editor;
   char *default_editor;

   int i;
   int j;

   char t;

   FILE *f_edit;
   FILE *f_reply;
   FILE *f_filesent;
   char buff[BUFSIZ];

   struct tm *now;
   long tnow;
   char *months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

   hostinit(FALSE);

   banner(argv);
   printf("rnmail for rn %s\n", RN_VERSION);

   if (argc < 3)
   {
      printf("\nInvalid invocation of rnmail\n");
      return 1;
   }


   t = 'E';
   while (t != 'S')
   {
      if (t == 'E')
      {
         if (E_editor != NULL)
            default_editor = E_editor;
         else
            default_editor = "vi";
         strcpy(temp_reply, getval("VISUAL", getval("EDITOR", default_editor)));
         editor = strchr(temp_reply, ' ');
         if (editor != NULL)
         {
            editor[0] = '\0';/* get rid of that damn
                              * %s */
         }
         editor = temp_reply;
         j = spawnlp(P_WAIT, editor, editor, argv[2], NULL);
         if (j == -1)
         {
            printf("Unable to spawn %s (%s)\n", editor,
                   fail_reasons[spawn_fail(errno)]);
            return 1;
         }
      }
      else if (t == 'L')
      {
      }
      else if (t == 'A')
      {
         exit(1);
      }

      printf("\nAbort, Send, List, Edit? ");
      t = toupper(getche());
      printf("\n");
   }

/* OK.  Time to ship it.  Append the From:, Date:, and, if necessary,
   the Reply-To: lines.
*/
   strcpy(temp_reply, tempdir);
   strcat(temp_reply, "/rnmail.tmp");

   f_reply = fopen(temp_reply, "wb");
   strcpy(buff, FROMLINE);
   strcat(buff, mailbox);
   strcat(buff, "@");
   strcat(buff, domain);
   fprintf(f_reply, "%s\n", buff);

   tnow = time(NULL);
   now = gmtime(&tnow);
   fprintf(f_reply, "%s%d %s %d %2.2d:%2.2d:%2.2d GMT\n", DATELINE, now->tm_mday,
           months[now->tm_mon], now->tm_year,
           now->tm_hour, now->tm_min,
           now->tm_sec);

   if (replyto)
   {
      fprintf(f_reply, "%s%s\n", REPLYTOLINE, replyto);
   }

   f_edit = fopen(argv[2], "rb");

   while ((i = fread(buff, sizeof (char), sizeof (char), f_edit)) != 0)
   {
      fwrite(buff, sizeof (char), i, f_reply);
   }
   fclose(f_edit);

   if (E_signature != NULL)
   {
      t = ' ';
      while ((t != 'Y') && (t != 'N'))
      {
         printf("\nAppend signature? (yn) ");
         t = toupper(getche());
      }
      printf("\n");
      if (t == 'Y')
      {
         f_edit = fopen(E_signature, "rt");
         if (f_edit != NULL)
         {
            fprintf(f_reply, "--\n");
            while ((i = fread(buff, sizeof (char), sizeof (char), f_edit)) != 0)
            {
               fwrite(buff, sizeof (char), i, f_reply);
            }
            fclose(f_edit);
         }
      }
   }
   fclose(f_reply);


   j = spawnlp(P_WAIT, "rmail", "rmail", "-t", "-x", "1", "-f", temp_reply, NULL);

/* If the user is saving their mail, append this one to FileSent */
   if (j == 0)
   {
      if (E_filesent)
      {
         /* Use buff to build name (we are tight on space) */
         /* Append the home directory unless the user specified the root */
         if (((E_filesent[0] == '/') || (E_filesent[0] == '\\')) ||
               ((E_filesent[1] == ':') &&
                ((E_filesent[2] == '/') || (E_filesent[2] == '\\'))))
         {
            strcpy(buff, E_filesent);
         }
         else
         {
            strcpy(buff, E_homedir);
            strcat(buff, "/");
            strcat(buff, E_filesent);
         }

         f_filesent = fopen(buff, "ab");
         if (f_filesent != NULL)
         {
            fprintf(f_filesent, "%s\n", MAIL_IDENT);
            f_reply = fopen(temp_reply, "rb");
            while ((i = fread(buff, sizeof (char), sizeof (char), f_reply)) != 0)
            {
               fwrite(buff, sizeof (char), i, f_filesent);
            }
         }
         fclose(f_filesent);
         fclose(f_reply);
      }
   }
   else
   {
      if (j == -1)
      {
         printf("Unable to spawn %s (%s)\n", "rmail",
                fail_reasons[spawn_fail(errno)]);

      }
   }

   unlink(temp_reply);

   return 0;
}



char *
  getval(nam, def)
   char *nam, *def;
{
   char *val;

   if ((val = getenv(nam)) == NULL || !*val)
      val = def;
   return val;
}
