

/* This is basically a rip off of the DeliverRemote routine from
 * the mail package.  What should really be added is a uux
 * package but until that time ...
 *
 * Some comments and variable names might be a bit strange
 * because of the ripoff nature of this code.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "getseq.h"
#include "lib.h"

/*--------------------------------------------------------------------*/
/*    D e l i v e r R e m o t e                                       */
/*                                                                    */
/*    Queue mail for delivery on another system via UUCP              */
/*--------------------------------------------------------------------*/

int DeliverNews(const char *input,      /* Input file name    */
                  const char *path)     /* News server */
{
   static char *spool_fmt = SPOOLFMT;   /* spool file name */
   static char *send_cmd = "S %s %s %s - %s 0666\n";
   FILE *stream;             /* For writing out data                */
   long seqno;

   char msfile[FILENAME_MAX];/* MS-DOS format name of
                              * files         */
   char msname[22];          /* MS-DOS format w/o
                              * path name         */

   char tmfile[15];          /* Call file, UNIX
                              * format name         */
   static char ixfile[15];   /* eXecute file for
                              * remote system, UNIX
                              * format name for local
                              * system   */
   static char idfile[15];   /* Data file, UNIX
                              * format name         */
   static char rdfile[15];   /* Data file name on
                              * remote system, UNIX
                              * format                         */
   static char rxfile[15];   /* Remote system UNIX
                              * name of eXecute file                                */
   char *seq;

   printf("Spooling news article from %s via %s",
          E_mailbox,
          path);

/*--------------------------------------------------------------------*/
/*          Create the UNIX format of the file names we need          */
/*--------------------------------------------------------------------*/

   seqno = getseq();
   seq = JobNumber(seqno);

   sprintf(idfile, spool_fmt, 'D', E_nodename, '0', seq);
   sprintf(rdfile, spool_fmt, 'D', E_nodename, '1', seq);
   sprintf(tmfile, spool_fmt, 'C', path, '2', seq);
   sprintf(rxfile, spool_fmt, 'X', E_nodename, '3', seq);
   sprintf(ixfile, spool_fmt, 'D', E_nodename, '4', seq);

/*--------------------------------------------------------------------*/
/*                     create remote X (xqt) file                     */
/*--------------------------------------------------------------------*/

   importpath(msname, ixfile, path);
   mkfilename(msfile, E_spooldir, msname);

   stream = fopen(msfile, "wb");
   if (stream == NULL)
   {
      printerr(msfile);
      printf("DeliverNews: cannot open X file %s", msfile);
      return 1;
   }                         /* if */


   fprintf(stream, "R %s %s\nU %s %s\nF %s\nI %s\nC rnews\n",
           E_mailbox, E_nodename,
           E_mailbox, E_nodename,
           rdfile, rdfile);
   fclose(stream);


/*--------------------------------------------------------------------*/
/*  Create the data file with the mail to send to the remote system   */
/*--------------------------------------------------------------------*/

   importpath(msname, idfile, path);
   mkfilename(msfile, E_spooldir, msname);

   stream = fopen(msfile, "wb");
   if (stream == NULL)
   {
      printerr(msfile);
      printf("DeliverNews: Cannot open spool file \"%s\" for output", msfile);
      return 1;
   }

   if (!CopyData(input, stream))
   {
      remove(msfile);
      return 1;
   }

/*--------------------------------------------------------------------*/
/*                     create local C (call) file                     */
/*--------------------------------------------------------------------*/

   importpath(msname, tmfile, path);
   mkfilename(msfile, E_spooldir, msname);

   stream = fopen(msfile, "wt");
   if (stream == NULL)
   {
      printerr(msname);
      printf("DeliverNews: cannot open C file %s", msfile);
      return 1;
   }

   fprintf(stream, send_cmd, idfile, rdfile,
           E_mailbox,
           idfile);
   fprintf(stream, send_cmd, ixfile, rxfile,
           E_mailbox,
           ixfile);
   fclose(stream);

   return 0;
}                            /* DeliverNews */

/*--------------------------------------------------------------------*/
/* C o p y D a t a                                                    */
/*                                                                    */
/* Copy data into its final resting spot                              */
/*--------------------------------------------------------------------*/

int CopyData(const char *input,
               FILE * dataout)
{
   FILE *datain = fopen(input, "rb");
   char buf[BUFSIZ];
   struct stat statbuf;
   int success = TRUE;

/*--------------------------------------------------------------------*/
/*                      Verify the input opened                       */
/*--------------------------------------------------------------------*/

   if (datain == NULL)
   {
      printerr(input);
      printf("Unable to open input file \"%s\"", input);
      fclose(dataout);
      return 0;
   }                         /* datain */

/*--------------------------------------------------------------------*/
/*                 Add the #! rnews nnn line                          */
/*--------------------------------------------------------------------*/

   fstat(fileno(datain), &statbuf);
   fprintf(dataout, "#! rnews %ld\n", statbuf.st_size);

/*--------------------------------------------------------------------*/
/*                       Loop to copy the data                        */
/*--------------------------------------------------------------------*/

   while (fgets(buf, BUFSIZ, datain) != NULL)
   {
      if (fputs(buf, dataout) == EOF)   /* I/O error?               */
      {
         printerr("output");
         printf("I/O error on \"%s\"", "output");
         fclose(dataout);
         return 0;
      }                      /* if */
   }                         /* while */

/*--------------------------------------------------------------------*/
/*                      Close up shop and return                      */
/*--------------------------------------------------------------------*/

   if (ferror(datain))       /* Clean end of file on
                              * input?         */
   {
      printerr(input);
      clearerr(datain);
      success = FALSE;
   }

   fclose(datain);
   fclose(dataout);
   return success;
}                            /* CopyData */
