# CKXKER.MAK, Version 1.1, 18 May 88
#
# -- Makefile to build C-Kermit for Minix, 
#                      -- using Lattice 3.10 compiler under MS-DOS.
#                      -- using Lattice make utility "lmk"
#
# Before proceeding, rename this file to "lmkfile", chop cktker.inp off the
# bottom, and set the include path variable so Lattice can find <.h> and 
# <sys/.h> files. e.g.
# 'set INCLUDE=\minix\usr\include\'
# for minix /usr/include files in the DOS directory \minix\usr\include.
# Perhaps there's a way to do this SET from the makefile ???
#
##############################################################################
#
# Notes:
#	Since wart is run on DOS to generate ckcpro.c, some fiddling 
#	has to be done to avoid getting MINIX stdio.h and ctype.h
#	compiled into wart.exe.
#
#
###########################################################################
#
#  Compile and Link variables:
#
LIB=a:\\		# where DOS library is
MXLIB=a:\\		# where MINIX library is
CC=lc
TMP=c:			# where compiler temporary files go
#
# Use this macro if debug and transaction logging is required.
#
CFLAGS=-ms -n -cw -v -q$(TMP) -u -i./ -dV7 -dDEBUG -dTLOG -dMINIX 
#
# Disabling debugging appears (surprisingly) to offer very little
# improvement (other than a 10K size decrease).
#
# CFLAGS=-ms -n -cw -v -q$(TMP) -u -i./ -dV7 -dMINIX
#
###########################################################################
#
# Dependencies Section:
#

wermit.out: wermit.exe
	dos2out -p wermit

wermit.exe: ckcmai.obj ckucmd.obj ckuusr.obj ckuus2.obj ckuus3.obj \
		ckcpro.obj ckcfns.obj ckcfn2.obj ckucon.obj ckxtio.obj \
		ckxfio.obj ckudia.obj ckuscr.obj
	link $(MXLIB)crtso.obj emlib.obj setjmp.obj @cktker.inp, \
		c:wermit,c:wermit/map,$(MXLIB)libc.lib

ckcmai.obj: ckcmai.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckuusr.obj: ckuusr.c ckucmd.h ckcker.h ckuusr.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckuus2.obj: ckuus2.c ckucmd.h ckcker.h ckuusr.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckuus3.obj: ckuus3.c ckucmd.h ckcker.h ckuusr.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckucmd.obj: ckucmd.c ckucmd.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckcpro.obj: ckcpro.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckcfns.obj: ckcfns.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckcfn2.obj: ckcfn2.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckxfio.obj: ckxfio.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckxtio.obj: ckxtio.c ckcdeb.h
	$(CC) $(CFLAGS) $*

ckucon.obj: ckucon.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckudia.obj: ckudia.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

ckuscr.obj: ckuscr.c ckcker.h ckcdeb.h
	$(CC) $(CFLAGS) $*

#
# Be careful building wart - it must use Lattice (i.e DOS) include files, 
# not MINIX ones. Hence not part of the main target.
#
# ckcpro.c: ckcpro.w wart.exe
#	wart ckcpro.w ckcpro.c
#
# wart: ckwart.o
#	$(CC) $(LNKFLAGS) -o wart ckwart.o
#
# ckwart.o: ckwart.c
#

# ***********************************************************************
# The following text is the input file cktker.inp, for the MS-DOS linker.
# It is included as part of this file to keep the fragments of the build
# files in one place. Remove it from this file before attempting to use
# lmk.
# ***********************************************************************

ckcmai.obj ckucmd.obj ckuusr.obj ckuus2.obj ckuus3.obj +
ckcpro.obj ckcfns.obj ckcfn2.obj ckucon.obj ckxtio.obj +
ckxfio.obj ckudia.obj ckuscr.obj

